/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.connectionmanagerconfig;

import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.MultiPoolConnectionInterceptor;
import org.apache.geronimo.connector.outbound.PoolingAttributes;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;

public class PartitionedPool
implements PoolingSupport {
    private static final long serialVersionUID = -4843669262711657990L;
    private boolean partitionByConnectionRequestInfo;
    private boolean partitionBySubject;
    private final SinglePool singlePool;
    private transient PoolingAttributes poolingAttributes;

    public PartitionedPool(int maxSize, int minSize, int blockingTimeoutMilliseconds, int idleTimeoutMinutes, boolean matchOne, boolean matchAll, boolean selectOneAssumeMatch, boolean partitionByConnectionRequestInfo, boolean partitionBySubject) {
        this.singlePool = new SinglePool(maxSize, minSize, blockingTimeoutMilliseconds, idleTimeoutMinutes, matchOne, matchAll, selectOneAssumeMatch);
        this.partitionByConnectionRequestInfo = partitionByConnectionRequestInfo;
        this.partitionBySubject = partitionBySubject;
    }

    public boolean isPartitionByConnectionRequestInfo() {
        return this.partitionByConnectionRequestInfo;
    }

    public void setPartitionByConnectionRequestInfo(boolean partitionByConnectionRequestInfo) {
        this.partitionByConnectionRequestInfo = partitionByConnectionRequestInfo;
    }

    public boolean isPartitionBySubject() {
        return this.partitionBySubject;
    }

    public void setPartitionBySubject(boolean partitionBySubject) {
        this.partitionBySubject = partitionBySubject;
    }

    public int getMaxSize() {
        return this.singlePool.getMaxSize();
    }

    public void setMaxSize(int maxSize) {
        this.singlePool.setMaxSize(maxSize);
    }

    public int getBlockingTimeoutMilliseconds() {
        return this.poolingAttributes.getBlockingTimeoutMilliseconds();
    }

    public void setBlockingTimeoutMilliseconds(int blockingTimeoutMilliseconds) {
        this.poolingAttributes.setBlockingTimeoutMilliseconds(blockingTimeoutMilliseconds);
    }

    public int getIdleTimeoutMinutes() {
        return this.poolingAttributes.getIdleTimeoutMinutes();
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.poolingAttributes.setIdleTimeoutMinutes(idleTimeoutMinutes);
    }

    public boolean isMatchOne() {
        return this.singlePool.isMatchOne();
    }

    public void setMatchOne(boolean matchOne) {
        this.singlePool.setMatchOne(matchOne);
    }

    public boolean isMatchAll() {
        return this.singlePool.isMatchAll();
    }

    public void setMatchAll(boolean matchAll) {
        this.singlePool.setMatchAll(matchAll);
    }

    public boolean isSelectOneAssumeMatch() {
        return this.singlePool.isSelectOneAssumeMatch();
    }

    public void setSelectOneAssumeMatch(boolean selectOneAssumeMatch) {
        this.singlePool.setSelectOneAssumeMatch(selectOneAssumeMatch);
    }

    public ConnectionInterceptor addPoolingInterceptors(ConnectionInterceptor tail) {
        MultiPoolConnectionInterceptor pool = new MultiPoolConnectionInterceptor(tail, this.singlePool, this.isPartitionBySubject(), this.isPartitionByConnectionRequestInfo());
        this.poolingAttributes = pool;
        return pool;
    }

    public int getPartitionCount() {
        return this.poolingAttributes.getPartitionCount();
    }

    public int getPartitionMaxSize() {
        return this.poolingAttributes.getPartitionMaxSize();
    }

    public void setPartitionMaxSize(int maxSize) throws InterruptedException {
        this.poolingAttributes.setPartitionMaxSize(maxSize);
    }

    public int getPartitionMinSize() {
        return this.poolingAttributes.getPartitionMinSize();
    }

    public void setPartitionMinSize(int minSize) {
        this.poolingAttributes.setPartitionMinSize(minSize);
    }

    public int getIdleConnectionCount() {
        return this.poolingAttributes.getIdleConnectionCount();
    }

    public int getConnectionCount() {
        return this.poolingAttributes.getConnectionCount();
    }
}

