/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.useradmin;

import java.io.IOException;
import java.util.ArrayList;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.eclipse.gemini.management.internal.OSGiProperties;
import org.eclipse.gemini.management.useradmin.internal.OSGiAuthorization;
import org.eclipse.gemini.management.useradmin.internal.OSGiGroup;
import org.eclipse.gemini.management.useradmin.internal.OSGiRole;
import org.eclipse.gemini.management.useradmin.internal.OSGiUser;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.jmx.service.useradmin.UserAdminMBean;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

public final class UserManager
implements UserAdminMBean {
    private UserAdmin admin;

    public UserManager(UserAdmin admin) {
        this.admin = admin;
    }

    public void addCredential(String key, byte[] value, String username) throws IOException {
        User user;
        if (username == null) {
            throw new IOException("User name must not be null");
        }
        if (key == null) {
            throw new IOException("Credential key must not be null");
        }
        try {
            user = (User)this.admin.getRole(username);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a User: " + username);
        }
        if (user == null) {
            throw new IOException("Not a User: " + username);
        }
        user.getCredentials().put(key, value);
    }

    public void addCredentialString(String key, String value, String username) throws IOException {
        User user;
        if (username == null) {
            throw new IOException("User name must not be null");
        }
        if (key == null) {
            throw new IOException("Credential key must not be null");
        }
        try {
            user = (User)this.admin.getRole(username);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a User: " + username);
        }
        if (user == null) {
            throw new IOException("Not a User: " + username);
        }
        user.getCredentials().put(key, value);
    }

    public boolean addMember(String groupname, String rolename) throws IOException {
        if (groupname == null) {
            throw new IOException("Group name must not be null");
        }
        if (rolename == null) {
            throw new IOException("Role name must not be null");
        }
        Role group = this.admin.getRole(groupname);
        if (group == null) {
            throw new IOException("Group does not exist: " + groupname);
        }
        Role role = this.admin.getRole(rolename);
        if (role == null) {
            throw new IOException("Role does not exist: " + rolename);
        }
        return group.getType() == 2 && ((Group)group).addMember(role);
    }

    public void addProperty(String key, byte[] value, String rolename) throws IOException {
        if (rolename == null) {
            throw new IOException("Role name must not be null");
        }
        if (key == null) {
            throw new IOException("Credential key must not be null");
        }
        Role role = this.admin.getRole(rolename);
        if (role == null) {
            throw new IOException("Role does not exist: " + rolename);
        }
        role.getProperties().put(key, value);
    }

    public void addPropertyString(String key, String value, String rolename) throws IOException {
        if (rolename == null) {
            throw new IOException("Role name must not be null");
        }
        if (key == null) {
            throw new IOException("Credential key must not be null");
        }
        Role role = this.admin.getRole(rolename);
        if (role == null) {
            throw new IOException("Role does not exist: " + rolename);
        }
        role.getProperties().put(key, value);
    }

    public boolean addRequiredMember(String groupname, String rolename) throws IOException {
        if (groupname == null) {
            throw new IOException("Group name must not be null");
        }
        Role group = this.admin.getRole(groupname);
        if (group == null) {
            throw new IOException("Group does not exist: " + rolename);
        }
        Role role = this.admin.getRole(rolename);
        if (role == null) {
            throw new IOException("Role does not exist: " + rolename);
        }
        return group.getType() == 2 && ((Group)group).addRequiredMember(role);
    }

    public void createGroup(String name) throws IOException {
        if (name == null) {
            throw new IOException("Name must not be null");
        }
        this.admin.createRole(name, 2);
    }

    public void createUser(String name) throws IOException {
        if (name == null) {
            throw new IOException("Name must not be null");
        }
        this.admin.createRole(name, 1);
    }

    public void createRole(String name) throws IOException {
        throw new UnsupportedOperationException("This method is deprecated and does not work");
    }

    public CompositeData getAuthorization(String u) throws IOException {
        User user;
        if (u == null) {
            throw new IOException("User name must not be null");
        }
        try {
            user = (User)this.admin.getRole(u);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a user: " + u);
        }
        try {
            return new OSGiAuthorization(this.admin.getAuthorization(user)).asCompositeData();
        }
        catch (OpenDataException e) {
            throw new IOException("Unable to create open data type: " + e);
        }
    }

    public TabularData getCredentials(String username) throws IOException {
        User user;
        if (username == null) {
            throw new IOException("User name must not be null");
        }
        try {
            user = (User)this.admin.getRole(username);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a user: " + username);
        }
        if (user == null) {
            throw new IOException("Not a user: " + username);
        }
        return OSGiProperties.tableFrom(user.getCredentials());
    }

    public CompositeData getGroup(String groupname) throws IOException {
        Group group;
        if (groupname == null) {
            throw new IOException("Group name must not be null");
        }
        try {
            group = (Group)this.admin.getRole(groupname);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a group: " + groupname);
        }
        try {
            return new OSGiGroup(group).asCompositeData();
        }
        catch (OpenDataException e) {
            throw new IOException("Cannot encode open data for group: " + e);
        }
    }

    public String[] listGroups() throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Cannot use null filter, apparently: " + (Object)((Object)e));
        }
        ArrayList<String> groups = new ArrayList<String>();
        Role[] roleArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            if (role.getType() == 2) {
                groups.add(role.getName());
            }
            ++n2;
        }
        return groups.toArray(new String[groups.size()]);
    }

    public String[] getGroups(String filter) throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IOException("Invalid filter: " + (Object)((Object)e));
        }
        ArrayList<String> groups = new ArrayList<String>();
        Role[] roleArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            if (role.getType() == 2) {
                groups.add(role.getName());
            }
            ++n2;
        }
        return groups.toArray(new String[groups.size()]);
    }

    public String[] getImpliedRoles(String username) throws IOException {
        if (username == null) {
            throw new IOException("Name must not be null");
        }
        Role role = this.admin.getRole(username);
        if (role.getType() == 1 && role instanceof User) {
            return this.admin.getAuthorization((User)role).getRoles();
        }
        return new String[0];
    }

    public String[] getMembers(String groupname) throws IOException {
        Group group;
        if (groupname == null) {
            throw new IOException("Name must not be null");
        }
        try {
            group = (Group)this.admin.getRole(groupname);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a group: " + groupname);
        }
        Role[] members = group.getMembers();
        if (members == null) {
            return new String[0];
        }
        String[] names = new String[members.length];
        int i = 0;
        while (i < members.length) {
            names[i] = members[i].getName();
            ++i;
        }
        return names;
    }

    public TabularData getProperties(String rolename) throws IOException {
        if (rolename == null) {
            throw new IOException("Name must not be null");
        }
        Role role = this.admin.getRole(rolename);
        if (role == null) {
            return null;
        }
        return OSGiProperties.tableFrom(role.getProperties());
    }

    public String[] getRequiredMembers(String groupname) throws IOException {
        Group group;
        if (groupname == null) {
            throw new IOException("Name must not be null");
        }
        try {
            group = (Group)this.admin.getRole(groupname);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a group: " + groupname);
        }
        Role[] members = group.getRequiredMembers();
        if (members == null) {
            return new String[0];
        }
        String[] names = new String[members.length];
        int i = 0;
        while (i < members.length) {
            names[i] = members[i].getName();
            ++i;
        }
        return names;
    }

    public CompositeData getRole(String name) throws IOException {
        if (name == null) {
            throw new IOException("Name must not be null");
        }
        Role role = this.admin.getRole(name);
        try {
            return role == null ? null : new OSGiRole(role).asCompositeData();
        }
        catch (OpenDataException e) {
            throw new IOException("Unable to create open data: " + e);
        }
    }

    public String[] listRoles() throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Cannot use null filter, apparently: " + (Object)((Object)e));
        }
        String[] result = new String[roles.length];
        int i = 0;
        while (i < roles.length) {
            result[i] = roles[i].getName();
            ++i;
        }
        return result;
    }

    public String[] getRoles(String filter) throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IOException("Invalid filter: " + (Object)((Object)e));
        }
        String[] result = new String[roles.length];
        int i = 0;
        while (i < roles.length) {
            result[i] = roles[i].getName();
            ++i;
        }
        return result;
    }

    public CompositeData getUser(String username) throws IOException {
        User user;
        if (username == null) {
            throw new IOException("Name must not be null");
        }
        try {
            user = (User)this.admin.getRole(username);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a user: " + username);
        }
        try {
            return user == null ? null : new OSGiUser(user).asCompositeData();
        }
        catch (OpenDataException e) {
            throw new IOException("Unable to create open data: " + e);
        }
    }

    public String getUserWithProperty(String key, String value) throws IOException {
        if (key == null) {
            throw new IOException("Name must not be null");
        }
        User user = this.admin.getUser(key, value);
        return user == null ? null : user.getName();
    }

    public String[] listUsers() throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Cannot use null filter, apparently: " + (Object)((Object)e));
        }
        ArrayList<String> groups = new ArrayList<String>();
        Role[] roleArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            if (role.getType() == 1) {
                groups.add(role.getName());
            }
            ++n2;
        }
        return groups.toArray(new String[groups.size()]);
    }

    public String[] getUsers(String filter) throws IOException {
        Role[] roles;
        try {
            roles = this.admin.getRoles(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IOException("Invalid filter: " + (Object)((Object)e));
        }
        ArrayList<String> groups = new ArrayList<String>();
        Role[] roleArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            if (role.getType() == 1) {
                groups.add(role.getName());
            }
            ++n2;
        }
        return groups.toArray(new String[groups.size()]);
    }

    public void removeCredential(String key, String username) throws IOException {
        User user;
        if (username == null || username.length() == 0) {
            throw new IOException("Name must not be null or empty");
        }
        if (key == null) {
            throw new IOException("Credential key must not be null");
        }
        try {
            user = (User)this.admin.getRole(username);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a user: " + username);
        }
        if (user == null) {
            return;
        }
        user.getCredentials().remove(key);
    }

    public boolean removeMember(String groupname, String rolename) throws IOException {
        Group group;
        if (groupname == null) {
            throw new IOException("Group name must not be null");
        }
        if (rolename == null) {
            throw new IOException("Role name must not be null");
        }
        try {
            group = (Group)this.admin.getRole(groupname);
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a group: " + groupname);
        }
        if (group == null) {
            return false;
        }
        Role role = this.admin.getRole(rolename);
        if (role == null) {
            return false;
        }
        return group.removeMember(role);
    }

    public void removeProperty(String key, String rolename) throws IOException {
        if (rolename == null) {
            throw new IOException("Name must not be null");
        }
        Role role = this.admin.getRole(rolename);
        if (role == null) {
            return;
        }
        role.getProperties().remove(key);
    }

    public boolean removeRole(String name) throws IOException {
        if (name == null) {
            throw new IOException("Name must not be null");
        }
        return this.admin.removeRole(name);
    }

    public boolean removeUser(String name) throws IOException {
        if (name == null) {
            throw new IOException("Name must not be null");
        }
        return this.admin.removeRole(name);
    }

    public boolean removeGroup(String name) throws IOException {
        if (name == null) {
            throw new IOException("Name must not be null");
        }
        return this.admin.removeRole(name);
    }
}

