/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.HttpMsg;
import org.eclipse.equinox.http.Registration;
import org.eclipse.equinox.http.servlet.HttpServletRequestImpl;
import org.eclipse.equinox.http.servlet.HttpServletResponseImpl;

public class RequestDispatcherImpl
implements RequestDispatcher {
    protected Registration reg;
    protected String requestURI;

    public RequestDispatcherImpl(Registration reg, String requestURI) {
        this.reg = reg;
        this.requestURI = requestURI;
    }

    public void forward(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        try {
            HttpServletRequestImpl request = (HttpServletRequestImpl)req;
            HttpServletResponseImpl response = (HttpServletResponseImpl)res;
            if (response.gotStreamOrWriter()) {
                throw new IllegalStateException();
            }
            String newRequestLine = String.valueOf(request.getMethod()) + " " + this.requestURI + " " + request.getProtocol();
            request.parseRequestLine(newRequestLine);
            this.reg.service(request, response);
        }
        catch (ClassCastException e) {
            throw new ServletException(HttpMsg.HTTP_SERVLET_EXCEPTION, (Throwable)e);
        }
    }

    public void include(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        try {
            Response response = new Response(res);
            this.reg.service(req, (ServletResponse)response);
        }
        catch (ClassCastException e) {
            throw new ServletException(HttpMsg.HTTP_SERVLET_EXCEPTION, (Throwable)e);
        }
    }

    class Response
    implements HttpServletResponse {
        protected ServletResponse response;

        protected Response(ServletResponse response) {
            this.response = response;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            return this.response.getWriter();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.response.getOutputStream();
        }

        public String encodeRedirectURL(String url) {
            return null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public String encodeURL(String url) {
            return null;
        }

        public String encodeUrl(String url) {
            return null;
        }

        public void sendRedirect(String url) {
        }

        public boolean containsHeader(String header) {
            return false;
        }

        public void addCookie(Cookie cookie) {
        }

        public void sendError(int errorCode) {
        }

        public void sendError(int errorCode, String error) {
        }

        public void setContentLength(int length) {
        }

        public void setContentType(String contentType) {
        }

        public void setStatus(int status) {
        }

        public void setStatus(int status, String statusPhrase) {
        }

        public void setHeader(String key, String value) {
        }

        public void setIntHeader(String key, int value) {
        }

        public void setDateHeader(String key, long date) {
        }

        public void addDateHeader(String name, long date) throws UnsupportedOperationException {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public void addHeader(String name, String value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public void addIntHeader(String name, int value) throws UnsupportedOperationException {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public void flushBuffer() throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public int getBufferSize() throws UnsupportedOperationException {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public Locale getLocale() throws UnsupportedOperationException {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public boolean isCommitted() throws UnsupportedOperationException {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public void reset() throws UnsupportedOperationException {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public void resetBuffer() throws UnsupportedOperationException {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public void setBufferSize(int size) throws UnsupportedOperationException {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public void setLocale(Locale loc) throws UnsupportedOperationException {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public String getContentType() {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }

        public void setCharacterEncoding(String arg0) {
            throw new UnsupportedOperationException(HttpMsg.HTTP_ONLY_SUPPORTS_2_1);
        }
    }
}

