/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.eclipse.equinox.http.HttpMsg;

public class HttpDate {
    protected Calendar time;
    private boolean valid = true;
    private static final String[] MONTH_NAMES = new String[]{HttpMsg.Jan_1, HttpMsg.Feb_2, HttpMsg.Mar_3, HttpMsg.Apr_4, HttpMsg.May_5, HttpMsg.Jun_6, HttpMsg.Jul_7, HttpMsg.Aug_8, HttpMsg.Sep_9, HttpMsg.Oct_10, HttpMsg.Nov_11, HttpMsg.Dec_12};
    private static final String[] WEEK_DAYS = new String[]{HttpMsg.Sun_13, HttpMsg.Mon_14, HttpMsg.Tue_15, HttpMsg.Wed_16, HttpMsg.Thu_17, HttpMsg.Fri_18, HttpMsg.Sat_19};
    private static TimeZone gmt = null;

    public HttpDate() {
        if (gmt == null) {
            gmt = TimeZone.getTimeZone("GMT");
        }
        this.time = new GregorianCalendar(gmt);
    }

    public HttpDate(long iTime) {
        this();
        this.time.setTime(new Date(iTime));
    }

    public HttpDate(String iString) {
        this();
        if (iString.indexOf(",") > 0) {
            if (iString.indexOf("-") > 0) {
                this.parseRFC1036(iString);
            } else {
                this.parseRFC1123(iString);
            }
        } else {
            this.parseASC(iString);
        }
    }

    public HttpDate(Date iTime) {
        this();
        this.time.setTime(iTime);
    }

    public static String format(long time) {
        return new HttpDate(time).toString();
    }

    protected void formatDoubleDigit(StringBuffer buff, int val) {
        if (val < 10) {
            buff.append('0');
        }
        buff.append(val);
    }

    public long getAsLong() {
        return this.time.getTime().getTime();
    }

    public String getAsString() {
        return this.toString();
    }

    public int getDay() {
        return this.time.get(5);
    }

    public int getDayOfWeek() {
        return this.time.get(7) - 1;
    }

    public int getHour() {
        return this.time.get(11);
    }

    public int getMin() {
        return this.time.get(12);
    }

    public int getMonth() {
        return this.time.get(2);
    }

    public int getSec() {
        return this.time.get(13);
    }

    public int getYear() {
        return this.time.get(1);
    }

    public boolean isValid() {
        return this.valid;
    }

    protected int locateMonth(String monthString) throws NumberFormatException {
        int i = 0;
        while (i < 12) {
            if (MONTH_NAMES[i].equals(monthString)) {
                return i;
            }
            ++i;
        }
        throw new NumberFormatException("Invalid month: " + monthString);
    }

    public static String now() {
        return new HttpDate().toString();
    }

    protected void parseASC(String str) {
        try {
            if (str.charAt(3) == ' ') {
                int month = this.locateMonth(str.substring(4, 7));
                if (str.charAt(7) == ' ') {
                    int day = str.charAt(8) == ' ' ? Integer.parseInt(str.substring(9, 10)) : Integer.parseInt(str.substring(8, 10));
                    if (str.charAt(10) == ' ') {
                        int hour = Integer.parseInt(str.substring(11, 13));
                        if (str.charAt(13) == ':') {
                            int min = Integer.parseInt(str.substring(14, 16));
                            if (str.charAt(16) == ':') {
                                int sec = Integer.parseInt(str.substring(17, 19));
                                if (str.charAt(19) == ' ') {
                                    int year = Integer.parseInt(str.substring(20));
                                    this.time.set(year, month, day, hour, min, sec);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.valid = false;
        }
    }

    protected void parseRFC1036(String str) {
        try {
            int i = str.indexOf(", ");
            if (i != -1) {
                str = str.substring(i + 2);
                int day = Integer.parseInt(str.substring(0, 2));
                if (str.charAt(2) == '-') {
                    int month = this.locateMonth(str.substring(3, 6));
                    if (str.charAt(6) == '-') {
                        int year;
                        year += (year = Integer.parseInt(str.substring(7, 9))) < 70 ? 2000 : 1900;
                        if (str.charAt(9) == ' ') {
                            int hour = Integer.parseInt(str.substring(10, 12));
                            if (str.charAt(12) == ':') {
                                int min = Integer.parseInt(str.substring(13, 15));
                                if (str.charAt(15) == ':') {
                                    int sec = Integer.parseInt(str.substring(16, 18));
                                    if (str.charAt(18) == ' ') {
                                        this.time.set(year, month, day, hour, min, sec);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.valid = false;
        }
    }

    protected void parseRFC1123(String str) {
        try {
            if (str.charAt(3) == ',' && str.charAt(4) == ' ') {
                int day = Integer.parseInt(str.substring(5, 7));
                if (str.charAt(7) == ' ') {
                    int month = this.locateMonth(str.substring(8, 11));
                    if (str.charAt(11) == ' ') {
                        int year = Integer.parseInt(str.substring(12, 16));
                        if (str.charAt(16) == ' ') {
                            int hour = Integer.parseInt(str.substring(17, 19));
                            if (str.charAt(19) == ':') {
                                int min = Integer.parseInt(str.substring(20, 22));
                                if (str.charAt(22) == ':') {
                                    int sec = Integer.parseInt(str.substring(23, 25));
                                    if (str.charAt(25) == ' ') {
                                        this.time.set(year, month, day, hour, min, sec);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.valid = false;
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(30);
        buff.append(WEEK_DAYS[this.getDayOfWeek()]);
        buff.append(", ");
        this.formatDoubleDigit(buff, this.getDay());
        buff.append(' ');
        buff.append(MONTH_NAMES[this.getMonth()]);
        buff.append(' ');
        buff.append(this.getYear());
        buff.append(' ');
        this.formatDoubleDigit(buff, this.getHour());
        buff.append(':');
        this.formatDoubleDigit(buff, this.getMin());
        buff.append(':');
        this.formatDoubleDigit(buff, this.getSec());
        buff.append(' ');
        buff.append(this.time.getTimeZone().getID());
        return buff.toString();
    }
}

