/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.context;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.util.Asserts;

public class SessionContextManager {
    private final Map<String, SessionContext> sessionContexts = new ConcurrentHashMap<String, SessionContext>();

    public void addNewSessionContext(String sessionId, SessionContext context) {
        Asserts.assertNotNull((Object)sessionId, (String)"sessionId parameter can not be null");
        Asserts.assertNotNull((Object)context, (String)"context parameter can not be null");
        this.sessionContexts.put(sessionId, context);
    }

    public SessionContext getSessionContextWithSessionId(String sessionId) {
        Asserts.assertNotNull((Object)sessionId, (String)"sessionId parameter can not be null");
        return this.sessionContexts.get(sessionId);
    }

    public void destroySessionContextWithSessionId(String sessionId) {
        SessionContext sessionContext = this.sessionContexts.remove(sessionId);
        if (sessionContext != null) {
            sessionContext.destroy();
        }
    }

    public void destroyAllSessions() {
        Collection<SessionContext> allSessionContexts = this.sessionContexts.values();
        if (allSessionContexts != null && allSessionContexts.size() > 0) {
            for (SessionContext sessionContext : allSessionContexts) {
                sessionContext.destroy();
            }
            allSessionContexts.clear();
        }
    }
}

