/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.model;

import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderCapabilities;
import org.eclipse.tracecompass.tmf.core.model.DataProviderCapabilities;
import org.junit.Assert;
import org.junit.Test;

public class DataProviderCapabilitiesTest {
    private static final String EXPECTED_TO_STRING = "DataProviderCapabilities[canCreate=true, canDelete=true]";

    @Test
    public void testBuilder() {
        DataProviderCapabilities.Builder builder = new DataProviderCapabilities.Builder().setCanCreate(true).setCanDelete(true);
        IDataProviderCapabilities capabilities = builder.build();
        Assert.assertTrue((boolean)capabilities.canCreate());
        Assert.assertTrue((boolean)capabilities.canDelete());
    }

    @Test
    public void testEquality() {
        DataProviderCapabilities.Builder builder = new DataProviderCapabilities.Builder().setCanCreate(true).setCanDelete(true);
        IDataProviderCapabilities baseCapabilities = builder.build();
        IDataProviderCapabilities testCapabilities = builder.build();
        Assert.assertEquals((Object)baseCapabilities, (Object)testCapabilities);
        Assert.assertEquals((Object)testCapabilities, (Object)baseCapabilities);
        builder.setCanCreate(false);
        testCapabilities = builder.build();
        Assert.assertNotEquals((Object)baseCapabilities, (Object)testCapabilities);
        Assert.assertNotEquals((Object)testCapabilities, (Object)baseCapabilities);
        builder.setCanCreate(true);
        builder.setCanDelete(false);
        testCapabilities = builder.build();
        Assert.assertNotEquals((Object)baseCapabilities, (Object)testCapabilities);
        Assert.assertNotEquals((Object)testCapabilities, (Object)baseCapabilities);
        builder.setCanCreate(false);
        builder.setCanDelete(false);
        testCapabilities = builder.build();
        Assert.assertNotEquals((Object)baseCapabilities, (Object)testCapabilities);
        Assert.assertNotEquals((Object)testCapabilities, (Object)baseCapabilities);
        Assert.assertFalse((testCapabilities == DataProviderCapabilities.NULL_INSTANCE ? 1 : 0) != 0);
        Assert.assertEquals((Object)DataProviderCapabilities.NULL_INSTANCE, (Object)testCapabilities);
    }

    @Test
    public void testToString() {
        DataProviderCapabilities.Builder builder = new DataProviderCapabilities.Builder().setCanCreate(true).setCanDelete(true);
        Assert.assertEquals((Object)EXPECTED_TO_STRING, (Object)builder.build().toString());
    }

    @Test
    public void testHashCode() {
        DataProviderCapabilities.Builder builder = new DataProviderCapabilities.Builder().setCanCreate(true).setCanDelete(true);
        IDataProviderCapabilities capabilities1 = builder.build();
        IDataProviderCapabilities capabilities2 = DataProviderCapabilities.NULL_INSTANCE;
        Assert.assertEquals((long)capabilities1.hashCode(), (long)capabilities1.hashCode());
        Assert.assertEquals((long)capabilities2.hashCode(), (long)capabilities2.hashCode());
        Assert.assertNotEquals((long)capabilities1.hashCode(), (long)capabilities2.hashCode());
    }
}

