/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.util.Comparator;
import org.sat4j.annotations.Feature;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.PrimeImplicantStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.specs.Constr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.MandatoryLiteralListener;
import org.sat4j.specs.Propagatable;

@Feature(value="primeimplicant", parent="expert")
public class WatcherBasedPrimeImplicantStrategy
implements PrimeImplicantStrategy,
MandatoryLiteralListener {
    private int[] prime;
    private final Comparator<Integer> comparator;

    public WatcherBasedPrimeImplicantStrategy(Comparator<Integer> comparator) {
        this.comparator = comparator;
    }

    public WatcherBasedPrimeImplicantStrategy() {
        this(null);
    }

    @Override
    public void isMandatory(int p) {
        this.prime[LiteralsUtils.var((int)p)] = LiteralsUtils.toDimacs(p);
    }

    @Override
    public int[] compute(Solver<? extends DataStructureFactory> solver) {
        int i;
        assert (solver.qhead == solver.trail.size() + solver.learnedLiterals.size());
        long begin = System.currentTimeMillis();
        if (solver.learnedLiterals.size() > 0) {
            solver.qhead = solver.trail.size();
        }
        this.prime = new int[solver.voc.nVars() + 1];
        for (i = 0; i < this.prime.length; ++i) {
            this.prime[i] = 0;
        }
        for (i = 0; i < solver.trail.size(); ++i) {
            this.isMandatory(solver.trail.get(i));
        }
        for (int d : solver.fullmodel) {
            int p = LiteralsUtils.toInternal(d);
            if (!solver.voc.isUnassigned(p)) continue;
            solver.assume(p);
        }
        for (int d : solver.fullmodel) {
            this.reduceClausesContainingTheNegationOfPI(solver, LiteralsUtils.toInternal(d));
        }
        int removed = 0;
        int posremoved = 0;
        int propagated = 0;
        for (int d : this.fullModel(solver)) {
            if (this.prime[Math.abs(d)] != 0) {
                ++propagated;
                continue;
            }
            solver.forget(Math.abs(d));
            this.reduceClausesContainingTheNegationOfPI(solver, LiteralsUtils.toInternal(-d));
            ++removed;
            if (d <= 0 || d <= solver.nVars()) continue;
            ++posremoved;
        }
        solver.cancelUntil(0);
        int[] implicant = new int[propagated];
        int index = 0;
        for (int i2 : this.prime) {
            if (i2 == 0) continue;
            implicant[index++] = i2;
        }
        long end = System.currentTimeMillis();
        if (solver.isVerbose()) {
            System.out.printf("%s prime implicant computation statistics BRESIL (reverse = %b)%n", solver.getLogPrefix(), this.comparator != null);
            System.out.printf("%s implied: %d, decision: %d, removed %d (+%d), propagated %d, time(ms):%d %n", solver.getLogPrefix(), solver.implied.size(), solver.decisions.size(), removed, posremoved, propagated, end - begin);
        }
        return implicant;
    }

    Constr reduceClausesContainingTheNegationOfPI(Solver<? extends DataStructureFactory> solver, int p) {
        assert (p > 1);
        IVec<Propagatable> lwatched = solver.watched;
        lwatched.clear();
        solver.voc.watches(p).moveTo(lwatched);
        int size = lwatched.size();
        for (int i = 0; i < size; ++i) {
            solver.stats.incInspects();
            lwatched.get(i).propagatePI(this, p);
        }
        return null;
    }

    @Override
    public int[] getPrimeImplicantAsArrayWithHoles() {
        if (this.prime == null) {
            throw new UnsupportedOperationException("Call the compute method first!");
        }
        return this.prime;
    }

    private int[] fullModel(Solver<? extends DataStructureFactory> solver) {
        if (this.comparator == null) {
            return solver.fullmodel;
        }
        int n = solver.fullmodel.length;
        VecInt reversed = new VecInt(n);
        for (int i : solver.fullmodel) {
            reversed.push(i);
        }
        reversed.sort(this.comparator);
        return reversed.toArray();
    }
}

