/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.util;

import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.junit.Assert;
import org.junit.Test;

public class PairTest {
    Pair<String, Long> fPair1 = new Pair((Object)"String 1", (Object)1L);
    Pair<String, Long> fPair2 = new Pair((Object)"String 2", (Object)2L);

    @Test
    public void testToString() {
        String result = this.fPair1.toString();
        Assert.assertEquals((Object)"(String 1, 1)", (Object)result);
    }

    @Test
    public void testAccessors() {
        Pair myPair = new Pair((Object)"String 1", (Object)1L);
        Assert.assertEquals((Object)"String 1", (Object)myPair.getFirst());
        Assert.assertEquals((Object)1L, (Object)myPair.getSecond());
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fPair1.equals(this.fPair1));
        Assert.assertTrue((String)"equals", (boolean)this.fPair2.equals(this.fPair2));
        Assert.assertTrue((String)"equals", (!this.fPair1.equals(this.fPair2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fPair2.equals(this.fPair1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        Pair info1 = new Pair((Object)((String)this.fPair1.getFirst()), (Object)((Long)this.fPair1.getSecond()));
        Pair info2 = new Pair((Object)((String)this.fPair2.getFirst()), (Object)((Long)this.fPair2.getSecond()));
        Assert.assertTrue((String)"equals", (boolean)info1.equals(this.fPair1));
        Assert.assertTrue((String)"equals", (boolean)this.fPair1.equals((Object)info1));
        Assert.assertTrue((String)"equals", (boolean)info2.equals(this.fPair2));
        Assert.assertTrue((String)"equals", (boolean)this.fPair2.equals((Object)info2));
    }

    @Test
    public void testEqualsTransivity() {
        Pair info1 = new Pair((Object)((String)this.fPair1.getFirst()), (Object)((Long)this.fPair1.getSecond()));
        Pair info2 = new Pair((Object)((String)this.fPair1.getFirst()), (Object)((Long)this.fPair1.getSecond()));
        Pair info3 = new Pair((Object)((String)this.fPair1.getFirst()), (Object)((Long)this.fPair1.getSecond()));
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info2));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)info3));
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fPair1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fPair2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsDifferentObj() {
        Pair info = new Pair((Object)1L, (Object)"String1");
        Assert.assertTrue((String)"equals", (!this.fPair1.equals((Object)info) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        Pair info1 = new Pair((Object)((String)this.fPair1.getFirst()), (Object)((Long)this.fPair1.getSecond()));
        Pair info2 = new Pair((Object)((String)this.fPair2.getFirst()), (Object)((Long)this.fPair2.getSecond()));
        Assert.assertTrue((String)"hashCode", (this.fPair1.hashCode() == info1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fPair2.hashCode() == info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fPair1.hashCode() != info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fPair2.hashCode() != info1.hashCode() ? 1 : 0) != 0);
    }
}

