/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.ui.texteditor.MarkerUtilities;

public final class AnnotationTypeLookup {
    private Map<String, Object> fMapping;

    public String getAnnotationType(IMarker marker) {
        String markerType = MarkerUtilities.getMarkerType(marker);
        if (markerType != null) {
            int severity = MarkerUtilities.getSeverity(marker);
            return this.getAnnotationType(markerType, severity);
        }
        return null;
    }

    public String getAnnotationType(String markerType, int markerSeverity) {
        String[] superTypes;
        String annotationType = this.lookupAnnotationType(markerType, markerSeverity);
        if (annotationType != null) {
            return annotationType;
        }
        String[] stringArray = superTypes = MarkerUtilities.getSuperTypes(markerType);
        int n = superTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String superType = stringArray[n2];
            annotationType = this.lookupAnnotationType(superType, markerSeverity);
            if (annotationType != null) {
                return annotationType;
            }
            ++n2;
        }
        return null;
    }

    private String lookupAnnotationType(String markerType, int severity) {
        Object value;
        if (this.fMapping == null) {
            this.initializeMapping();
        }
        if ((value = this.fMapping.get(markerType)) instanceof String) {
            return (String)value;
        }
        if (value instanceof Map) {
            Map severityMap = (Map)value;
            return (String)severityMap.get(severity);
        }
        return null;
    }

    private void initializeMapping() {
        this.fMapping = new HashMap<String, Object>();
        for (AnnotationTypeMapping atm : this.getAnnotationTypeMappings()) {
            if (atm.isMarkerSeverityDefined()) {
                HashMap severityMap = this.fMapping.get(atm.fMarkerType);
                if (!(severityMap instanceof Map)) {
                    severityMap = new HashMap();
                    this.fMapping.put(atm.fMarkerType, severityMap);
                }
                Map map = severityMap;
                map.put(atm.fMarkerSeverity, atm.fAnnotationType);
                continue;
            }
            this.fMapping.put(atm.fMarkerType, atm.fAnnotationType);
        }
    }

    private List<AnnotationTypeMapping> getAnnotationTypeMappings() {
        ArrayList<AnnotationTypeMapping> annotationTypeMappings = new ArrayList<AnnotationTypeMapping>();
        this.readExtensionPoint(annotationTypeMappings, "markerAnnotationSpecification", "annotationType");
        this.readExtensionPoint(annotationTypeMappings, "annotationTypes", "name");
        return annotationTypeMappings;
    }

    private void readExtensionPoint(List<AnnotationTypeMapping> annotationTypeMappings, String extensionPointName, String typeAttributeName) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.editors", extensionPointName);
        if (extensionPoint != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                AnnotationTypeMapping mapping = this.createMapping(element, typeAttributeName);
                if (mapping != null) {
                    annotationTypeMappings.add(mapping);
                }
                ++n2;
            }
        }
    }

    private AnnotationTypeMapping createMapping(IConfigurationElement element, String typeAttributeName) {
        AnnotationTypeMapping mapping = new AnnotationTypeMapping();
        String s = element.getAttribute(typeAttributeName);
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        mapping.fAnnotationType = s;
        s = element.getAttribute("markerType");
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        mapping.fMarkerType = s;
        s = element.getAttribute("markerSeverity");
        if (s != null && !s.trim().isEmpty()) {
            mapping.fMarkerSeverity = StringConverter.asInt((String)s, (int)-1);
        }
        return mapping;
    }

    private static class AnnotationTypeMapping {
        static final int UNDEFINED = -1;
        String fAnnotationType;
        String fMarkerType;
        int fMarkerSeverity = -1;

        private AnnotationTypeMapping() {
        }

        boolean isMarkerSeverityDefined() {
            return this.fMarkerSeverity != -1;
        }
    }
}

