/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class TextEditBasedChangeGroup {
    private final TextEditBasedChange fChange;
    private boolean fIsEnabled;
    private final TextEditGroup fTextEditGroup;

    public TextEditBasedChangeGroup(TextEditBasedChange change, TextEditGroup group) {
        Assert.isNotNull((Object)change);
        Assert.isNotNull((Object)group);
        this.fChange = change;
        this.fIsEnabled = true;
        this.fTextEditGroup = group;
    }

    public TextEditBasedChange getTextEditChange() {
        return this.fChange;
    }

    public String getName() {
        return this.fTextEditGroup.getName();
    }

    public IRegion getRegion() {
        return this.fTextEditGroup.getRegion();
    }

    public TextEditGroup getTextEditGroup() {
        return this.fTextEditGroup;
    }

    public TextEdit[] getTextEdits() {
        return this.fTextEditGroup.getTextEdits();
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.fIsEnabled = enabled;
    }

    public GroupCategorySet getGroupCategorySet() {
        if (this.fTextEditGroup instanceof CategorizedTextEditGroup) {
            return ((CategorizedTextEditGroup)this.fTextEditGroup).getGroupCategorySet();
        }
        return GroupCategorySet.NONE;
    }
}

