/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IEnableEventsDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class BaseEnableEventHandler
extends BaseControlViewHandler {
    protected @Nullable CommandParameter fParam = null;

    public abstract void enableEvents(CommandParameter var1, List<String> var2, TraceDomainType var3, String var4, List<String> var5, IProgressMonitor var6) throws ExecutionException;

    public abstract void enableSyscalls(CommandParameter var1, List<String> var2, IProgressMonitor var3) throws ExecutionException;

    public abstract void enableProbe(CommandParameter var1, String var2, boolean var3, String var4, IProgressMonitor var5) throws ExecutionException;

    public abstract void enableLogLevel(CommandParameter var1, List<String> var2, LogLevelType var3, ITraceLogLevel var4, String var5, TraceDomainType var6, IProgressMonitor var7) throws ExecutionException;

    public abstract TraceDomainComponent getDomain(CommandParameter var1);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        CommandParameter tmpParam = null;
        this.fLock.lock();
        try {
            tmpParam = this.fParam;
            if (tmpParam == null) {
                return null;
            }
            tmpParam = tmpParam.clone();
        }
        finally {
            this.fLock.unlock();
        }
        final CommandParameter param = tmpParam;
        TargetNodeComponent node = param.getSession().getTargetNode();
        List<ITraceControlComponent> providers = node.getChildren(TraceProviderGroup.class);
        final IEnableEventsDialog dialog = TraceControlDialogFactory.getInstance().getEnableEventsDialog();
        if (!providers.isEmpty()) {
            dialog.setTraceProviderGroup((TraceProviderGroup)providers.get(0));
        }
        dialog.setTraceDomainComponent(this.getDomain(param));
        if (dialog.open() != 0) {
            return null;
        }
        Job job = new Job(Messages.TraceControl_ChangeEventStateJob){

            protected IStatus run(IProgressMonitor monitor) {
                ExecutionException error = null;
                try {
                    String filter = dialog.getFilterExpression();
                    List<String> eventNames = null;
                    switch (dialog.getDomain()) {
                        case KERNEL: 
                        case UST: {
                            if (dialog.isAllEvents()) {
                                BaseEnableEventHandler.this.enableEvents(param, ILttngControlService.ALL_EVENTS, dialog.getDomain(), filter, dialog.getExcludedEvents(), monitor);
                            } else if (dialog.isTracepoints()) {
                                if (dialog.isAllTracePoints()) {
                                    BaseEnableEventHandler.this.enableEvents(param, null, dialog.getDomain(), filter, dialog.getExcludedEvents(), monitor);
                                } else {
                                    eventNames = dialog.getEventNames();
                                    if (!eventNames.isEmpty()) {
                                        BaseEnableEventHandler.this.enableEvents(param, eventNames, dialog.getDomain(), filter, dialog.getExcludedEvents(), monitor);
                                    }
                                }
                            }
                            if (dialog.isSyscalls()) {
                                if (dialog.isAllSyscalls()) {
                                    BaseEnableEventHandler.this.enableSyscalls(param, ILttngControlService.ALL_EVENTS, monitor);
                                } else {
                                    List<String> syscallNames = dialog.getEventNames();
                                    if (!syscallNames.isEmpty()) {
                                        BaseEnableEventHandler.this.enableSyscalls(param, syscallNames, monitor);
                                    }
                                }
                            }
                            if (dialog.isDynamicProbe() && dialog.getProbeEventName() != null && dialog.getProbeName() != null) {
                                BaseEnableEventHandler.this.enableProbe(param, dialog.getProbeEventName(), false, dialog.getProbeName(), monitor);
                            }
                            if (dialog.isDynamicFunctionProbe() && dialog.getFunctionEventName() != null && dialog.getFunction() != null) {
                                BaseEnableEventHandler.this.enableProbe(param, dialog.getFunctionEventName(), true, dialog.getFunction(), monitor);
                            }
                            if (dialog.isWildcard()) {
                                eventNames = dialog.getEventNames();
                                eventNames.add(dialog.getWildcard());
                                if (!eventNames.isEmpty()) {
                                    BaseEnableEventHandler.this.enableEvents(param, eventNames, dialog.getDomain(), filter, dialog.getExcludedEvents(), monitor);
                                }
                            }
                            if (dialog.isLogLevel()) {
                                BaseEnableEventHandler.this.enableLogLevel(param, dialog.getEventNames(), dialog.getLogLevelType(), dialog.getLogLevel(), filter, dialog.getDomain(), monitor);
                            }
                            break;
                        }
                        case JUL: 
                        case LOG4J: 
                        case PYTHON: {
                            eventNames = dialog.getEventNames();
                            if (dialog.isAllEvents()) {
                                eventNames = null;
                            }
                            if (dialog.isLogLevel()) {
                                BaseEnableEventHandler.this.enableLogLevel(param, eventNames, dialog.getLogLevelType(), dialog.getLogLevel(), filter, dialog.getDomain(), monitor);
                                break;
                            }
                            BaseEnableEventHandler.this.enableEvents(param, eventNames, dialog.getDomain(), filter, dialog.getExcludedEvents(), monitor);
                            break;
                        }
                    }
                }
                catch (ExecutionException e) {
                    error = e;
                }
                BaseEnableEventHandler.this.refresh(param);
                if (error != null) {
                    return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_ChangeEventStateFailure, (Throwable)error);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

