/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.PrintWriter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.CompilerConfiguration;
import org.eclipse.jdt.internal.compiler.DefaultCompilerFactory;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerFactory;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.CompilationGroup;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.builder.BatchImageBuilder;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.CompilationParticipantResult;
import org.eclipse.jdt.internal.core.builder.ICompilationUnitLocator;
import org.eclipse.jdt.internal.core.builder.ImageBuilderInternalException;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.builder.NameEnvironment;
import org.eclipse.jdt.internal.core.builder.ProblemFactory;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.WorkQueue;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class AbstractImageBuilder
implements ICompilerRequestor,
ICompilationUnitLocator {
    protected JavaBuilder javaBuilder;
    protected State newState;
    protected NameEnvironment nameEnvironment;
    protected ClasspathMultiDirectory[] sourceLocations;
    protected BuildNotifier notifier;
    protected Compiler compiler;
    protected WorkQueue workQueue;
    protected LinkedHashSet<SourceFile> problemSourceFiles;
    protected boolean compiledAllAtOnce;
    private boolean inCompiler;
    protected boolean keepStoringProblemMarkers;
    protected Map<SourceFile, AnnotationBinding[]> filesWithAnnotations = null;
    public static int MAX_AT_ONCE = Integer.getInteger("maxCompiledUnitsAtOnce", 2000);
    public static final String[] JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES = new String[]{"message", "severity", "id", "charStart", "charEnd", "lineNumber", "arguments", "categoryId"};
    public static final Integer S_ERROR = 2;
    public static final Integer S_WARNING = 1;
    public static final Integer S_INFO = 0;
    public static final Integer P_HIGH = 2;
    public static final Integer P_NORMAL = 1;
    public static final Integer P_LOW = 0;
    public static final String COMPILER_FACTORY_KEY = "AbstractImageBuilder.compilerFactory";
    private final CompilationGroup compilationGroup;

    protected AbstractImageBuilder(JavaBuilder javaBuilder, boolean buildStarting, State newState, CompilationGroup compilationGroup) {
        this.javaBuilder = javaBuilder;
        this.compilationGroup = compilationGroup;
        this.nameEnvironment = compilationGroup == CompilationGroup.TEST ? javaBuilder.testNameEnvironment : javaBuilder.nameEnvironment;
        this.sourceLocations = this.nameEnvironment.sourceLocations;
        this.notifier = javaBuilder.notifier;
        this.keepStoringProblemMarkers = true;
        if (buildStarting) {
            this.newState = newState == null ? new State(javaBuilder) : newState;
            this.compiler = this.newCompiler();
            this.workQueue = new WorkQueue();
            this.problemSourceFiles = new LinkedHashSet(3);
            if (this.javaBuilder.participants != null) {
                CompilationParticipant[] compilationParticipantArray = this.javaBuilder.participants;
                int n = this.javaBuilder.participants.length;
                int n2 = 0;
                while (n2 < n) {
                    CompilationParticipant participant = compilationParticipantArray[n2];
                    if (participant.isAnnotationProcessor()) {
                        this.filesWithAnnotations = new HashMap<SourceFile, AnnotationBinding[]>(1);
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void acceptResult(CompilationResult result) {
        block24: {
            resultCU = result.getCompilationUnit();
            if (!(resultCU instanceof SourceFile)) {
                return;
            }
            compilationUnit = (SourceFile)resultCU;
            if (this.workQueue.isCompiled(compilationUnit)) break block24;
            this.workQueue.finished(compilationUnit);
            try {
                this.updateProblemsFor(compilationUnit, result);
                this.updateTasksFor(compilationUnit, result);
            }
            catch (CoreException e) {
                throw this.internalException(e);
            }
            if (result.hasInconsistentToplevelHierarchies) {
                this.problemSourceFiles.add(compilationUnit);
            }
            mainType = null;
            mainTypeName = null;
            typeLocator = compilationUnit.typeLocator();
            classFiles = result.getClassFiles();
            length = classFiles.length;
            duplicateTypeNames = null;
            definedTypeNames = new ArrayList<char[]>(length);
            postProcessingResults = new ArrayList<CompilationParticipantResult>();
            var15_13 = classFiles;
            var14_14 = classFiles.length;
            var13_15 = 0;
            while (var13_15 < var14_14) {
                block26: {
                    block25: {
                        classFile = var15_13[var13_15];
                        compoundName = classFile.getCompoundName();
                        typeName = compoundName[compoundName.length - 1];
                        isNestedType = classFile.isNestedType;
                        if (!isNestedType) break block25;
                        qualifiedTypeName = new String(classFile.outerMostEnclosingClassFile().fileName());
                        if (!this.newState.isDuplicateLocator(qualifiedTypeName, typeLocator)) ** GOTO lbl63
                        break block26;
                    }
                    qualifiedTypeName = new String(classFile.fileName());
                    if (this.newState.isDuplicateLocator(qualifiedTypeName, typeLocator)) {
                        if (duplicateTypeNames == null) {
                            duplicateTypeNames = new ArrayList<char[][]>();
                        }
                        duplicateTypeNames.add(compoundName);
                        if (mainType == null) {
                            try {
                                mainTypeName = compilationUnit.initialTypeName;
                                mainType = this.javaBuilder.javaProject.findType(mainTypeName.replace('/', '.'));
                            }
                            catch (JavaModelException var20_24) {
                                // empty catch block
                            }
                        }
                        if (qualifiedTypeName.equals(mainTypeName)) {
                            type = mainType;
                        } else {
                            simpleName = qualifiedTypeName.substring(qualifiedTypeName.lastIndexOf(47) + 1);
                            v0 = type = mainType == null ? null : mainType.getCompilationUnit().getType(simpleName);
                        }
                        if ("module-info".equals(qualifiedTypeName)) {
                            this.createProblemFor((IResource)compilationUnit.resource, type, Messages.build_duplicateModuleInfo, "error");
                        } else {
                            this.createProblemFor((IResource)compilationUnit.resource, type, Messages.bind(Messages.build_duplicateClassFile, new String(typeName)), "error");
                        }
                    } else {
                        this.newState.recordLocatorForType(qualifiedTypeName, typeLocator);
                        if (result.checkSecondaryTypes && !qualifiedTypeName.equals(compilationUnit.initialTypeName)) {
                            this.acceptSecondaryType(classFile);
                        }
lbl63:
                        // 4 sources

                        j = 0;
                        l = this.javaBuilder.participants == null ? 0 : this.javaBuilder.participants.length;
                        while (j < l) {
                            compilationParticipant = this.javaBuilder.participants[j];
                            if (compilationParticipant.isPostProcessor()) {
                                buildContext = new CompilationParticipantResult(compilationUnit, this.compilationGroup == CompilationGroup.TEST);
                                postProcessingResult = compilationParticipant.postProcess(buildContext, new ByteArrayInputStream(classFile.getBytes()));
                                postProcessingResults.add(buildContext);
                                if (postProcessingResult.isPresent()) {
                                    classFile.internalSetBytes(postProcessingResult.get());
                                }
                            }
                            ++j;
                        }
                        try {
                            definedTypeNames.add(this.writeClassFile(classFile, compilationUnit, isNestedType == false));
                        }
                        catch (CoreException e) {
                            Util.log(e, "JavaBuilder handling CoreException");
                            if (e.getStatus().getCode() == 275) {
                                this.createProblemFor((IResource)compilationUnit.resource, null, Messages.bind(Messages.build_classFileCollision, e.getMessage()), "error");
                            }
                            this.createProblemFor((IResource)compilationUnit.resource, null, Messages.build_inconsistentClassFile, "error");
                        }
                    }
                }
                ++var13_15;
            }
            if (result.hasAnnotations && this.filesWithAnnotations != null) {
                bindings = (AnnotationBinding[])result.annotations.stream().flatMap((Function<AnnotationBinding[], Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(T[] ), ([Lorg/eclipse/jdt/internal/compiler/lookup/AnnotationBinding;)Ljava/util/stream/Stream;)()).filter((Predicate<AnnotationBinding>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lorg/eclipse/jdt/internal/compiler/lookup/AnnotationBinding;)Z)()).toArray((IntFunction<AnnotationBinding[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$2(int ), (I)[Lorg/eclipse/jdt/internal/compiler/lookup/AnnotationBinding;)());
                this.filesWithAnnotations.put(compilationUnit, bindings);
            }
            this.compiler.lookupEnvironment.releaseClassFiles(classFiles);
            this.finishedWith(typeLocator, result, compilationUnit.getMainTypeName(), definedTypeNames, duplicateTypeNames);
            for (CompilationParticipantResult postProcessingResult : postProcessingResults) {
                this.recordParticipantResult(postProcessingResult);
            }
            this.notifier.compiled(compilationUnit);
        }
    }

    protected void acceptSecondaryType(ClassFile classFile) {
    }

    protected void addAllSourceFiles(final LinkedHashSet<SourceFile> sourceFiles) throws CoreException {
        ClasspathMultiDirectory[] classpathMultiDirectoryArray = this.sourceLocations;
        int n = this.sourceLocations.length;
        int n2 = 0;
        while (n2 < n) {
            final ClasspathMultiDirectory sourceLocation = classpathMultiDirectoryArray[n2];
            final char[][] exclusionPatterns = sourceLocation.exclusionPatterns;
            final char[][] inclusionPatterns = sourceLocation.inclusionPatterns;
            final boolean isAlsoProject = sourceLocation.sourceFolder.equals((Object)this.javaBuilder.currentProject);
            final int segmentCount = sourceLocation.sourceFolder.getFullPath().segmentCount();
            final IContainer outputFolder = sourceLocation.binaryFolder;
            final boolean isOutputFolder = sourceLocation.sourceFolder.equals((Object)outputFolder);
            sourceLocation.sourceFolder.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    switch (proxy.getType()) {
                        case 1: {
                            if (Util.isJavaLikeFileName(proxy.getName())) {
                                IResource resource = proxy.requestResource();
                                if ((exclusionPatterns != null || inclusionPatterns != null) && Util.isExcluded(resource.getFullPath(), inclusionPatterns, exclusionPatterns, false)) {
                                    return false;
                                }
                                SourceFile unit = new SourceFile((IFile)resource, sourceLocation);
                                sourceFiles.add(unit);
                            }
                            return false;
                        }
                        case 2: {
                            String complianceLevel;
                            String sourceLevel;
                            String packageName;
                            IPath folderPath = null;
                            if (isAlsoProject && AbstractImageBuilder.this.isExcludedFromProject(folderPath = proxy.requestFullPath())) {
                                return false;
                            }
                            if (exclusionPatterns != null) {
                                if (folderPath == null) {
                                    folderPath = proxy.requestFullPath();
                                }
                                if (Util.isExcluded(folderPath, inclusionPatterns, exclusionPatterns, true)) {
                                    return inclusionPatterns != null;
                                }
                            }
                            if (isOutputFolder) break;
                            if (folderPath == null) {
                                folderPath = proxy.requestFullPath();
                            }
                            if ((packageName = folderPath.lastSegment()).length() <= 0 || JavaConventions.validatePackageName(packageName, sourceLevel = AbstractImageBuilder.this.javaBuilder.javaProject.getOption("org.eclipse.jdt.core.compiler.source", true), complianceLevel = AbstractImageBuilder.this.javaBuilder.javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)).getSeverity() == 4) break;
                            AbstractImageBuilder.this.createFolder(folderPath.removeFirstSegments(segmentCount), outputFolder);
                        }
                    }
                    return true;
                }
            }, 0);
            this.notifier.checkCancel();
            ++n2;
        }
    }

    protected void cleanUp() {
        if (this.nameEnvironment != null) {
            this.nameEnvironment.cleanup();
        }
        this.javaBuilder = null;
        this.nameEnvironment = null;
        this.sourceLocations = null;
        this.notifier = null;
        this.compiler = null;
        this.workQueue = null;
        this.problemSourceFiles = null;
    }

    protected void compile(SourceFile[] units) {
        CompilationParticipantResult[] participantResults;
        if (this.filesWithAnnotations != null && this.filesWithAnnotations.size() > 0) {
            this.filesWithAnnotations.clear();
        }
        CompilationParticipantResult[] compilationParticipantResultArray = participantResults = this.javaBuilder.participants == null ? null : this.notifyParticipants(units);
        if (participantResults != null && participantResults.length > units.length) {
            units = new SourceFile[participantResults.length];
            int i = participantResults.length;
            while (--i >= 0) {
                units[i] = participantResults[i].sourceFile;
            }
        }
        int unitsLength = units.length;
        boolean bl = this.compiledAllAtOnce = MAX_AT_ONCE == 0 || unitsLength <= MAX_AT_ONCE;
        if (this.compiledAllAtOnce) {
            if (JavaBuilder.DEBUG) {
                int i = 0;
                while (i < unitsLength) {
                    JavaModelManager.trace("About to compile " + units[i].typeLocator());
                    ++i;
                }
            }
            this.compile(units, null, true);
        } else {
            SourceFile[] remainingUnits = new SourceFile[unitsLength];
            System.arraycopy(units, 0, remainingUnits, 0, unitsLength);
            int doNow = unitsLength < MAX_AT_ONCE ? unitsLength : MAX_AT_ONCE;
            SourceFile[] toCompile = new SourceFile[doNow];
            int remainingIndex = 0;
            boolean compilingFirstGroup = true;
            while (remainingIndex < unitsLength) {
                int count = 0;
                while (remainingIndex < unitsLength && count < doNow) {
                    SourceFile unit = remainingUnits[remainingIndex];
                    if (unit != null && (compilingFirstGroup || this.workQueue.isWaiting(unit))) {
                        if (JavaBuilder.DEBUG) {
                            JavaModelManager.trace("About to compile #" + remainingIndex + " : " + unit.typeLocator());
                        }
                        toCompile[count++] = unit;
                    }
                    remainingUnits[remainingIndex++] = null;
                }
                if (count < doNow) {
                    SourceFile[] sourceFileArray = toCompile;
                    toCompile = new SourceFile[count];
                    System.arraycopy(sourceFileArray, 0, toCompile, 0, count);
                }
                if (!compilingFirstGroup) {
                    int a = remainingIndex;
                    while (a < unitsLength) {
                        if (remainingUnits[a] != null && this.workQueue.isCompiled(remainingUnits[a])) {
                            remainingUnits[a] = null;
                        }
                        ++a;
                    }
                }
                this.compile(toCompile, remainingUnits, compilingFirstGroup);
                compilingFirstGroup = false;
            }
        }
        if (participantResults != null) {
            int i = participantResults.length;
            while (--i >= 0) {
                if (participantResults[i] == null) continue;
                this.recordParticipantResult(participantResults[i]);
            }
            this.processAnnotations(participantResults);
        }
    }

    protected void compile(SourceFile[] units, SourceFile[] additionalUnits, boolean compilingFirstGroup) {
        block11: {
            if (units.length == 0) {
                return;
            }
            this.notifier.aboutToCompile(units[0]);
            if (!this.problemSourceFiles.isEmpty()) {
                int length;
                int toAdd = this.problemSourceFiles.size();
                int n = length = additionalUnits == null ? 0 : additionalUnits.length;
                if (length == 0) {
                    additionalUnits = new SourceFile[toAdd];
                } else {
                    SourceFile[] sourceFileArray = additionalUnits;
                    additionalUnits = new SourceFile[length + toAdd];
                    System.arraycopy(sourceFileArray, 0, additionalUnits, 0, length);
                }
                Iterator iterator = this.problemSourceFiles.iterator();
                int i = 0;
                while (i < toAdd) {
                    additionalUnits[length + i] = (SourceFile)iterator.next();
                    ++i;
                }
            }
            String[] initialTypeNames = new String[units.length];
            int i = 0;
            int l = units.length;
            while (i < l) {
                char[] moduleName = units[i].getModuleName();
                initialTypeNames[i] = moduleName == null ? units[i].initialTypeName : new StringBuilder(60).append(moduleName).append(':').append(units[i].initialTypeName).toString();
                ++i;
            }
            this.nameEnvironment.setNames(initialTypeNames, additionalUnits);
            this.notifier.checkCancel();
            try {
                try {
                    this.inCompiler = true;
                    this.compiler.compile((ICompilationUnit[])units);
                }
                catch (AbortCompilation abortCompilation) {
                    this.inCompiler = false;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.inCompiler = false;
                throw throwable;
            }
            this.inCompiler = false;
        }
        this.notifier.checkCancel();
    }

    protected void copyResource(IResource source, IResource destination) throws CoreException {
        IPath destPath = destination.getFullPath();
        try {
            source.copy(destPath, 1025, null);
        }
        catch (CoreException e) {
            source.refreshLocal(0, null);
            if (!source.exists()) {
                return;
            }
            throw e;
        }
        Util.setReadOnly(destination, false);
    }

    protected void createProblemFor(IResource resource, IMember javaElement, String message, String problemSeverity) {
        try {
            ISourceRange range;
            int severity;
            IMarker marker;
            block6: {
                marker = resource.createMarker("org.eclipse.jdt.core.problem");
                severity = problemSeverity.equals("warning") ? 1 : 2;
                range = null;
                if (javaElement != null) {
                    try {
                        range = javaElement.getNameRange();
                    }
                    catch (JavaModelException e) {
                        if (e.getJavaModelStatus().getCode() != 969) {
                            throw e;
                        }
                        char[] elementName = javaElement.getElementName().toCharArray();
                        if (CharOperation.equals((char[])elementName, (char[])TypeConstants.PACKAGE_INFO_NAME) || CharOperation.equals((char[])elementName, (char[])TypeConstants.MODULE_INFO_NAME)) break block6;
                        throw e;
                    }
                }
            }
            int start = range == null ? 0 : range.getOffset();
            int end = range == null ? 1 : start + range.getLength();
            marker.setAttributes(new String[]{"message", "severity", "charStart", "charEnd", "sourceId"}, new Object[]{message, severity, start, end, "JDT"});
        }
        catch (CoreException e) {
            throw this.internalException(e);
        }
    }

    protected void deleteGeneratedFiles(IFile[] deletedGeneratedFiles) {
    }

    protected SourceFile findSourceFile(IFile file, boolean mustExist) {
        if (mustExist && !file.exists()) {
            return null;
        }
        ClasspathMultiDirectory md = null;
        if (this.sourceLocations.length > 0) {
            IPath sourceFileFullPath = file.getFullPath();
            ClasspathMultiDirectory[] classpathMultiDirectoryArray = this.sourceLocations;
            int n = this.sourceLocations.length;
            int n2 = 0;
            while (n2 < n) {
                ClasspathMultiDirectory sourceLocation = classpathMultiDirectoryArray[n2];
                if (sourceLocation.sourceFolder.getFullPath().isPrefixOf(sourceFileFullPath)) {
                    md = sourceLocation;
                    if (md.exclusionPatterns == null && md.inclusionPatterns == null || !Util.isExcluded((IResource)file, md.inclusionPatterns, md.exclusionPatterns)) break;
                }
                ++n2;
            }
        }
        return md == null ? null : new SourceFile(file, md);
    }

    protected void finishedWith(String sourceLocator, CompilationResult result, char[] mainTypeName, ArrayList definedTypeNames, ArrayList duplicateTypeNames) {
        if (duplicateTypeNames == null) {
            this.newState.record(sourceLocator, result.qualifiedReferences, result.simpleNameReferences, result.rootReferences, mainTypeName, definedTypeNames);
            return;
        }
        Object simpleRefs = result.simpleNameReferences;
        block0: for (Object duplicateTypeName : duplicateTypeNames) {
            char[][] compoundName = (char[][])duplicateTypeName;
            char[] typeName = compoundName[compoundName.length - 1];
            int sLength = ((char[][])simpleRefs).length;
            int j = 0;
            while (j < sLength) {
                if (CharOperation.equals((char[])simpleRefs[j], (char[])typeName)) continue block0;
                ++j;
            }
            char[][] cArray = simpleRefs;
            char[][] cArrayArray = new char[sLength + 1][];
            simpleRefs = cArrayArray;
            System.arraycopy(cArray, 0, cArrayArray, 0, sLength);
            simpleRefs[sLength] = typeName;
        }
        this.newState.record(sourceLocator, result.qualifiedReferences, (char[][])simpleRefs, result.rootReferences, mainTypeName, definedTypeNames);
    }

    protected IContainer createFolder(IPath packagePath, IContainer outputFolder) throws CoreException {
        if (packagePath.isEmpty()) {
            return outputFolder;
        }
        IFolder folder = outputFolder.getFolder(packagePath);
        if (!folder.exists()) {
            this.createFolder(packagePath.removeLastSegments(1), outputFolder);
            folder.create(1025, true, null);
        }
        return folder;
    }

    @Override
    public ICompilationUnit fromIFile(IFile file) {
        return this.findSourceFile(file, true);
    }

    protected void initializeAnnotationProcessorManager(Compiler newCompiler) {
        AbstractAnnotationProcessorManager annotationManager = JavaModelManager.getJavaModelManager().createAnnotationProcessorManager();
        if (annotationManager != null) {
            annotationManager.configureFromPlatform(newCompiler, (Object)this, (Object)this.javaBuilder.javaProject, this.compilationGroup == CompilationGroup.TEST);
            annotationManager.setErr(new PrintWriter(System.err));
            annotationManager.setOut(new PrintWriter(System.out));
        }
        newCompiler.annotationProcessorManager = annotationManager;
    }

    protected RuntimeException internalException(CoreException t) {
        ImageBuilderInternalException imageBuilderException = new ImageBuilderInternalException(t);
        if (this.inCompiler) {
            return new AbortCompilation(true, (RuntimeException)imageBuilderException);
        }
        return imageBuilderException;
    }

    protected boolean isExcludedFromProject(IPath childPath) throws JavaModelException {
        if (childPath.segmentCount() > 2) {
            return false;
        }
        ClasspathMultiDirectory[] classpathMultiDirectoryArray = this.sourceLocations;
        int n = this.sourceLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathMultiDirectory sourceLocation = classpathMultiDirectoryArray[n2];
            if (childPath.equals((Object)sourceLocation.binaryFolder.getFullPath())) {
                return true;
            }
            if (childPath.equals((Object)sourceLocation.sourceFolder.getFullPath())) {
                return true;
            }
            ++n2;
        }
        return childPath.equals((Object)this.javaBuilder.javaProject.getOutputLocation());
    }

    protected Compiler newCompiler() {
        Map<String, String> projectOptions = this.javaBuilder.javaProject.getOptions(true);
        String option = projectOptions.get("org.eclipse.jdt.core.compiler.problem.invalidJavadoc");
        if (!(option != null && !option.equals("ignore") || (option = projectOptions.get("org.eclipse.jdt.core.compiler.problem.missingJavadocTags")) != null && !option.equals("ignore") || (option = projectOptions.get("org.eclipse.jdt.core.compiler.problem.missingJavadocComments")) != null && !option.equals("ignore") || (option = projectOptions.get("org.eclipse.jdt.core.compiler.problem.unusedImport")) != null && !option.equals("ignore"))) {
            projectOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "disabled");
        }
        CompilerOptions compilerOptions = new CompilerOptions(projectOptions);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        ICompilerFactory compilerFactory = null;
        String compilerFactoryClassName = System.getProperty(COMPILER_FACTORY_KEY);
        if (compilerFactoryClassName != null) {
            try {
                Class<?> compilerFactoryClass = Class.forName(compilerFactoryClassName);
                Constructor<?> constructor = compilerFactoryClass.getDeclaredConstructor(new Class[0]);
                compilerFactory = (ICompilerFactory)constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                ILog.get().error("Failed to initialize the custom compiler factory - " + compilerFactoryClassName, (Throwable)e);
            }
        }
        if (compilerFactory == null) {
            compilerFactory = new DefaultCompilerFactory();
        }
        Compiler newCompiler = compilerFactory.newCompiler((INameEnvironment)this.nameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.prepareCompilerConfiguration(compilerOptions), this, (IProblemFactory)ProblemFactory.getProblemFactory(Locale.getDefault()));
        CompilerOptions options = newCompiler.options;
        String setting = System.getProperty("jdt.compiler.useSingleThread");
        newCompiler.useSingleThread = setting != null && setting.equals("true");
        options.produceReferenceInfo = true;
        if (options.complianceLevel >= 0x320000L && options.processAnnotations) {
            this.initializeAnnotationProcessorManager(newCompiler);
        }
        return newCompiler;
    }

    private CompilerConfiguration prepareCompilerConfiguration(CompilerOptions options) {
        try {
            ClasspathMultiDirectory[] srcLocations;
            boolean isTest;
            ArrayList<URI> annotationProcessorPaths = new ArrayList<URI>();
            ArrayList<IContainer> generatedSourcePaths = new ArrayList<IContainer>();
            boolean bl = isTest = this.compilationGroup == CompilationGroup.TEST;
            if (this.javaBuilder.participants != null) {
                CompilationParticipant[] compilationParticipantArray = this.javaBuilder.participants;
                int n = this.javaBuilder.participants.length;
                int n2 = 0;
                while (n2 < n) {
                    CompilationParticipant participant = compilationParticipantArray[n2];
                    if (participant.isAnnotationProcessor()) {
                        IContainer[] generatedSrc;
                        URI[] paths = participant.getAnnotationProcessorPaths(this.javaBuilder.javaProject, isTest);
                        if (paths != null) {
                            annotationProcessorPaths.addAll(Arrays.asList(paths));
                        }
                        if ((generatedSrc = participant.getGeneratedSourcePaths(this.javaBuilder.javaProject, isTest)) != null) {
                            generatedSourcePaths.addAll(Arrays.asList(generatedSrc));
                        }
                    }
                    ++n2;
                }
            }
            ClasspathLocation[] classpathLocations = this.nameEnvironment.binaryLocations;
            LinkedHashSet<URI> classpaths = new LinkedHashSet<URI>();
            LinkedHashSet<URI> modulepaths = new LinkedHashSet<URI>();
            ClasspathLocation[] classpathLocationArray = classpathLocations;
            int generatedSrc = classpathLocations.length;
            int paths = 0;
            while (paths < generatedSrc) {
                ClasspathLocation location = classpathLocationArray[paths];
                if (location instanceof ClasspathDirectory) {
                    ClasspathDirectory cpDirectory = (ClasspathDirectory)location;
                    URI cpURI = cpDirectory.binaryFolder.getRawLocationURI();
                    if (cpURI != null) {
                        if (cpDirectory.isOnModulePath) {
                            modulepaths.add(cpURI);
                        } else {
                            classpaths.add(cpURI);
                        }
                    }
                } else if (location instanceof ClasspathJar) {
                    ClasspathJar cpJar = (ClasspathJar)location;
                    URI cpURI = URIUtil.toURI((String)cpJar.zipFilename, (boolean)true);
                    if (cpJar.isOnModulePath) {
                        modulepaths.add(cpURI);
                    } else {
                        classpaths.add(cpURI);
                    }
                }
                ++paths;
            }
            HashMap<IContainer, IContainer> sourceOutputMapping = new HashMap<IContainer, IContainer>();
            LinkedHashSet<IContainer> sourcepaths = new LinkedHashSet<IContainer>();
            LinkedHashSet<IContainer> moduleSourcepaths = new LinkedHashSet<IContainer>();
            ClasspathMultiDirectory[] classpathMultiDirectoryArray = srcLocations = this.nameEnvironment.sourceLocations;
            int n = srcLocations.length;
            int n3 = 0;
            while (n3 < n) {
                ClasspathMultiDirectory sourceLocation = classpathMultiDirectoryArray[n3];
                sourceOutputMapping.put(sourceLocation.sourceFolder, sourceLocation.binaryFolder);
                if (sourceLocation.isOnModulePath) {
                    moduleSourcepaths.add(sourceLocation.sourceFolder);
                } else {
                    sourcepaths.add(sourceLocation.sourceFolder);
                }
                ++n3;
            }
            return new CompilerConfiguration(List.copyOf(sourcepaths), List.copyOf(moduleSourcepaths), List.copyOf(classpaths), List.copyOf(modulepaths), annotationProcessorPaths, generatedSourcePaths, sourceOutputMapping, options);
        }
        catch (Exception e) {
            ILog.get().error("Failed computing compiler configuration", (Throwable)e);
            return new CompilerConfiguration(null, null, null, null, null, null, null, options);
        }
    }

    protected CompilationParticipantResult[] notifyParticipants(SourceFile[] unitsAboutToCompile) {
        BuildContext[] results = new CompilationParticipantResult[unitsAboutToCompile.length];
        int i = unitsAboutToCompile.length;
        while (--i >= 0) {
            results[i] = new CompilationParticipantResult(unitsAboutToCompile[i], this.compilationGroup == CompilationGroup.TEST);
        }
        CompilationParticipant[] compilationParticipantArray = this.javaBuilder.participants;
        int n = this.javaBuilder.participants.length;
        int n2 = 0;
        while (n2 < n) {
            CompilationParticipant participant = compilationParticipantArray[n2];
            participant.buildStarting(results, this instanceof BatchImageBuilder);
            ++n2;
        }
        SimpleSet uniqueFiles = null;
        CompilationParticipantResult[] toAdd = null;
        int added = 0;
        int i2 = results.length;
        while (--i2 >= 0) {
            IFile[] addedGeneratedFiles;
            BuildContext result = results[i2];
            if (result == null) continue;
            IFile[] deletedGeneratedFiles = ((CompilationParticipantResult)result).deletedFiles;
            if (deletedGeneratedFiles != null) {
                this.deleteGeneratedFiles(deletedGeneratedFiles);
            }
            if ((addedGeneratedFiles = ((CompilationParticipantResult)result).addedFiles) == null) continue;
            int j = addedGeneratedFiles.length;
            while (--j >= 0) {
                SourceFile sourceFile = this.findSourceFile(addedGeneratedFiles[j], true);
                if (sourceFile == null) continue;
                if (uniqueFiles == null) {
                    uniqueFiles = new SimpleSet(unitsAboutToCompile.length + 3);
                    int f = unitsAboutToCompile.length;
                    while (--f >= 0) {
                        uniqueFiles.add((Object)unitsAboutToCompile[f]);
                    }
                }
                if (uniqueFiles.addIfNotIncluded((Object)sourceFile) != sourceFile) continue;
                CompilationParticipantResult newResult = new CompilationParticipantResult(sourceFile, this.compilationGroup == CompilationGroup.TEST);
                if (toAdd == null) {
                    toAdd = new CompilationParticipantResult[addedGeneratedFiles.length];
                } else {
                    int length = toAdd.length;
                    if (added == length) {
                        CompilationParticipantResult[] compilationParticipantResultArray = toAdd;
                        toAdd = new CompilationParticipantResult[length + addedGeneratedFiles.length];
                        System.arraycopy(compilationParticipantResultArray, 0, toAdd, 0, length);
                    }
                }
                toAdd[added++] = newResult;
                this.workQueue.add(sourceFile);
            }
        }
        if (added > 0) {
            int length = results.length;
            BuildContext[] buildContextArray = results;
            results = new CompilationParticipantResult[length + added];
            System.arraycopy(buildContextArray, 0, results, 0, length);
            System.arraycopy(toAdd, 0, results, length, added);
        }
        return results;
    }

    protected abstract void processAnnotationResults(CompilationParticipantResult[] var1);

    protected void processAnnotations(CompilationParticipantResult[] results) {
        boolean hasAnnotationProcessor = false;
        int i = 0;
        int l = this.javaBuilder.participants.length;
        while (!hasAnnotationProcessor && i < l) {
            hasAnnotationProcessor = this.javaBuilder.participants[i].isAnnotationProcessor();
            ++i;
        }
        if (!hasAnnotationProcessor) {
            return;
        }
        boolean foundAnnotations = this.filesWithAnnotations != null && this.filesWithAnnotations.size() > 0;
        int i2 = results.length;
        while (--i2 >= 0) {
            results[i2].reset(foundAnnotations ? this.filesWithAnnotations.get(results[i2].sourceFile) : null);
        }
        boolean isEcjUsed = Compiler.class.equals(this.compiler.getClass());
        if (isEcjUsed) {
            CompilationParticipant[] compilationParticipantArray = this.javaBuilder.participants;
            int n = this.javaBuilder.participants.length;
            int n2 = 0;
            while (n2 < n) {
                CompilationParticipant participant = compilationParticipantArray[n2];
                if (participant.isAnnotationProcessor()) {
                    participant.processAnnotations(results);
                }
                ++n2;
            }
        }
        this.processAnnotationResults(results);
    }

    protected void recordParticipantResult(CompilationParticipantResult result) {
        ReferenceCollection refs;
        String[] dependencies;
        CategorizedProblem[] problems = result.problems;
        if (problems != null && problems.length > 0) {
            this.notifier.updateProblemCounts(problems);
            try {
                this.storeProblemsFor(result.sourceFile, problems);
            }
            catch (CoreException e) {
                Util.log(e, "JavaBuilder logging CompilationParticipant's CoreException to help debugging");
            }
        }
        if ((dependencies = result.dependencies) != null && (refs = this.newState.references.get(result.sourceFile.typeLocator())) != null) {
            refs.addDependencies(dependencies);
        }
    }

    protected void storeProblemsFor(SourceFile sourceFile, CategorizedProblem[] problems) throws CoreException {
        if (sourceFile == null || problems == null || problems.length == 0) {
            return;
        }
        if (!this.keepStoringProblemMarkers) {
            return;
        }
        HashSet<String> managedMarkerTypes = JavaModelManager.getJavaModelManager().compilationParticipants.managedMarkerTypes();
        CategorizedProblem[] categorizedProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            block26: {
                CategorizedProblem problem = categorizedProblemArray[n2];
                int id = problem.getID();
                IFile resource = sourceFile.resource;
                String buildPathProblemMessage = null;
                switch (id) {
                    case 0x1000144: 
                    case 16777563: {
                        buildPathProblemMessage = Messages.bind(Messages.build_incompleteClassPath, problem.getArguments()[0]);
                        break;
                    }
                    case 8389927: {
                        buildPathProblemMessage = Messages.bind(Messages.build_errorOnModuleDirective, problem.getMessage());
                    }
                }
                if (buildPathProblemMessage != null) {
                    boolean isInvalidClasspathError;
                    if (JavaBuilder.DEBUG) {
                        JavaModelManager.trace(buildPathProblemMessage);
                    }
                    if ((isInvalidClasspathError = "error".equals(this.javaBuilder.javaProject.getOption("org.eclipse.jdt.core.incompleteClasspath", true))) && "abort".equals(this.javaBuilder.javaProject.getOption("org.eclipse.jdt.core.builder.invalidClasspath", true))) {
                        JavaBuilder.removeProblemsAndTasksFor((IResource)this.javaBuilder.currentProject);
                        this.keepStoringProblemMarkers = false;
                    }
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("message", buildPathProblemMessage);
                    attributes.put("severity", isInvalidClasspathError ? 2 : 1);
                    attributes.put("categoryId", 10);
                    attributes.put("sourceId", "JDT");
                    this.javaBuilder.currentProject.createMarker("org.eclipse.jdt.core.problem", attributes);
                }
                String markerType = problem.getMarkerType();
                boolean managedProblem = false;
                if ("org.eclipse.jdt.core.problem".equals(markerType) || (managedProblem = managedMarkerTypes.contains(markerType))) {
                    int j;
                    if (id == 536871825 && !CharOperation.equals((char[])sourceFile.getMainTypeName(), (char[])TypeConstants.PACKAGE_INFO_NAME)) {
                        char[] fileName = sourceFile.getFileName();
                        int pkgEnd = CharOperation.lastIndexOf((char)'/', (char[])fileName);
                        if (pkgEnd == -1) {
                            pkgEnd = CharOperation.lastIndexOf((char)File.separatorChar, (char[])fileName);
                        }
                        Openable pkg = null;
                        if (pkgEnd != -1) {
                            pkg = (PackageFragment)Util.getPackageFragment(sourceFile.getFileName(), pkgEnd, -1);
                        }
                        if (pkg != null) {
                            block27: {
                                try {
                                    IMarker[] existingMarkers = pkg.resource().findMarkers("org.eclipse.jdt.core.problem", false, 0);
                                    int len = existingMarkers.length;
                                    j = 0;
                                    while (j < len) {
                                        if ((Integer)existingMarkers[j].getAttribute("id") != 536871825) {
                                            ++j;
                                            continue;
                                        }
                                        break block26;
                                    }
                                }
                                catch (CoreException e) {
                                    if (!JavaModelManager.VERBOSE) break block27;
                                    JavaModelManager.trace("", (Exception)((Object)e));
                                }
                            }
                            IResource tempRes = pkg.resource();
                            if (tempRes != null) {
                                resource = tempRes;
                            }
                        }
                    }
                    int attributesLength = JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES.length;
                    if (!managedProblem) {
                        ++attributesLength;
                    }
                    String[] extraAttributeNames = problem.getExtraMarkerAttributeNames();
                    Object[] extraAttributeValues = problem.getExtraMarkerAttributeValues();
                    boolean extraAttributesExist = false;
                    if (extraAttributeNames != null && extraAttributeValues != null && extraAttributeNames.length == extraAttributeValues.length) {
                        attributesLength += extraAttributeNames.length;
                        extraAttributesExist = true;
                    }
                    HashMap<String, Object> attributes = new HashMap<String, Object>(attributesLength, 1.0f);
                    attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[0], problem.getMessage());
                    attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[1], problem.isError() ? S_ERROR : (problem.isWarning() ? S_WARNING : S_INFO));
                    attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[2], id);
                    attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[3], problem.getSourceStart());
                    attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[4], problem.getSourceEnd() + 1);
                    attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[5], problem.getSourceLineNumber());
                    attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[6], Util.getProblemArgumentsForMarker(problem.getArguments()));
                    attributes.put(JAVA_PROBLEM_MARKER_ATTRIBUTE_NAMES[7], problem.getCategoryID());
                    if (!managedProblem) {
                        attributes.put("sourceId", "JDT");
                    }
                    if (extraAttributesExist) {
                        j = 0;
                        while (j < extraAttributeNames.length) {
                            attributes.put(extraAttributeNames[j], extraAttributeValues[j]);
                            ++j;
                        }
                    }
                    resource.createMarker(markerType, attributes);
                    if (!this.keepStoringProblemMarkers) {
                        return;
                    }
                }
            }
            ++n2;
        }
    }

    protected void storeTasksFor(SourceFile sourceFile, CategorizedProblem[] tasks) throws CoreException {
        if (sourceFile == null || tasks == null || tasks.length == 0) {
            return;
        }
        IFile resource = sourceFile.resource;
        CategorizedProblem[] categorizedProblemArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            CategorizedProblem task = categorizedProblemArray[n2];
            if (task.getID() == 536871362) {
                Integer priority = P_NORMAL;
                String compilerPriority = task.getArguments()[2];
                if ("HIGH".equals(compilerPriority)) {
                    priority = P_HIGH;
                } else if ("LOW".equals(compilerPriority)) {
                    priority = P_LOW;
                }
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("message", task.getMessage());
                attributes.put("priority", priority);
                attributes.put("id", task.getID());
                attributes.put("charStart", task.getSourceStart());
                attributes.put("charEnd", task.getSourceEnd() + 1);
                attributes.put("lineNumber", task.getSourceLineNumber());
                attributes.put("userEditable", Boolean.FALSE);
                attributes.put("sourceId", "JDT");
                String[] extraAttributeNames = task.getExtraMarkerAttributeNames();
                Object[] extraAttributeValues = task.getExtraMarkerAttributeValues();
                if (extraAttributeNames != null && extraAttributeValues != null && extraAttributeNames.length == extraAttributeValues.length) {
                    int j = 0;
                    while (j < extraAttributeNames.length) {
                        attributes.put(extraAttributeNames[j], extraAttributeValues[j]);
                        ++j;
                    }
                }
                resource.createMarker("org.eclipse.jdt.core.task", attributes);
            }
            ++n2;
        }
    }

    protected void updateProblemsFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        CategorizedProblem[] problems = result.getProblems();
        if (problems == null || problems.length == 0) {
            return;
        }
        this.notifier.updateProblemCounts(problems);
        this.storeProblemsFor(sourceFile, problems);
    }

    protected void updateTasksFor(SourceFile sourceFile, CompilationResult result) throws CoreException {
        CategorizedProblem[] tasks = result.getTasks();
        if (tasks == null || tasks.length == 0) {
            return;
        }
        this.storeTasksFor(sourceFile, tasks);
    }

    protected char[] writeClassFile(ClassFile classFile, SourceFile compilationUnit, boolean isTopLevelType) throws CoreException {
        IContainer outputFolder;
        String fileName = new String(classFile.fileName());
        Path filePath = new Path(fileName);
        IContainer container = outputFolder = compilationUnit.sourceLocation.binaryFolder;
        if (filePath.segmentCount() > 1) {
            container = this.createFolder(filePath.removeLastSegments(1), outputFolder);
            filePath = new Path(filePath.lastSegment());
        }
        IFile file = container.getFile(filePath.addFileExtension("class"));
        this.writeClassFileContents(classFile, file, fileName, isTopLevelType, compilationUnit);
        return filePath.lastSegment().toCharArray();
    }

    protected abstract void writeClassFileContents(ClassFile var1, IFile var2, String var3, boolean var4, SourceFile var5) throws CoreException;

    private static /* synthetic */ AnnotationBinding[] lambda$2(int n) {
        return new AnnotationBinding[n];
    }
}

