/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;

public class TimeGraphStateSerializer
extends StdSerializer<TimeGraphState> {
    private static final long serialVersionUID = -4359431726167157401L;

    protected TimeGraphStateSerializer() {
        super(TimeGraphState.class);
    }

    public void serialize(TimeGraphState value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        OutputElementStyle style;
        gen.writeStartObject();
        gen.writeNumberField("start", value.getStartTime());
        gen.writeNumberField("end", value.getStartTime() + value.getDuration());
        if (value.getLabel() != null) {
            gen.writeStringField("label", value.getLabel());
        }
        if ((style = value.getStyle()) != null) {
            gen.writeObjectField("style", (Object)value.getStyle());
        } else {
            int stateValue = value.getValue();
            if (stateValue != Integer.MIN_VALUE) {
                gen.writeFieldName("style");
                gen.writeStartObject();
                gen.writeStringField("parentKey", String.valueOf(stateValue));
                gen.writeEndObject();
            }
        }
        if (value.getActiveProperties() != 0) {
            gen.writeNumberField("tags", value.getActiveProperties());
        }
        gen.writeEndObject();
    }
}

