/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.tag;

import java.util.Collections;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.tag.ITag;
import org.eclipse.cdt.core.dom.ast.tag.IWritableTag;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.PDOMStringSet;
import org.eclipse.cdt.internal.core.pdom.tag.BTreeIterable;
import org.eclipse.cdt.internal.core.pdom.tag.PDOMTag;
import org.eclipse.cdt.internal.core.pdom.tag.PDOMTagSynchronizer;
import org.eclipse.core.runtime.CoreException;

public class PDOMTagIndex {
    private final Database db;
    private final long ptr;
    private long rootRecord;
    private PDOMStringSet taggerIds;
    private BTree tags;

    public PDOMTagIndex(Database db, long ptr) throws CoreException {
        this.db = db;
        this.ptr = ptr;
        this.rootRecord = 0L;
    }

    private long getFieldAddress(Fields field) throws CoreException {
        if (this.rootRecord == 0L) {
            this.rootRecord = this.db.getRecPtr(this.ptr);
        }
        if (this.rootRecord == 0L) {
            this.rootRecord = this.db.malloc(Fields.sizeof);
            this.db.putRecPtr(this.ptr, this.rootRecord);
        }
        return this.rootRecord + field.offset;
    }

    private PDOMStringSet getTaggerIds() throws CoreException {
        if (this.taggerIds == null) {
            this.taggerIds = new PDOMStringSet(this.db, this.getFieldAddress(Fields.TaggerIds));
        }
        return this.taggerIds;
    }

    private BTree getTagsBTree() throws CoreException {
        if (this.tags == null) {
            this.tags = new BTree(this.db, this.getFieldAddress(Fields.Tags), new PDOMTag.BTreeComparator(this.db));
        }
        return this.tags;
    }

    private long getIdRecord(String taggerId, boolean createIfNeeded) {
        assert (taggerId != null);
        assert (!taggerId.isEmpty());
        if (this.db == null || taggerId == null || taggerId.isEmpty() || this.taggerIds == null && !createIfNeeded) {
            return 0L;
        }
        try {
            long record = this.getTaggerIds().find(taggerId);
            if (record == 0L && createIfNeeded) {
                record = this.getTaggerIds().add(taggerId);
            }
            return record;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0L;
        }
    }

    private IWritableTag createTag(long record, String id, int len) {
        if (this.db == null) {
            return null;
        }
        long idRecord = this.getIdRecord(id, true);
        if (idRecord == 0L) {
            return null;
        }
        try {
            PDOMTag tag = new PDOMTag(this.db, len);
            tag.setNode(record);
            tag.setTaggerId(idRecord);
            long inserted = this.getTagsBTree().insert(tag.getRecord());
            if (inserted == tag.getRecord()) {
                return tag;
            }
            tag.delete();
            return inserted == 0L ? null : new PDOMTag(this.db, inserted);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    private ITag getTag(long record, String id) {
        if (this.db == null) {
            return null;
        }
        long idRecord = this.getIdRecord(id, false);
        if (idRecord == 0L) {
            return null;
        }
        PDOMTag.BTreeVisitor v = new PDOMTag.BTreeVisitor(this.db, record, idRecord);
        try {
            this.getTagsBTree().accept(v);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return v.hasResult ? new PDOMTag(this.db, v.tagRecord) : null;
    }

    private Iterable<ITag> getTags(long binding_record) {
        BTree btree = null;
        try {
            btree = this.getTagsBTree();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return Collections.emptyList();
        }
        final Long bindingRecord = binding_record;
        return new BTreeIterable<ITag>(btree, new BTreeIterable.Descriptor<ITag>(){

            @Override
            public ITag create(long record) {
                return new PDOMTag(PDOMTagIndex.this.db, record);
            }

            @Override
            public int compare(long test_record) throws CoreException {
                long test_node = new PDOMTag(PDOMTagIndex.this.db, test_record).getNode();
                return Long.valueOf(test_node).compareTo(bindingRecord);
            }
        });
    }

    private boolean setTags(long binding_record, Iterable<ITag> tags) {
        HashMap<String, ITag> newTags = new HashMap<String, ITag>();
        for (ITag tag : tags) {
            ITag dupTag = newTags.put(tag.getTaggerId(), tag);
            if (dupTag == null) continue;
            CCorePlugin.log("Duplicate incoming tag for record " + binding_record + " from taggerId " + tag.getTaggerId());
        }
        BTree btree = null;
        try {
            btree = this.getTagsBTree();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
        PDOMTagSynchronizer sync = new PDOMTagSynchronizer(this.db, binding_record, newTags);
        try {
            btree.accept(sync);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
        sync.synchronize(btree);
        for (ITag newTag : newTags.values()) {
            IWritableTag pdomTag = this.createTag(binding_record, newTag.getTaggerId(), newTag.getDataLen());
            pdomTag.putBytes(0, newTag.getBytes(0, -1), -1);
        }
        return true;
    }

    private static PDOMTagIndex getTagIndex(PDOM pdom) {
        if (pdom == null) {
            return null;
        }
        try {
            PDOMTagIndex index = pdom.getTagIndex();
            return index.db == null ? null : index;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public static IWritableTag createTag(PDOM pdom, long record, String id, int len) {
        PDOMTagIndex index = PDOMTagIndex.getTagIndex(pdom);
        if (index == null) {
            return null;
        }
        return index.createTag(record, id, len);
    }

    public static ITag getTag(PDOM pdom, long record, String id) {
        PDOMTagIndex index = PDOMTagIndex.getTagIndex(pdom);
        if (index == null) {
            return null;
        }
        return index.getTag(record, id);
    }

    public static Iterable<ITag> getTags(PDOM pdom, long record) {
        PDOMTagIndex index = PDOMTagIndex.getTagIndex(pdom);
        if (index == null) {
            return Collections.emptyList();
        }
        return index.getTags(record);
    }

    public static boolean setTags(PDOM pdom, long record, Iterable<ITag> tags) {
        if (record == 0L) {
            return true;
        }
        PDOMTagIndex index = PDOMTagIndex.getTagIndex(pdom);
        if (index == null) {
            return false;
        }
        return index.setTags(record, tags);
    }

    private static enum Fields {
        TaggerIds,
        Tags,
        _last;

        public final long offset = this.ordinal() * 4;
        public static int sizeof;

        static {
            sizeof = _last.ordinal() * 4;
        }
    }
}

