/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.rocm.core.ctfplugin.trace;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.gpu.core.trace.IGpuTrace;
import org.eclipse.tracecompass.incubator.gpu.core.trace.IGpuTraceEventLayout;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.RocmEventLayout;
import org.eclipse.tracecompass.incubator.rocm.core.ctfplugin.trace.RocmCtfPluginTraceEventLayout;
import org.eclipse.tracecompass.incubator.rocm.core.trace.RocmTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocationInfo;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;

public class RocmCtfPluginTrace
extends RocmTrace
implements IGpuTrace {
    private @Nullable Boolean fIsContainingKernelGpuActivity;
    private ImmutableList<ITmfEventAspect<?>> fAspects = ImmutableList.of(TID_ASPECT, FUNCTION_NAME_ASPECT);
    private static final int MAX_OPERATIONS_UNTIL_OPERATION_END = 100;
    private static final int CONFIDENCE = 101;
    private static final ITmfEventAspect<Integer> TID_ASPECT = new ITmfEventAspect<Integer>(){

        public String getName() {
            return "Thread ID";
        }

        public String getHelpText() {
            return "";
        }

        public @Nullable Integer resolve(ITmfEvent event) {
            return (Integer)event.getContent().getFieldValue(Integer.class, new String[]{RocmCtfPluginTraceEventLayout.getInstance().fieldThreadId()});
        }
    };
    private static final ITmfEventAspect<String> FUNCTION_NAME_ASPECT = new ITmfEventAspect<String>(){

        public String getName() {
            return "Function name";
        }

        public String getHelpText() {
            return "";
        }

        public @Nullable String resolve(ITmfEvent event) {
            return RocmCtfPluginTraceEventLayout.getInstance().getCorrespondingApiLayout(event).getEventName(event);
        }
    };

    public @NonNull IGpuTraceEventLayout getGpuTraceEventLayout() {
        return RocmCtfPluginTraceEventLayout.getInstance();
    }

    @Override
    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return this.fAspects;
    }

    @Override
    public void initTrace(@Nullable IResource resource, @Nullable String path, @Nullable Class<? extends @Nullable ITmfEvent> eventType) throws TmfTraceException {
        super.initTrace(resource, path, eventType);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(super.getEventAspects());
        this.fAspects = builder.build();
        this.lookForKernelGpuActivityMetadata();
    }

    public @Nullable IStatus validate(@Nullable IProject project, @Nullable String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            boolean isRocprofilerVersionPresent;
            Map environment = ((CtfTraceValidationStatus)status).getEnvironment();
            String domain = (String)environment.get("tracer_name");
            boolean bl = isRocprofilerVersionPresent = environment.get("rocprofiler_version") != null;
            if (domain == null || !domain.equals("\"barectf\"")) {
                return new Status(4, "org.eclipse.tracecompass.incubator.rocm.core", "This trace was not recognized as a ROCm trace. You can update your rocprofiler version or you can change manually the tracer name to \"rocprof\" in the metadata file to force the validation.");
            }
            if (isRocprofilerVersionPresent) {
                return new TraceValidationStatus(101, "org.eclipse.tracecompass.incubator.rocm.core");
            }
        }
        return status;
    }

    private void lookForKernelGpuActivityMetadata() {
        Map environment = this.getEnvironment();
        String rocprofilerArgs = (String)environment.get("args");
        if (rocprofilerArgs == null) {
            return;
        }
        if (rocprofilerArgs.contains("--sys-trace") || rocprofilerArgs.contains("--hsa-trace")) {
            this.fIsContainingKernelGpuActivity = true;
        }
        this.fIsContainingKernelGpuActivity = false;
    }

    public boolean isContainingKernelGpuActivity() {
        if (this.fIsContainingKernelGpuActivity != null) {
            return this.fIsContainingKernelGpuActivity;
        }
        ITmfContext context = this.seekEvent((ITmfLocation)new CtfLocation(new CtfLocationInfo(0L, 0L)));
        CtfTmfEvent event = this.getNext(context);
        Long hipLaunchKernelEventCorrelationId = -1L;
        RocmEventLayout layout = new RocmEventLayout();
        Integer i = 0;
        while (event != null && i < 100) {
            Long correlationId = (Long)event.getContent().getFieldValue(Long.class, new String[]{layout.fieldCorrelationId()});
            if (correlationId == null) {
                event = this.getNext(context);
                continue;
            }
            if (event.getName().equals(layout.hipLaunchKernelBegin())) {
                if (hipLaunchKernelEventCorrelationId == -1L) {
                    hipLaunchKernelEventCorrelationId = correlationId;
                }
                i = i + 1;
            }
            if (event.getName().equals(layout.getHipOperationBegin()) && correlationId.equals(hipLaunchKernelEventCorrelationId)) {
                this.fIsContainingKernelGpuActivity = true;
                return this.fIsContainingKernelGpuActivity;
            }
            event = this.getNext(context);
        }
        this.fIsContainingKernelGpuActivity = false;
        return this.fIsContainingKernelGpuActivity;
    }
}

