/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects;

import com.google.common.base.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.Ros2SerializationUtil;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2Object;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;

public class Ros2NodeObject
extends Ros2Object<Ros2ObjectHandle> {
    public static final byte CUSTOM_TYPE_ID = 60;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CustomStateValue.CustomStateValueFactory ROS2_NODE_OBJECT_VALUE_FACTORY = b -> Ros2NodeObject.read(b);
    private final @NonNull String fNodeName;
    private final @NonNull String fTraceName;

    public Ros2NodeObject(@NonNull Ros2ObjectHandle nodeHandle, @NonNull String nodeName, @NonNull String traceName) {
        super(nodeHandle);
        this.fNodeName = nodeName;
        this.fTraceName = traceName;
    }

    public String getNodeName() {
        return this.fNodeName;
    }

    public @NonNull String getTraceName() {
        return this.fTraceName;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fNodeName, this.fTraceName, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Ros2NodeObject o = (Ros2NodeObject)((Object)obj);
        return o.fNodeName == this.fNodeName && o.fTraceName.equals(this.fTraceName);
    }

    @Override
    public String toString() {
        return String.format("Ros2NodeObject: nodeName=%s, %s, traceName=%s", this.fNodeName, super.toString(), this.fTraceName);
    }

    protected @NonNull Byte getCustomTypeId() {
        return (byte)60;
    }

    @Override
    protected void serializeValue(ISafeByteBufferWriter buffer) {
        super.serializeValue(buffer);
        buffer.putString(this.fNodeName);
        buffer.putString(this.fTraceName);
    }

    @Override
    protected int getSerializedValueSize() {
        int size = 0;
        size += super.getSerializedValueSize();
        size += Ros2SerializationUtil.getStringSerializedSize(this.fNodeName);
        return size += Ros2SerializationUtil.getStringSerializedSize(this.fTraceName);
    }

    public static @NonNull Ros2NodeObject read(ISafeByteBufferReader buffer) {
        Ros2ObjectHandle nodeHandle = Ros2ObjectHandle.read(buffer);
        String nodeName = buffer.getString();
        String traceName = buffer.getString();
        return new Ros2NodeObject(nodeHandle, nodeName, traceName);
    }
}

