/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.expressions.definitions;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ease.ui.scripts.expressions.ICompositeExpressionDefinition;
import org.eclipse.ease.ui.scripts.expressions.IExpressionDefinition;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractExpressionDefinition
implements IExpressionDefinition {
    private ICompositeExpressionDefinition fParent = null;
    private Collection<Parameter> fParameters = null;
    private IConfigurationElement fConfigurationElement;

    @Override
    public void setParent(ICompositeExpressionDefinition parent) {
        this.fParent = parent;
    }

    @Override
    public ICompositeExpressionDefinition getParent() {
        return this.fParent;
    }

    public Collection<Parameter> getParameters() {
        return this.fParameters != null ? this.fParameters : Collections.emptySet();
    }

    protected String getParameter(String key) {
        for (Parameter parameter : this.getParameters()) {
            if (!parameter.getName().equals(key)) continue;
            return parameter.getValue();
        }
        return null;
    }

    @Override
    public boolean hasParameter(String key) {
        for (Parameter parameter : this.getParameters()) {
            if (!parameter.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setParameter(String key, String value) {
        if (this.fParameters == null) {
            this.fParameters = new HashSet<Parameter>();
        }
        for (Parameter parameter : this.getParameters()) {
            if (!parameter.getName().equals(key)) continue;
            parameter.setValue(value);
            return;
        }
        this.getParameters().add(new Parameter(key, value));
    }

    @Override
    public void setParameterValues(String key, String[] allowedValues) {
        for (Parameter parameter : this.getParameters()) {
            if (!parameter.getName().equals(key)) continue;
            parameter.setAllowedValues(allowedValues);
            return;
        }
    }

    @Override
    public String serialize() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.toString());
        builder.append('(');
        builder.append(this.serializeParameters());
        builder.append(')');
        return builder.toString();
    }

    protected String serializeParameters() {
        StringBuilder builder = new StringBuilder();
        for (Parameter entry : this.getParameters()) {
            builder.append(entry.getName());
            builder.append('=');
            builder.append(entry.getValue());
            builder.append(", ");
        }
        if (!this.getParameters().isEmpty()) {
            builder.delete(builder.length() - 2, builder.length());
        }
        return builder.toString();
    }

    public String toString() {
        String name = this.fConfigurationElement.getAttribute("name");
        return name != null ? name : super.toString();
    }

    @Override
    public String getDescription() {
        return this.fConfigurationElement.getAttribute("description");
    }

    public void setConfiguration(IConfigurationElement configurationElement) {
        this.fConfigurationElement = configurationElement;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fConfigurationElement;
    }

    @Override
    public abstract Expression toCoreExpression();

    public static class Parameter {
        private final String fName;
        private String fValue;
        private String[] fAllowedValues = null;

        public Parameter(String name, String value) {
            this.fName = name;
            this.fValue = value;
        }

        public CellEditor getCellEditor(Composite parent) {
            if (this.fAllowedValues == null) {
                return new TextCellEditor(parent);
            }
            ComboBoxViewerCellEditor comboBoxViewerCellEditor = new ComboBoxViewerCellEditor(parent, 8);
            comboBoxViewerCellEditor.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            comboBoxViewerCellEditor.setInput((Object)this.fAllowedValues);
            return comboBoxViewerCellEditor;
        }

        public void setEditorValue(String value) {
            this.setValue(value);
        }

        public Object getEditorValue() {
            if (this.fAllowedValues == null) {
                return this.getValue();
            }
            return Arrays.asList(this.fAllowedValues).indexOf(this.getValue());
        }

        public String getName() {
            return this.fName;
        }

        public String getValue() {
            return this.fValue;
        }

        public void setValue(String value) {
            this.fValue = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            return !(this.fName == null ? other.fName != null : !this.fName.equals(other.fName));
        }

        public void setAllowedValues(String[] allowedValues) {
            this.fAllowedValues = allowedValues;
        }
    }
}

