/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Logger;
import org.eclipse.wst.jsdt.internal.core.search.HierarchyScope;
import org.eclipse.wst.jsdt.internal.core.search.IConstructorRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IFunctionRequester;
import org.eclipse.wst.jsdt.internal.core.search.IModuleRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessBindingRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IVariableRequester;
import org.eclipse.wst.jsdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchScope;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchTypeNameMatch;
import org.eclipse.wst.jsdt.internal.core.search.PathCollector;
import org.eclipse.wst.jsdt.internal.core.search.PatternSearchJob;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.LocalVariablePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MultiTypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.OrPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.SecondaryTypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.QualificationHelpers;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class BasicSearchEngine {
    private static final String GLOBAL_TYPE_SYMBOL = new String(IIndexConstants.GLOBAL_SYMBOL);
    private Parser parser;
    private CompilerOptions compilerOptions;
    private IJavaScriptUnit[] workingCopies;
    private HashSet fWorkingCopiesPaths;
    private WorkingCopyOwner workingCopyOwner;
    public static boolean VERBOSE = false;

    public BasicSearchEngine() {
    }

    public BasicSearchEngine(IJavaScriptUnit[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    char convertTypeKind(int typeDeclarationKind) {
        switch (typeDeclarationKind) {
            case 1: {
                return 'C';
            }
        }
        return '\u0000';
    }

    public BasicSearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.workingCopyOwner = workingCopyOwner;
    }

    public static IJavaScriptSearchScope createHierarchyScope(IType type) throws JavaScriptModelException {
        return BasicSearchEngine.createHierarchyScope(type, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IJavaScriptSearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws JavaScriptModelException {
        return new HierarchyScope(type, owner);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements) {
        return BasicSearchEngine.createJavaSearchScope(elements, true);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements, boolean includeReferencedProjects) {
        int includeMask = 7;
        if (includeReferencedProjects) {
            includeMask |= 8;
        }
        return BasicSearchEngine.createJavaSearchScope(elements, includeMask);
    }

    public static IJavaScriptSearchScope createJavaSearchScope(IJavaScriptElement[] elements, int includeMask) {
        JavaSearchScope scope = new JavaSearchScope();
        HashSet visitedProjects = new HashSet(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            IJavaScriptElement element = elements[i];
            if (element != null) {
                try {
                    if (element instanceof JavaProject) {
                        scope.add((JavaProject)element, includeMask, visitedProjects);
                    } else {
                        scope.add(element);
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            ++i;
        }
        return scope;
    }

    public static TypeNameMatch createTypeNameMatch(IType type, int modifiers) {
        return new JavaSearchTypeNameMatch(type, modifiers);
    }

    public static IJavaScriptSearchScope createWorkspaceScope() {
        return JavaModelManager.getJavaModelManager().getWorkspaceScope();
    }

    void findMatches(SearchPattern pattern, SearchParticipant[] participants, IJavaScriptSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            if (VERBOSE) {
                Util.verbose("Searching for pattern: " + pattern.toString());
                Util.verbose(scope.toString());
            }
            if (participants == null) {
                if (VERBOSE) {
                    Util.verbose("No participants => do nothing!");
                }
                return;
            }
            int length = participants.length;
            localMonitor.beginTask(Messages.engine_searching, 100 * length);
            IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
            requestor.beginReporting();
            int i = 0;
            while (i < length) {
                SearchParticipant participant = participants[i];
                try {
                    localMonitor.subTask(Messages.bind(Messages.engine_searching_indexing, new String[]{participant.getDescription()}));
                    participant.beginSearching();
                    requestor.enterParticipant(participant);
                    PathCollector pathCollector = new PathCollector();
                    indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, pathCollector), 3, (IProgressMonitor)localMonitor.split(50));
                    localMonitor.subTask(Messages.bind(Messages.engine_searching_matching, new String[]{participant.getDescription()}));
                    String[] indexMatchPaths = pathCollector.getPaths();
                    if (indexMatchPaths != null) {
                        pathCollector = null;
                        int indexMatchLength = indexMatchPaths.length;
                        SearchDocument[] indexMatches = new SearchDocument[indexMatchLength];
                        int j = 0;
                        while (j < indexMatchLength) {
                            indexMatches[j] = participant.getDocument(indexMatchPaths[j]);
                            ++j;
                        }
                        SearchDocument[] matches = MatchLocator.addWorkingCopies(pattern, indexMatches, this.getWorkingCopies(), participant);
                        participant.locateMatches(matches, pattern, scope, requestor, (IProgressMonitor)localMonitor.split(50));
                    }
                }
                finally {
                    requestor.exitParticipant(participant);
                    participant.doneSearching();
                }
                ++i;
            }
        }
        finally {
            requestor.endReporting();
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return new JavaSearchParticipant();
    }

    public static String getMatchRuleString(int matchRule) {
        if (matchRule == 0) {
            return "R_EXACT_MATCH";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 1;
        while (i <= 8) {
            int bit = matchRule & 1 << i - 1;
            if (bit != 0 && buffer.length() > 0) {
                buffer.append(" | ");
            }
            switch (bit) {
                case 1: {
                    buffer.append("R_PREFIX_MATCH");
                    break;
                }
                case 8: {
                    buffer.append("R_CASE_SENSITIVE");
                    break;
                }
                case 32: {
                    buffer.append("R_EQUIVALENT_MATCH");
                    break;
                }
                case 16: {
                    buffer.append("R_ERASURE_MATCH");
                    break;
                }
                case 64: {
                    buffer.append("R_FULL_MATCH");
                    break;
                }
                case 2: {
                    buffer.append("R_PATTERN_MATCH");
                    break;
                }
                case 4: {
                    buffer.append("R_REGEXP_MATCH");
                    break;
                }
                case 128: {
                    buffer.append("R_CAMELCASE_MATCH");
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getSearchForString(int searchFor) {
        switch (searchFor) {
            case 0: {
                return "TYPE";
            }
            case 1: {
                return "METHOD";
            }
            case 2: {
                return "PACKAGE";
            }
            case 3: {
                return "CONSTRUCTOR";
            }
            case 4: {
                return "FIELD";
            }
            case 5: {
                return "CLASS";
            }
            case 12: {
                return "VAR";
            }
            case 13: {
                return "FUNCTION";
            }
        }
        return "UNKNOWN";
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.compilerOptions = new CompilerOptions(JavaScriptCore.getOptions());
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, new DefaultProblemFactory());
            this.parser = new Parser(problemReporter, true);
        }
        return this.parser;
    }

    private IJavaScriptUnit[] getWorkingCopies() {
        int length;
        IJavaScriptUnit[] copies;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                copies = JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (copies == null) {
                    copies = this.workingCopies;
                } else {
                    IJavaScriptUnit unit;
                    HashMap<IPath, IJavaScriptUnit> pathToCUs = new HashMap<IPath, IJavaScriptUnit>();
                    int i = 0;
                    int length2 = copies.length;
                    while (i < length2) {
                        unit = copies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    i = 0;
                    length2 = this.workingCopies.length;
                    while (i < length2) {
                        unit = this.workingCopies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    length = pathToCUs.size();
                    copies = new IJavaScriptUnit[length];
                    pathToCUs.values().toArray(copies);
                }
            } else {
                copies = this.workingCopies;
            }
        } else {
            copies = this.workingCopyOwner != null ? JavaModelManager.getJavaModelManager().getWorkingCopies(this.workingCopyOwner, true) : JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (copies == null) {
            return null;
        }
        IJavaScriptUnit[] result = null;
        length = copies.length;
        int index = 0;
        int i = 0;
        while (i < length) {
            CompilationUnit copy = (CompilationUnit)copies[i];
            try {
                if (!copy.isPrimary() || copy.hasUnsavedChanges() || copy.hasResourceChanged()) {
                    if (result == null) {
                        result = new IJavaScriptUnit[length];
                    }
                    result[index++] = copy;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            ++i;
        }
        if (index != length && result != null) {
            IJavaScriptUnit[] iJavaScriptUnitArray = result;
            result = new IJavaScriptUnit[index];
            System.arraycopy(iJavaScriptUnitArray, 0, result, 0, index);
        }
        return result;
    }

    private HashSet getWorkingCopiesPaths() {
        if (this.fWorkingCopiesPaths == null) {
            this.fWorkingCopiesPaths = new HashSet();
            IJavaScriptUnit[] workingCopies = this.getWorkingCopies();
            int i = 0;
            while (workingCopies != null && i < workingCopies.length) {
                this.fWorkingCopiesPaths.add(workingCopies[i].getPath().toString());
                ++i;
            }
        }
        return this.fWorkingCopiesPaths;
    }

    private IJavaScriptUnit[] getWorkingCopies(IJavaScriptElement element) {
        IJavaScriptUnit cu;
        if (element instanceof IMember && (cu = ((IMember)element).getJavaScriptUnit()) != null && cu.isWorkingCopy()) {
            int length;
            IJavaScriptUnit[] copies = this.getWorkingCopies();
            int n = length = copies == null ? 0 : copies.length;
            if (length > 0) {
                IJavaScriptUnit[] newWorkingCopies = new IJavaScriptUnit[length + 1];
                System.arraycopy(copies, 0, newWorkingCopies, 0, length);
                newWorkingCopies[length] = cu;
                return newWorkingCopies;
            }
            return new IJavaScriptUnit[]{cu};
        }
        return this.getWorkingCopies();
    }

    boolean match(char patternTypeSuffix, int modifiers) {
        switch (patternTypeSuffix) {
            case 'C': {
                return modifiers == 0;
            }
        }
        return true;
    }

    boolean match(char patternTypeSuffix, char[] patternPkg, char[] patternTypeName, int matchRule, int typeKind, char[] pkg, char[] typeName) {
        boolean isCaseSensitive;
        if (typeName == null) {
            typeName = CharOperation.NO_CHAR;
        }
        switch (patternTypeSuffix) {
            case 'C': {
                if (typeKind == 1) break;
                return false;
            }
        }
        boolean bl = isCaseSensitive = (matchRule & 8) != 0;
        if (patternPkg != null && !CharOperation.equals(patternPkg, pkg, isCaseSensitive)) {
            return false;
        }
        if (patternTypeName != null) {
            boolean matchFirstChar;
            boolean isCamelCase = (matchRule & 0x80) != 0;
            int matchMode = matchRule & 7;
            if (!isCaseSensitive && !isCamelCase) {
                patternTypeName = CharOperation.toLowerCase(patternTypeName);
            }
            boolean bl2 = matchFirstChar = !isCaseSensitive || patternTypeName[0] == typeName[0];
            if (isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(patternTypeName, typeName)) {
                return true;
            }
            switch (matchMode) {
                case 0: {
                    if (!isCamelCase) {
                        return matchFirstChar && CharOperation.equals(patternTypeName, typeName, isCaseSensitive);
                    }
                }
                case 1: {
                    return matchFirstChar && CharOperation.prefixEquals(patternTypeName, typeName, isCaseSensitive);
                }
                case 2: {
                    return CharOperation.match(patternTypeName, typeName, isCaseSensitive);
                }
            }
        }
        return true;
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IJavaScriptSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.search(SearchPattern, SearchParticipant[], IJavaScriptSearchScope, SearchRequestor, IProgressMonitor)");
        }
        this.findMatches(pattern, participants, scope, requestor, monitor);
    }

    public void searchAllBindingNames(char[] packageName, char[] bindingName, final int bindingType, int matchRule, IJavaScriptSearchScope scope, final IRestrictedAccessBindingRequestor nameRequestor, int waitingPolicy, boolean doParse, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        block26: {
            if (VERBOSE) {
                Util.verbose("BasicSearchEngine.searchAllBindingNames(char[], char[], int, int, IJavaScriptSearchScope, IRestrictedAccessTypeRequestor, int, IProgressMonitor)");
                Util.verbose("\t- package name: " + (packageName == null ? "null" : new String(packageName)));
                Util.verbose("\t- type name: " + (bindingName == null ? "null" : new String(bindingName)));
                Util.verbose("\t- match rule: " + BasicSearchEngine.getMatchRuleString(matchRule));
                Util.verbose("\t- bindingType for: " + bindingType);
                Util.verbose("\t- scope: " + scope);
            }
            IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
            SearchPattern searchPattern = null;
            char suffix = '\u0000';
            switch (bindingType) {
                case 4: {
                    suffix = 'C';
                    searchPattern = new TypeDeclarationPattern(packageName, bindingName, matchRule);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    searchPattern = new FieldPattern(true, false, false, true, bindingName, null, IIndexConstants.GLOBAL_SYMBOL, null, null, matchRule, null);
                    break;
                }
                case 8: {
                    searchPattern = new MethodPattern(true, false, true, bindingName, null, null, null, null, null, IIndexConstants.GLOBAL_SYMBOL, matchRule);
                    break;
                }
                default: {
                    if ((bindingType & 8) > 0) {
                        searchPattern = new MethodPattern(true, false, true, bindingName, matchRule);
                    }
                    if ((bindingType & 3) > 0) {
                        FieldPattern fieldPattern = new FieldPattern(true, false, false, true, bindingName, null, IIndexConstants.GLOBAL_SYMBOL, null, null, matchRule, null);
                        searchPattern = searchPattern == null ? fieldPattern : new OrPattern(searchPattern, fieldPattern);
                    }
                    if ((bindingType & 4) <= 0) break;
                    suffix = 'C';
                    TypeDeclarationPattern typeDeclarationPattern = new TypeDeclarationPattern(packageName, bindingName, matchRule);
                    searchPattern = searchPattern == null ? typeDeclarationPattern : new OrPattern(searchPattern, typeDeclarationPattern);
                }
            }
            TypeDeclarationPattern pattern = searchPattern;
            char typeSuffix = suffix;
            IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

                @Override
                public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                    JavaSearchPattern record = (JavaSearchPattern)indexRecord;
                    AccessRestriction accessRestriction = null;
                    int modifiers = 1;
                    char[] packageName = null;
                    char[] simpleBindingName = null;
                    if (record instanceof MethodPattern) {
                        MethodPattern methodPattern = (MethodPattern)record;
                        simpleBindingName = methodPattern.selector;
                        Path path = new Path(documentPath);
                        String string = path.lastSegment();
                        if (path.hasTrailingSeparator()) {
                            packageName = string.toCharArray();
                        }
                    } else if (record instanceof LocalVariablePattern) {
                        LocalVariablePattern localVariablePattern = (LocalVariablePattern)record;
                        simpleBindingName = localVariablePattern.name;
                        Path path = new Path(documentPath);
                        String string = path.lastSegment();
                        if (path.hasTrailingSeparator()) {
                            packageName = string.toCharArray();
                        }
                    } else if (record instanceof TypeDeclarationPattern) {
                        TypeDeclarationPattern typeDecPattern = (TypeDeclarationPattern)record;
                        simpleBindingName = typeDecPattern.simpleName;
                        Path path = new Path(documentPath);
                        String string = path.lastSegment();
                        if (path.hasTrailingSeparator()) {
                            packageName = string.toCharArray();
                        }
                    }
                    nameRequestor.acceptBinding(bindingType, modifiers, packageName, simpleBindingName, documentPath, accessRestriction);
                    return true;
                }
            };
            try {
                int copiesLength;
                if (progressMonitor != null) {
                    progressMonitor.beginTask(Messages.engine_searching, 100);
                }
                indexManager.performConcurrentJob(new PatternSearchJob(pattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, searchRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 100)));
                IJavaScriptUnit[] copies = this.getWorkingCopies();
                int n = copiesLength = copies == null ? 0 : copies.length;
                if (copies == null || !doParse) break block26;
                int i = 0;
                while (i < copiesLength) {
                    block27: {
                        CompilationResult compilationUnitResult;
                        ICompilationUnit unit;
                        String path;
                        IJavaScriptUnit workingCopy;
                        block28: {
                            workingCopy = copies[i];
                            if (!scope.encloses(workingCopy)) break block27;
                            path = workingCopy.getPath().toString();
                            if (!workingCopy.isConsistent()) break block28;
                            char[] packageDeclaration = CharOperation.NO_CHAR;
                            switch (bindingType) {
                                case 4: {
                                    char[] simpleName;
                                    IType[] allTypes = workingCopy.getAllTypes();
                                    int j = 0;
                                    int allTypesLength = allTypes.length;
                                    while (j < allTypesLength) {
                                        int kind = 1;
                                        IType type = allTypes[j];
                                        simpleName = type.getElementName().toCharArray();
                                        if (this.match(typeSuffix, packageName, bindingName, matchRule, kind, packageDeclaration, simpleName)) {
                                            nameRequestor.acceptBinding(bindingType, type.getFlags(), packageDeclaration, simpleName, path, null);
                                        }
                                        ++j;
                                    }
                                }
                                case 8: {
                                    char[] simpleName;
                                    IFunction[] allMethods = workingCopy.getFunctions();
                                    int j = 0;
                                    int allMethodsLength = allMethods.length;
                                    while (j < allMethodsLength) {
                                        IFunction method = allMethods[j];
                                        simpleName = method.getElementName().toCharArray();
                                        if (this.match(typeSuffix, packageName, bindingName, matchRule, 0, packageDeclaration, simpleName)) {
                                            nameRequestor.acceptBinding(bindingType, method.getFlags(), packageDeclaration, simpleName, path, null);
                                        }
                                        ++j;
                                    }
                                    break block27;
                                }
                                case 1: 
                                case 2: 
                                case 3: {
                                    char[] simpleName;
                                    IField[] allFields = workingCopy.getFields();
                                    int j = 0;
                                    int allFieldsLength = allFields.length;
                                    while (j < allFieldsLength) {
                                        IField field = allFields[j];
                                        simpleName = field.getElementName().toCharArray();
                                        if (this.match(typeSuffix, packageName, bindingName, matchRule, 0, packageDeclaration, simpleName)) {
                                            nameRequestor.acceptBinding(bindingType, field.getFlags(), packageDeclaration, simpleName, path, null);
                                        }
                                        ++j;
                                    }
                                    break block6;
                                }
                            }
                            break block27;
                        }
                        Parser basicParser = this.getParser();
                        CompilationUnitDeclaration parsedUnit = basicParser.dietParse(unit = (ICompilationUnit)((Object)workingCopy), compilationUnitResult = new CompilationResult(unit, 0, 0, this.compilerOptions.maxProblemsPerUnit));
                        if (parsedUnit != null) {
                            basicParser.inferTypes(parsedUnit, null);
                            char[] packageDeclaration = parsedUnit.currentPackage == null ? CharOperation.NO_CHAR : CharOperation.concatWith(parsedUnit.currentPackage.getImportName(), '.');
                            class AllTypeDeclarationsVisitor
                            extends ASTVisitor {
                                private final /* synthetic */ int val$bindingType;
                                private final /* synthetic */ char val$typeSuffix;
                                private final /* synthetic */ char[] val$packageName;
                                private final /* synthetic */ char[] val$bindingName;
                                private final /* synthetic */ int val$matchRule;
                                private final /* synthetic */ char[] val$packageDeclaration;
                                private final /* synthetic */ IRestrictedAccessBindingRequestor val$nameRequestor;
                                private final /* synthetic */ String val$path;

                                AllTypeDeclarationsVisitor(int n, char c, char[] cArray, char[] cArray2, int n2, char[] cArray3, IRestrictedAccessBindingRequestor iRestrictedAccessBindingRequestor, String string) {
                                    this.val$bindingType = n;
                                    this.val$typeSuffix = c;
                                    this.val$packageName = cArray;
                                    this.val$bindingName = cArray2;
                                    this.val$matchRule = n2;
                                    this.val$packageDeclaration = cArray3;
                                    this.val$nameRequestor = iRestrictedAccessBindingRequestor;
                                    this.val$path = string;
                                }

                                @Override
                                public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope compilationUnitScope) {
                                    if (this.val$bindingType == 4 && BasicSearchEngine.this.match(this.val$typeSuffix, this.val$packageName, this.val$bindingName, this.val$matchRule, TypeDeclaration.kind(typeDeclaration.modifiers), this.val$packageDeclaration, typeDeclaration.name)) {
                                        this.val$nameRequestor.acceptBinding(this.val$bindingType, typeDeclaration.modifiers, this.val$packageDeclaration, typeDeclaration.name, this.val$path, null);
                                    }
                                    return true;
                                }

                                @Override
                                public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
                                    if (scope instanceof CompilationUnitScope && (this.val$bindingType == 2 || this.val$bindingType == 1 || this.val$bindingType == 3) && BasicSearchEngine.this.match(this.val$typeSuffix, this.val$packageName, this.val$bindingName, this.val$matchRule, 0, this.val$packageDeclaration, localDeclaration.name)) {
                                        this.val$nameRequestor.acceptBinding(this.val$bindingType, localDeclaration.modifiers, this.val$packageDeclaration, localDeclaration.name, this.val$path, null);
                                    }
                                    return true;
                                }

                                @Override
                                public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
                                    char[] methName = methodDeclaration.getName();
                                    if (this.val$bindingType == 8 && methName != null && BasicSearchEngine.this.match(this.val$typeSuffix, this.val$packageName, this.val$bindingName, this.val$matchRule, 0, this.val$packageDeclaration, methName)) {
                                        this.val$nameRequestor.acceptBinding(this.val$bindingType, methodDeclaration.modifiers, this.val$packageDeclaration, methName, this.val$path, null);
                                    }
                                    return true;
                                }

                                @Override
                                public boolean visit(InferredType inferredType, BlockScope scope) {
                                    if (this.val$bindingType == 4 && BasicSearchEngine.this.match(this.val$typeSuffix, this.val$packageName, this.val$bindingName, this.val$matchRule, TypeDeclaration.kind(0), this.val$packageDeclaration, inferredType.getName())) {
                                        this.val$nameRequestor.acceptBinding(this.val$bindingType, 0, this.val$packageDeclaration, inferredType.getName(), this.val$path, null);
                                    }
                                    return true;
                                }

                                @Override
                                public boolean visit(InferredAttribute inferredField, BlockScope scope) {
                                    if (scope instanceof CompilationUnitScope && (this.val$bindingType == 2 || this.val$bindingType == 1 || this.val$bindingType == 3) && BasicSearchEngine.this.match(this.val$typeSuffix, this.val$packageName, this.val$bindingName, this.val$matchRule, 0, this.val$packageDeclaration, inferredField.name)) {
                                        this.val$nameRequestor.acceptBinding(this.val$bindingType, inferredField.modifiers, this.val$packageDeclaration, inferredField.name, this.val$path, null);
                                    }
                                    return true;
                                }

                                @Override
                                public boolean visit(InferredMethod inferredMethod, BlockScope scope) {
                                    if (this.val$bindingType == 8 && inferredMethod.name != null && BasicSearchEngine.this.match(this.val$typeSuffix, this.val$packageName, this.val$bindingName, this.val$matchRule, 0, this.val$packageDeclaration, inferredMethod.name)) {
                                        this.val$nameRequestor.acceptBinding(this.val$bindingType, ((MethodDeclaration)inferredMethod.getFunctionDeclaration()).modifiers, this.val$packageDeclaration, inferredMethod.name, this.val$path, null);
                                    }
                                    return true;
                                }
                            }
                            parsedUnit.traverse((ASTVisitor)new AllTypeDeclarationsVisitor(bindingType, typeSuffix, packageName, bindingName, matchRule, packageDeclaration, nameRequestor, path), parsedUnit.scope);
                        }
                    }
                    ++i;
                }
            }
            finally {
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }
        }
    }

    public void searchAllSecondaryTypeNames(IPackageFragmentRoot[] sourceFolders, final IRestrictedAccessTypeRequestor nameRequestor, boolean waitForIndexes, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchAllSecondaryTypeNames(IPackageFragmentRoot[], IRestrictedAccessTypeRequestor, boolean, IProgressMonitor)");
            StringBuffer buffer = new StringBuffer("\t- source folders: ");
            int length = sourceFolders.length;
            int i = 0;
            while (i < length) {
                if (i == 0) {
                    buffer.append('[');
                } else {
                    buffer.append(',');
                }
                buffer.append(sourceFolders[i].getElementName());
                ++i;
            }
            buffer.append("]\n\t- waitForIndexes: ");
            buffer.append(waitForIndexes);
            Util.verbose(buffer.toString());
        }
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        SecondaryTypeDeclarationPattern pattern = new SecondaryTypeDeclarationPattern();
        final HashSet workingCopyPaths = this.getWorkingCopiesPaths();
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                TypeDeclarationPattern record = (TypeDeclarationPattern)indexRecord;
                if (record.enclosingTypeNames == IIndexConstants.ONE_ZERO_CHAR) {
                    return true;
                }
                if (workingCopyPaths.contains(documentPath)) {
                    return true;
                }
                AccessRestriction accessRestriction = null;
                if (access != null) {
                    int pkgLength = record.qualification == null || record.qualification.length == 0 ? 0 : record.qualification.length + 1;
                    int nameLength = record.simpleName == null ? 0 : record.simpleName.length;
                    char[] path = new char[pkgLength + nameLength];
                    int pos = 0;
                    if (pkgLength > 0) {
                        System.arraycopy(record.qualification, 0, path, pos, pkgLength - 1);
                        CharOperation.replace(path, '.', '/');
                        path[pkgLength - 1] = 47;
                        pos += pkgLength;
                    }
                    if (nameLength > 0) {
                        System.arraycopy(record.simpleName, 0, path, pos, nameLength);
                        pos += nameLength;
                    }
                    if (pos > 0) {
                        accessRestriction = access.getViolatedRestriction(path);
                    }
                }
                nameRequestor.acceptType(record.modifiers, record.qualification, record.simpleName, record.superTypes, record.enclosingTypeNames, documentPath, accessRestriction);
                return true;
            }
        };
        try {
            try {
                if (progressMonitor != null) {
                    progressMonitor.beginTask(Messages.engine_searching, 100);
                }
                indexManager.performConcurrentJob(new PatternSearchJob(pattern, BasicSearchEngine.getDefaultSearchParticipant(), BasicSearchEngine.createJavaSearchScope(sourceFolders), searchRequestor), waitForIndexes ? 3 : 1, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 100)));
            }
            catch (OperationCanceledException operationCanceledException) {
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    public void searchAllTypeNames(char[] prefix, int matchRule, IJavaScriptSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        TypeDeclarationPattern pattern = new TypeDeclarationPattern(prefix, matchRule);
        this.searchAllTypeNames(pattern, scope, nameRequestor, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[] qualification, char[] simpleTypeName, int matchRule, IJavaScriptSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchAllTypeNames(char[], char[], int, int, IJavaScriptSearchScope, IRestrictedAccessTypeRequestor, int, IProgressMonitor)");
            Util.verbose("\t- package name: " + (qualification == null ? "null" : new String(qualification)));
            Util.verbose("\t- type name: " + (simpleTypeName == null ? "null" : new String(simpleTypeName)));
            Util.verbose("\t- match rule: " + BasicSearchEngine.getMatchRuleString(matchRule));
            Util.verbose("\t- scope: " + scope);
        }
        TypeDeclarationPattern pattern = new TypeDeclarationPattern(qualification, simpleTypeName, matchRule);
        this.searchAllTypeNames(pattern, scope, nameRequestor, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[][] qualifications, char[][] simpleTypeNames, int matchRule, IJavaScriptSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchAllTypeNames(char[][], char[][], int, int, IJavaScriptSearchScope, IRestrictedAccessTypeRequestor, int, IProgressMonitor)");
            Util.verbose("\t- package name: " + (qualifications == null ? "null" : new String(CharOperation.concatWith(qualifications, ','))));
            Util.verbose("\t- type name: " + (simpleTypeNames == null ? "null" : new String(CharOperation.concatWith(simpleTypeNames, ','))));
            Util.verbose("\t- match rule: " + matchRule);
            Util.verbose("\t- scope: " + scope);
        }
        MultiTypeDeclarationPattern pattern = new MultiTypeDeclarationPattern(qualifications, simpleTypeNames, matchRule);
        this.searchAllTypeNames(pattern, scope, nameRequestor, waitingPolicy, progressMonitor);
    }

    private void searchAllTypeNames(TypeDeclarationPattern pattern, IJavaScriptSearchScope scope, final IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaScriptModelException {
        block13: {
            final HashSet workingCopyPaths = this.getWorkingCopiesPaths();
            IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

                @Override
                public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                    TypeDeclarationPattern record = (TypeDeclarationPattern)indexRecord;
                    if (record.enclosingTypeNames == IIndexConstants.ONE_ZERO_CHAR) {
                        return true;
                    }
                    if (workingCopyPaths.contains(documentPath)) {
                        return true;
                    }
                    AccessRestriction accessRestriction = null;
                    if (access != null) {
                        int qualificationLength = record.qualification == null || record.qualification.length == 0 ? 0 : record.qualification.length + 1;
                        int nameLength = record.simpleName == null ? 0 : record.simpleName.length;
                        char[] path = new char[qualificationLength + nameLength];
                        int pos = 0;
                        if (qualificationLength > 0) {
                            System.arraycopy(record.qualification, 0, path, pos, qualificationLength - 1);
                            CharOperation.replace(path, '.', '/');
                            path[qualificationLength - 1] = 47;
                            pos += qualificationLength;
                        }
                        if (nameLength > 0) {
                            System.arraycopy(record.simpleName, 0, path, pos, nameLength);
                            pos += nameLength;
                        }
                        if (pos > 0) {
                            accessRestriction = access.getViolatedRestriction(path);
                        }
                    }
                    nameRequestor.acceptType(record.modifiers, record.qualification, record.simpleName, record.superTypes, record.enclosingTypeNames, documentPath, accessRestriction);
                    return true;
                }
            };
            try {
                if (progressMonitor != null) {
                    progressMonitor.beginTask(Messages.engine_searching, 100);
                }
                IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
                indexManager.performConcurrentJob(new PatternSearchJob(pattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, searchRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 100)));
                IJavaScriptUnit[] copies = this.getWorkingCopies();
                if (copies == null) break block13;
                int matchRule = pattern.getMatchRule();
                int i = 0;
                while (i < copies.length) {
                    IJavaScriptUnit workingCopy = copies[i];
                    if (scope.encloses(workingCopy)) {
                        String path = workingCopy.getPath().toString();
                        if (!workingCopy.isConsistent()) {
                            workingCopy.makeConsistent(progressMonitor);
                        }
                        IType[] allTypes = workingCopy.getAllTypes();
                        int j = 0;
                        int allTypesLength = allTypes.length;
                        while (j < allTypesLength) {
                            TypeDeclarationPattern wcPattern;
                            IType type = allTypes[j];
                            char[] wcTypeQualification = null;
                            char[] wcTypeSimpleName = null;
                            char[] wcTypeFullName = type.getTypeQualifiedName().toCharArray();
                            if (type.getTypeQualifiedName() != null) {
                                char[][] wcSeperatedDeclaringType = QualificationHelpers.seperateFullyQualifedName(wcTypeFullName);
                                wcTypeQualification = wcSeperatedDeclaringType[0];
                                wcTypeSimpleName = wcSeperatedDeclaringType[1];
                            }
                            if (wcTypeSimpleName != null && pattern.matchesDecodedKey(wcPattern = new TypeDeclarationPattern(wcTypeQualification, wcTypeSimpleName, matchRule))) {
                                Object superTypes = CharOperation.NO_CHAR_CHAR;
                                try {
                                    String superType = type.getSuperclassName();
                                    superTypes = new char[][]{superType.toCharArray()};
                                }
                                catch (JavaScriptModelException javaScriptModelException) {}
                                nameRequestor.acceptType(type.getFlags(), wcTypeQualification, wcTypeSimpleName, (char[][])superTypes, null, path, null);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            finally {
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void searchAllModuleDeclarations(SearchPattern pattern, IJavaScriptSearchScope scope, final IModuleRequestor requestor, IProgressMonitor monitor) {
        final HashSet workingCopiesPaths = this.getWorkingCopiesPaths();
        IndexQueryRequestor queryRequestor = new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                if (!workingCopiesPaths.contains(documentPath)) {
                    if (indexRecord instanceof MethodPattern) {
                        MethodPattern record = (MethodPattern)indexRecord;
                        requestor.acceptFunction(record.selector, record.getDeclaringQualification(), record.getDeclaringSimpleName(), documentPath);
                    } else if (indexRecord instanceof FieldPattern) {
                        FieldPattern record = (FieldPattern)indexRecord;
                        requestor.acceptField(record.name, record.getDeclaringQualification(), record.getDeclaringSimpleName(), documentPath);
                    } else if (indexRecord instanceof TypeDeclarationPattern) {
                        TypeDeclarationPattern record = (TypeDeclarationPattern)indexRecord;
                        requestor.acceptType(record.qualification, record.simpleName, documentPath);
                    }
                }
                return true;
            }
        };
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        try {
            block33: {
                int w;
                IJavaScriptUnit[] workingCopies;
                SearchPattern methodPattern;
                SearchPattern fieldPattern;
                SearchPattern typePattern;
                block32: {
                    if (monitor != null) {
                        monitor.beginTask(Messages.engine_searching, 1000);
                    }
                    indexManager.performConcurrentJob(new PatternSearchJob(pattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, queryRequestor), 3, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 1000)));
                    typePattern = null;
                    fieldPattern = null;
                    methodPattern = null;
                    if (pattern instanceof OrPattern) {
                        typePattern = ((OrPattern)pattern).findPatternKind(8);
                        methodPattern = ((OrPattern)pattern).findPatternKind(128);
                        fieldPattern = ((OrPattern)pattern).findPatternKind(64);
                    } else if (pattern instanceof TypeDeclarationPattern) {
                        typePattern = pattern;
                    } else if (pattern instanceof FieldPattern) {
                        fieldPattern = pattern;
                    } else if (pattern instanceof MethodPattern) {
                        methodPattern = pattern;
                    }
                    workingCopies = this.getWorkingCopies();
                    w = 0;
                    if (!true) break block32;
                    if (workingCopies == null) return;
                    if (w >= workingCopies.length) break block33;
                }
                do {
                    IJavaScriptUnit workingCopy;
                    if (scope.encloses(workingCopy = workingCopies[w])) {
                        try {
                            if (!workingCopy.isConsistent()) {
                                workingCopy.makeConsistent(monitor);
                            }
                            IType[] types = workingCopy.getAllTypes();
                            int t = 0;
                            while (t < types.length) {
                                JavaSearchPattern wcPattern;
                                char[][] wcSeperatedDeclaringType;
                                char[] wcDeclaringType;
                                char[] wcDeclaringTypeQualification;
                                char[] wcDeclaringTypeSimpleName;
                                IType type = types[t];
                                if (typePattern != null && !type.isAnonymous()) {
                                    TypeDeclarationPattern wcPattern2;
                                    char[] wcTypeSimpleName = null;
                                    char[] wcTypeQualification = null;
                                    if (type.getTypeQualifiedName() != null) {
                                        char[][] wcSeperatedDeclaringType2 = QualificationHelpers.seperateFullyQualifedName(type.getTypeQualifiedName().toCharArray());
                                        wcTypeQualification = wcSeperatedDeclaringType2[0];
                                        wcTypeSimpleName = wcSeperatedDeclaringType2[1];
                                    }
                                    if (wcTypeSimpleName != null && typePattern.matchesDecodedKey(wcPattern2 = new TypeDeclarationPattern(wcTypeQualification, wcTypeSimpleName, pattern.getMatchRule()))) {
                                        requestor.acceptType(type);
                                    }
                                }
                                if (methodPattern != null) {
                                    IFunction[] allFunctions = type.getFunctions();
                                    int f = 0;
                                    while (f < allFunctions.length) {
                                        IFunction function = allFunctions[f];
                                        char[] wcSelector = null;
                                        if (function.getElementName() != null) {
                                            wcSelector = function.getElementName().toCharArray();
                                        }
                                        wcDeclaringTypeSimpleName = null;
                                        wcDeclaringTypeQualification = null;
                                        if (function.getDeclaringType() != null && function.getDeclaringType().getTypeQualifiedName() != null) {
                                            wcDeclaringType = function.getDeclaringType().getTypeQualifiedName().toCharArray();
                                            wcSeperatedDeclaringType = QualificationHelpers.seperateFullyQualifedName(wcDeclaringType);
                                            wcDeclaringTypeQualification = wcSeperatedDeclaringType[0];
                                            wcDeclaringTypeSimpleName = wcSeperatedDeclaringType[1];
                                        }
                                        if (wcSelector != null && methodPattern.matchesDecodedKey(wcPattern = new MethodPattern(true, false, false, wcSelector, null, null, null, null, wcDeclaringTypeQualification, wcDeclaringTypeSimpleName, pattern.getMatchRule()))) {
                                            requestor.acceptFunction(function);
                                        }
                                        ++f;
                                    }
                                }
                                if (fieldPattern != null) {
                                    IField[] allFields = type.getFields();
                                    int i = 0;
                                    while (i < allFields.length) {
                                        IField field = allFields[i];
                                        char[] wcName = null;
                                        if (field.getElementName() != null) {
                                            wcName = field.getElementName().toCharArray();
                                        }
                                        wcDeclaringTypeSimpleName = null;
                                        wcDeclaringTypeQualification = null;
                                        if (field.getDeclaringType() != null && field.getDeclaringType().getTypeQualifiedName() != null) {
                                            wcDeclaringType = field.getDeclaringType().getTypeQualifiedName().toCharArray();
                                            wcSeperatedDeclaringType = QualificationHelpers.seperateFullyQualifedName(wcDeclaringType);
                                            wcDeclaringTypeQualification = wcSeperatedDeclaringType[0];
                                            wcDeclaringTypeSimpleName = wcSeperatedDeclaringType[1];
                                        }
                                        if (wcName != null && fieldPattern.matchesDecodedKey(wcPattern = new FieldPattern(true, false, false, wcName, wcDeclaringTypeQualification, wcDeclaringTypeSimpleName, pattern.getMatchRule()))) {
                                            requestor.acceptField(field);
                                        }
                                        ++i;
                                    }
                                }
                                ++t;
                            }
                        }
                        catch (JavaScriptModelException e) {
                            Logger.logException("Error while processing working copy", (Throwable)((Object)e));
                        }
                    }
                    ++w;
                    if (workingCopies == null) return;
                } while (w < workingCopies.length);
            }
            return;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void searchDeclarations(IJavaScriptElement enclosingElement, SearchRequestor requestor, SearchPattern pattern, IProgressMonitor monitor) throws JavaScriptModelException {
        block13: {
            if (VERBOSE) {
                Util.verbose("\t- java element: " + enclosingElement);
            }
            IJavaScriptSearchScope scope = BasicSearchEngine.createJavaSearchScope(new IJavaScriptElement[]{enclosingElement});
            IResource resource = enclosingElement.getResource();
            if (enclosingElement instanceof IMember) {
                IMember member = (IMember)enclosingElement;
                IJavaScriptUnit cu = member.getJavaScriptUnit();
                if (cu != null) {
                    resource = cu.getResource();
                } else if (member.isBinary()) {
                    resource = null;
                }
            }
            try {
                if (resource instanceof IFile) {
                    try {
                        requestor.beginReporting();
                        if (VERBOSE) {
                            Util.verbose("Searching for " + pattern + " in " + resource.getFullPath());
                        }
                        SearchParticipant participant = BasicSearchEngine.getDefaultSearchParticipant();
                        SearchDocument[] documents = MatchLocator.addWorkingCopies(pattern, new SearchDocument[]{new JavaSearchDocument(enclosingElement.getPath().toString(), participant)}, this.getWorkingCopies(enclosingElement), participant);
                        participant.locateMatches(documents, pattern, scope, requestor, monitor);
                        break block13;
                    }
                    finally {
                        requestor.endReporting();
                    }
                }
                this.search(pattern, new SearchParticipant[]{BasicSearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
            }
            catch (CoreException e) {
                if (e instanceof JavaScriptModelException) {
                    throw (JavaScriptModelException)e;
                }
                throw new JavaScriptModelException(e);
            }
        }
    }

    public void searchDeclarationsOfAccessedFields(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfAccessedFields(IJavaScriptElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfAccessedFieldsPattern pattern = new DeclarationOfAccessedFieldsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfReferencedTypes(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfReferencedTypes(IJavaScriptElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfReferencedTypesPattern pattern = new DeclarationOfReferencedTypesPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfSentMessages(IJavaScriptElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaScriptModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchDeclarationsOfSentMessages(IJavaScriptElement, SearchRequestor, SearchPattern, IProgressMonitor)");
        }
        DeclarationOfReferencedMethodsPattern pattern = new DeclarationOfReferencedMethodsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchAllConstructorDeclarations(char[] prefix, int typeMatchRule, IJavaScriptSearchScope scope, final IConstructorRequestor requestor, int waitingPolicy, IProgressMonitor progressMonitor) {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchAllConstructorDeclarations(char[], char[], int, IJavaSearchScope, IRestrictedAccessConstructorRequestor, int, IProgressMonitor)");
            Util.verbose("\t- type name: " + (prefix == null ? "null" : new String(prefix)));
            Util.verbose("\t- type match rule: " + BasicSearchEngine.getMatchRuleString(typeMatchRule));
            Util.verbose("\t- scope: " + scope);
        }
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        ConstructorPattern pattern = new ConstructorPattern(prefix, typeMatchRule);
        final HashSet workingCopiesPaths = this.getWorkingCopiesPaths();
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                ConstructorPattern record = (ConstructorPattern)indexRecord;
                if (!workingCopiesPaths.contains(documentPath)) {
                    AccessRestriction accessRestriction = null;
                    if (access != null) {
                        int nameLength = record.declaringSimpleName == null ? 0 : record.declaringSimpleName.length;
                        char[] path = new char[nameLength];
                        int pos = 0;
                        if (nameLength > 0) {
                            System.arraycopy(record.declaringSimpleName, 0, path, pos, nameLength);
                            pos += nameLength;
                        }
                        if (pos > 0) {
                            accessRestriction = access.getViolatedRestriction(path);
                        }
                    }
                    requestor.acceptConstructor(record.modifiers, QualificationHelpers.createFullyQualifiedName(record.declaringQualification, record.declaringSimpleName), record.parameterNames == null ? 0 : record.parameterNames.length, record.getFullyQualifiedParameterTypeNames(), record.parameterNames, documentPath, accessRestriction);
                }
                return true;
            }
        };
        try {
            if (progressMonitor != null) {
                progressMonitor.beginTask(Messages.engine_searching, 1000);
            }
            indexManager.performConcurrentJob(new PatternSearchJob(pattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, searchRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 1000)));
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
        IJavaScriptUnit[] workingCopies = this.getWorkingCopies();
        int w = 0;
        while (workingCopies != null && w < workingCopies.length) {
            IJavaScriptUnit workingCopy = workingCopies[w];
            if (scope.encloses(workingCopy)) {
                try {
                    if (!workingCopy.isConsistent()) {
                        workingCopy.makeConsistent(progressMonitor);
                    }
                    IType[] types = workingCopy.getAllTypes();
                    int t = 0;
                    while (t < types.length) {
                        ConstructorPattern wcPattern;
                        IType type = types[t];
                        char[] wcTypeQualification = null;
                        char[] wcTypeSimpleName = null;
                        char[] wcTypeFullName = type.getTypeQualifiedName().toCharArray();
                        if (type.getTypeQualifiedName() != null) {
                            char[][] wcSeperatedDeclaringType = QualificationHelpers.seperateFullyQualifedName(wcTypeFullName);
                            wcTypeQualification = wcSeperatedDeclaringType[0];
                            wcTypeSimpleName = wcSeperatedDeclaringType[1];
                        }
                        if (wcTypeSimpleName != null && pattern.matchesDecodedKey(wcPattern = new ConstructorPattern(wcTypeQualification, wcTypeSimpleName, typeMatchRule))) {
                            IFunction[] allFunctions = type.getFunctions();
                            int f = 0;
                            while (f < allFunctions.length) {
                                IFunction function = allFunctions[f];
                                if (function.isConstructor()) {
                                    String[] wcParameterNames = function.getParameterNames();
                                    char[][] wcParameterTypes = QualificationHelpers.stringArrayToCharArray(function.getParameterTypes());
                                    int i = 0;
                                    while (i < wcParameterTypes.length) {
                                        try {
                                            wcParameterTypes[i] = Signature.toCharArray(wcParameterTypes[i]);
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {}
                                        ++i;
                                    }
                                    requestor.acceptConstructor(function.getFlags(), wcTypeFullName, wcParameterNames == null ? 0 : wcParameterNames.length, wcParameterTypes, QualificationHelpers.stringArrayToCharArray(wcParameterNames), workingCopy.getPath().toString(), null);
                                }
                                ++f;
                            }
                        }
                        ++t;
                    }
                }
                catch (JavaScriptModelException e) {
                    Logger.logException("Error while processing working copy", (Throwable)((Object)e));
                }
            }
            ++w;
        }
    }

    public void searchAllFunctions(final IFunctionRequester functionRequester, char[] selectorPattern, char[][] declaringTypes, int selectorPatternMatchRule, IJavaScriptSearchScope scope, int waitingPolicy, IProgressMonitor progressMonitor) {
        MethodPattern searchPattern = new MethodPattern(true, false, selectorPattern, declaringTypes, selectorPatternMatchRule);
        final HashSet workingCopiesPaths = this.getWorkingCopiesPaths();
        IndexQueryRequestor queryRequestor = new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                if (!workingCopiesPaths.contains(documentPath)) {
                    MethodPattern record = (MethodPattern)indexRecord;
                    functionRequester.acceptFunction(record.selector, QualificationHelpers.createFullyQualifiedNames(record.parameterQualifications, record.parameterSimpleNames), record.parameterNames, record.returnQualification, record.returnSimpleName, record.getDeclaringQualification(), record.getDeclaringSimpleName(), record.modifiers, documentPath);
                }
                return true;
            }
        };
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        try {
            if (progressMonitor != null) {
                progressMonitor.beginTask(Messages.engine_searching, 1000);
            }
            indexManager.performConcurrentJob(new PatternSearchJob(searchPattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, queryRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 1000)));
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
        IJavaScriptUnit[] workingCopies = this.getWorkingCopies();
        int workingCopyIndex = 0;
        while (workingCopies != null && workingCopyIndex < workingCopies.length) {
            IJavaScriptUnit workingCopy = workingCopies[workingCopyIndex];
            if (scope.encloses(workingCopy)) {
                try {
                    IType globalType;
                    if (!workingCopy.isConsistent()) {
                        workingCopy.makeConsistent(progressMonitor);
                    }
                    ArrayList<IFunction> allFunctions = new ArrayList<IFunction>();
                    allFunctions.addAll(Arrays.asList(workingCopy.getFunctions()));
                    IType[] types = workingCopy.getTypes();
                    if (types != null & types.length > 0 && (globalType = BasicSearchEngine.findGlobalType(workingCopy)) != null) {
                        allFunctions.addAll(Arrays.asList(globalType.getFunctions()));
                    }
                    int funcIndex = 0;
                    while (funcIndex < allFunctions.size()) {
                        IFunction function = (IFunction)allFunctions.get(funcIndex);
                        char[] wcSelector = null;
                        if (function.getElementName() != null) {
                            wcSelector = function.getElementName().toCharArray();
                        }
                        if (wcSelector != null) {
                            char[] wcDeclaringType = null;
                            if (function.getDeclaringType() != null && function.getDeclaringType().getTypeQualifiedName() != null) {
                                wcDeclaringType = function.getDeclaringType().getTypeQualifiedName().toCharArray();
                            }
                            wcDeclaringType = wcDeclaringType != null ? wcDeclaringType : IIndexConstants.GLOBAL_SYMBOL;
                            MethodPattern wcPattern = new MethodPattern(true, false, wcSelector, declaringTypes, selectorPatternMatchRule);
                            if (searchPattern.matchesDecodedKey(wcPattern)) {
                                char[][] wcParameterTypes = QualificationHelpers.stringArrayToCharArray(function.getParameterTypes());
                                int i = 0;
                                while (i < wcParameterTypes.length) {
                                    try {
                                        wcParameterTypes[i] = Signature.toCharArray(wcParameterTypes[i]);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {}
                                    ++i;
                                }
                                char[] wcReturnQualification = null;
                                char[] wcReturnSimpleName = null;
                                String wcReturnTypeSig = function.getReturnType();
                                if (wcReturnTypeSig != null) {
                                    char[] wcReturnType = Signature.toString(wcReturnTypeSig).toCharArray();
                                    char[][] wcSeperatedReturnType = QualificationHelpers.seperateFullyQualifedName(wcReturnType);
                                    wcReturnQualification = wcSeperatedReturnType[0];
                                    wcReturnSimpleName = wcSeperatedReturnType[1];
                                }
                                char[][] wcSeperatedDeclaringType = QualificationHelpers.seperateFullyQualifedName(wcDeclaringType);
                                functionRequester.acceptFunction(wcSelector, wcParameterTypes, QualificationHelpers.stringArrayToCharArray(function.getParameterNames()), wcReturnQualification, wcReturnSimpleName, wcSeperatedDeclaringType[0], wcSeperatedDeclaringType[1], function.getFlags(), workingCopy.getPath().toString());
                            }
                        }
                        ++funcIndex;
                    }
                }
                catch (JavaScriptModelException e) {
                    Logger.logException("Error while processing working copy", (Throwable)((Object)e));
                }
            }
            ++workingCopyIndex;
        }
    }

    public void searchAllVariables(final IVariableRequester variableRequester, char[] variablePattern, char[][] declaringTypes, int variablePatternMatchRule, IJavaScriptSearchScope scope, int waitingPolicy, IProgressMonitor progressMonitor) {
        char[][] declaringTypePatternChars = null;
        if (declaringTypes != null && declaringTypes.length > 0) {
            declaringTypePatternChars = new char[declaringTypes.length][];
            int i = 0;
            while (i < declaringTypes.length) {
                declaringTypePatternChars[i] = declaringTypes[i];
                ++i;
            }
        }
        FieldPattern searchPattern = new FieldPattern(true, false, false, true, variablePattern, declaringTypePatternChars, null, null, variablePatternMatchRule, null);
        final HashSet workingCopiesPaths = this.getWorkingCopiesPaths();
        IndexQueryRequestor queryRequestor = new IndexQueryRequestor(){

            @Override
            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                if (!workingCopiesPaths.contains(documentPath)) {
                    FieldPattern record = (FieldPattern)indexRecord;
                    variableRequester.acceptVariable(record.name, record.typeQualification, record.typeSimpleName, record.getDeclaringQualification(), record.getDeclaringSimpleName(), record.modifiers, documentPath);
                }
                return true;
            }
        };
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        try {
            if (progressMonitor != null) {
                progressMonitor.beginTask(Messages.engine_searching, 1000);
            }
            indexManager.performConcurrentJob(new PatternSearchJob(searchPattern, BasicSearchEngine.getDefaultSearchParticipant(), scope, queryRequestor), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 1000)));
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
        IJavaScriptUnit[] workingCopies = this.getWorkingCopies();
        int workingCopyIndex = 0;
        while (workingCopies != null && workingCopyIndex < workingCopies.length) {
            IJavaScriptUnit workingCopy = workingCopies[workingCopyIndex];
            if (scope.encloses(workingCopy)) {
                try {
                    IType globalType;
                    if (!workingCopy.isConsistent()) {
                        workingCopy.makeConsistent(progressMonitor);
                    }
                    ArrayList<IField> allFields = new ArrayList<IField>();
                    allFields.addAll(Arrays.asList(workingCopy.getFields()));
                    IType[] types = workingCopy.getTypes();
                    if (types != null & types.length > 0 && (globalType = BasicSearchEngine.findGlobalType(workingCopy)) != null) {
                        allFields.addAll(Arrays.asList(globalType.getFields()));
                    }
                    int fieldIndex = 0;
                    while (fieldIndex < allFields.size()) {
                        IField field = (IField)allFields.get(fieldIndex);
                        char[] wcName = null;
                        if (field.getElementName() != null) {
                            wcName = field.getElementName().toCharArray();
                        }
                        if (wcName != null) {
                            char[] wcDeclaringType = null;
                            if (field.getDeclaringType() != null && field.getDeclaringType().getTypeQualifiedName() != null) {
                                wcDeclaringType = field.getDeclaringType().getTypeQualifiedName().toCharArray();
                            }
                            wcDeclaringType = wcDeclaringType != null ? wcDeclaringType : IIndexConstants.GLOBAL_SYMBOL;
                            FieldPattern wcPattern = new FieldPattern(true, false, false, true, wcName, declaringTypePatternChars, null, null, variablePatternMatchRule, null);
                            if (searchPattern.matchesDecodedKey(wcPattern)) {
                                char[] wcTypeQualification = null;
                                char[] wcTypeSimpleName = null;
                                String wcTypeSig = field.getTypeSignature();
                                if (wcTypeSig != null) {
                                    char[] wcType = Signature.toString(wcTypeSig).toCharArray();
                                    char[][] wcSeperatedType = QualificationHelpers.seperateFullyQualifedName(wcType);
                                    wcTypeQualification = wcSeperatedType[0];
                                    wcTypeSimpleName = wcSeperatedType[1];
                                }
                                char[][] wcSeperatedDeclaringType = QualificationHelpers.seperateFullyQualifedName(wcDeclaringType);
                                variableRequester.acceptVariable(wcName, wcTypeQualification, wcTypeSimpleName, wcSeperatedDeclaringType[0], wcSeperatedDeclaringType[1], field.getFlags(), workingCopy.getPath().toString());
                            }
                        }
                        ++fieldIndex;
                    }
                }
                catch (JavaScriptModelException e) {
                    Logger.logException("Error while processing working copy", (Throwable)((Object)e));
                }
            }
            ++workingCopyIndex;
        }
    }

    private static IType findGlobalType(IJavaScriptUnit unit) throws JavaScriptModelException {
        IType globalType = null;
        IType[] types = unit.getTypes();
        if (types != null & types.length > 0) {
            int i = 0;
            while (i < types.length && globalType == null) {
                if (types[i].getElementName().equals(GLOBAL_TYPE_SYMBOL)) {
                    globalType = types[i];
                }
                ++i;
            }
        }
        return globalType;
    }
}

