/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;
import org.eclipse.tracecompass.internal.provisional.statesystem.core.statevalue.CustomStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public class Ros2MessageTransportInstance
extends CustomStateValue {
    public static final byte CUSTOM_TYPE_ID = 70;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CustomStateValue.CustomStateValueFactory ROS2_MESSAGE_TRANSPORT_INSTANCE_VALUE_FACTORY = Ros2MessageTransportInstance::read;
    private final @NonNull Ros2ObjectHandle fPublisherHandle;
    private final @NonNull Ros2ObjectHandle fSubscriptionHandle;
    private final long fSourceTimestamp;
    private final long fDestinationTimestamp;

    public Ros2MessageTransportInstance(@NonNull Ros2ObjectHandle sourcePublisherHandle, @NonNull Ros2ObjectHandle destinationSubscriptionHandle, long sourcePublicationTimestamp, long destinationTakeTimestamp) {
        this.fPublisherHandle = sourcePublisherHandle;
        this.fSubscriptionHandle = destinationSubscriptionHandle;
        this.fSourceTimestamp = sourcePublicationTimestamp;
        this.fDestinationTimestamp = destinationTakeTimestamp;
    }

    public @NonNull Ros2ObjectHandle getPublisherHandle() {
        return this.fPublisherHandle;
    }

    public @NonNull Ros2ObjectHandle getSubscriptionHandle() {
        return this.fSubscriptionHandle;
    }

    public long getSourceTimestamp() {
        return this.fSourceTimestamp;
    }

    public long getDestinationTimestamp() {
        return this.fDestinationTimestamp;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fPublisherHandle, this.fSubscriptionHandle, this.fSourceTimestamp, this.fDestinationTimestamp});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Ros2MessageTransportInstance o = (Ros2MessageTransportInstance)((Object)obj);
        return o.fPublisherHandle.equals((Object)this.fPublisherHandle) && o.fSubscriptionHandle.equals((Object)this.fSubscriptionHandle) && o.fSourceTimestamp == this.fSourceTimestamp && o.fDestinationTimestamp == this.fDestinationTimestamp;
    }

    public int compareTo(@NonNull ITmfStateValue o) {
        return this.equals(o) ? 0 : -1;
    }

    public String toString() {
        return String.format("Ros2MessageTransportInstance: pub=[%s], sub=[%s], sourceTimestamp=%d, destinationTimestamp=%d", this.fPublisherHandle.toString(), this.fSubscriptionHandle.toString(), this.fSourceTimestamp, this.fDestinationTimestamp);
    }

    protected @NonNull Byte getCustomTypeId() {
        return (byte)70;
    }

    protected void serializeValue(@NonNull ISafeByteBufferWriter buffer) {
        this.fPublisherHandle.serializeValue(buffer);
        this.fSubscriptionHandle.serializeValue(buffer);
        buffer.putLong(this.fSourceTimestamp);
        buffer.putLong(this.fDestinationTimestamp);
    }

    protected int getSerializedValueSize() {
        int size = 0;
        size += this.fPublisherHandle.getSerializedValueSize();
        size += this.fSubscriptionHandle.getSerializedValueSize();
        size += 8;
        return size += 8;
    }

    public static @NonNull Ros2MessageTransportInstance read(ISafeByteBufferReader buffer) {
        Ros2ObjectHandle publisherHandle = Ros2ObjectHandle.read(buffer);
        Ros2ObjectHandle subscriptionHandle = Ros2ObjectHandle.read(buffer);
        long sourceTimestamp = buffer.getLong();
        long destinationTimestamp = buffer.getLong();
        return new Ros2MessageTransportInstance(publisherHandle, subscriptionHandle, sourceTimestamp, destinationTimestamp);
    }
}

