/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfEventFieldAspect;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterWithNot;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterWithValue;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAspectNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterCompareNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterContainsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterEqualsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterOrNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterRootNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTraceTypeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterDragSourceAdapter;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterDropTargetAdapter;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterTreeContentProvider;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterTreeLabelProvider;
import org.eclipse.ui.PlatformUI;

class FilterViewer
extends Composite {
    private final String TEXT_HINT_KEY = "$text-hint--";
    private static final String THEME_SEL_FOREGROUND = "org.eclipse.tracecompass.tmf.ui.FOREGROUND_SEL_NOFOCUS";
    private static final String THEME_FOREGROUND = "org.eclipse.tracecompass.tmf.ui.FOREGROUND";
    private static final Color SEL_FOREGROUND_COLOR = FilterViewer.getThemeColor("org.eclipse.tracecompass.tmf.ui.FOREGROUND_SEL_NOFOCUS", 15);
    private static final Color FOREGROUND_COLOR = FilterViewer.getThemeColor("org.eclipse.tracecompass.tmf.ui.FOREGROUND", 2);
    private TreeViewer fViewer;
    private Composite fComposite;
    private MenuManager fMenuManager;
    private boolean fIsDialog = false;

    private static Color getThemeColor(String themeColorName, int systemDefault) {
        ColorRegistry colorRegistry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        Color c = colorRegistry.get(themeColorName);
        if (c == null) {
            c = Display.getDefault().getSystemColor(systemDefault);
        }
        return c;
    }

    public FilterViewer(Composite parent, int style) {
        this(parent, style, false);
    }

    public FilterViewer(Composite parent, int style, boolean isDialog) {
        super(parent, style);
        this.fIsDialog = isDialog;
        this.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(4, 4, true, true);
        this.setLayoutData(gd);
        SashForm sash = new SashForm((Composite)this, 256);
        this.fViewer = new TreeViewer((Composite)sash, 0);
        this.fViewer.setContentProvider((IContentProvider)new FilterTreeContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new FilterTreeLabelProvider());
        this.fComposite = new Composite((Composite)sash, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.fComposite.setLayout((Layout)gl);
        this.createContextMenu();
        this.fViewer.addSelectionChangedListener(event -> {
            if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ITmfFilterTreeNode node = (ITmfFilterTreeNode)selection.getFirstElement();
                this.updateFilterNodeComposite(node);
            } else {
                this.updateFilterNodeComposite(null);
            }
        });
        this.fViewer.getTree().addPaintListener(e -> {
            TmfFilterTreeNode root = (TmfFilterTreeNode)this.fViewer.getInput();
            if (root == null || root.getChildrenCount() == 0) {
                e.gc.setForeground(FOREGROUND_COLOR);
                e.gc.drawText(Messages.FilterViewer_EmptyTreeHintText, 5, 0);
            }
        });
        int operations = 3;
        DragSource dragSource = new DragSource((Control)this.fViewer.getTree(), operations);
        dragSource.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        dragSource.addDragListener((DragSourceListener)new FilterDragSourceAdapter(this));
        DropTarget dropTarget = new DropTarget((Control)this.fViewer.getTree(), operations);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)new FilterDropTargetAdapter(this));
    }

    private void createContextMenu() {
        this.fMenuManager = new MenuManager();
        this.fMenuManager.setRemoveAllWhenShown(true);
        this.fMenuManager.addMenuListener(manager -> this.fillContextMenu(manager));
        Menu contextMenu = this.fMenuManager.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(contextMenu);
    }

    public MenuManager getMenuManager() {
        return this.fMenuManager;
    }

    protected void fillContextMenu(IMenuManager manager) {
        ITmfFilterTreeNode selectedNode;
        Object element;
        ISelection selection = this.fViewer.getSelection();
        ITmfFilterTreeNode filterTreeNode = null;
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ITmfFilterTreeNode) {
            filterTreeNode = (ITmfFilterTreeNode)element;
        }
        if ((selectedNode = filterTreeNode) != null) {
            this.fillContextMenuForNode(selectedNode, manager);
        }
        manager.add((IContributionItem)new Separator("delete"));
        if (this.fIsDialog && selectedNode != null) {
            Action deleteAction = new Action(Messages.FilterViewer_DeleteActionText){

                public void run() {
                    selectedNode.remove();
                    FilterViewer.this.fViewer.refresh();
                }
            };
            deleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
            manager.add((IAction)deleteAction);
        }
        manager.add((IContributionItem)new Separator("edit"));
        if (this.fViewer.getInput() instanceof TmfFilterRootNode || filterTreeNode == null) {
            manager.add((IContributionItem)new Separator());
            ITmfFilterTreeNode root = (ITmfFilterTreeNode)this.fViewer.getInput();
            this.fillContextMenuForNode(root, manager);
        }
    }

    protected void fillContextMenuForNode(final ITmfFilterTreeNode node, IMenuManager manager) {
        for (final String child : node.getValidChildren()) {
            Action action = new Action(){

                public void run() {
                    TmfFilterNode newNode = null;
                    if ("FILTER".equals(child)) {
                        newNode = new TmfFilterNode(node, "");
                    } else if ("TRACETYPE".equals(child)) {
                        newNode = new TmfFilterTraceTypeNode(node);
                    } else if ("AND".equals(child)) {
                        newNode = new TmfFilterAndNode(node);
                    } else if ("OR".equals(child)) {
                        newNode = new TmfFilterOrNode(node);
                    } else if ("CONTAINS".equals(child)) {
                        newNode = new TmfFilterContainsNode(node);
                    } else if ("EQUALS".equals(child)) {
                        newNode = new TmfFilterEqualsNode(node);
                    } else if ("MATCHES".equals(child)) {
                        newNode = new TmfFilterMatchesNode(node);
                    } else if ("COMPARE".equals(child)) {
                        newNode = new TmfFilterCompareNode(node);
                    }
                    if (newNode != null) {
                        FilterViewer.this.fViewer.refresh();
                        FilterViewer.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)newNode), true);
                    }
                }
            };
            if ("FILTER".equals(child)) {
                action.setText(Messages.FilterViewer_NewPrefix + " " + child);
            } else {
                action.setText(child);
            }
            manager.add((IAction)action);
        }
    }

    private void updateFilterNodeComposite(ITmfFilterTreeNode node) {
        Control[] controlArray = this.fComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        if (node instanceof TmfFilterNode) {
            new FilterNodeComposite(this.fComposite, (TmfFilterNode)node);
        } else if (node instanceof TmfFilterTraceTypeNode) {
            new FilterTraceTypeNodeComposite(this.fComposite, (TmfFilterTraceTypeNode)node);
        } else if (node instanceof TmfFilterAndNode) {
            new FilterAndNodeComposite(this.fComposite, (TmfFilterAndNode)node);
        } else if (node instanceof TmfFilterOrNode) {
            new FilterOrNodeComposite(this.fComposite, (TmfFilterOrNode)node);
        } else if (node instanceof TmfFilterContainsNode) {
            new FilterContainsNodeComposite(this.fComposite, (TmfFilterContainsNode)node);
        } else if (node instanceof TmfFilterEqualsNode) {
            new FilterEqualsNodeComposite(this.fComposite, (TmfFilterEqualsNode)node);
        } else if (node instanceof TmfFilterMatchesNode) {
            new FilterMatchesNodeComposite(this.fComposite, (TmfFilterMatchesNode)node);
        } else if (node instanceof TmfFilterCompareNode) {
            new FilterCompareNodeComposite(this.fComposite, (TmfFilterCompareNode)node);
        } else {
            new FilterBaseNodeComposite(this.fComposite, node);
        }
        this.fComposite.layout();
    }

    public void setInput(ITmfFilterTreeNode root) {
        this.fViewer.setInput((Object)root);
        this.fViewer.expandAll();
        this.updateFilterNodeComposite(null);
    }

    public ITmfFilterTreeNode getInput() {
        return (ITmfFilterTreeNode)this.fViewer.getInput();
    }

    public void refresh() {
        this.fViewer.refresh();
    }

    public void setSelection(ITmfFilterTreeNode node, boolean reveal) {
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node), reveal);
    }

    public void setSelection(ITmfFilterTreeNode node) {
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node));
    }

    public ITmfFilterTreeNode getSelection() {
        Object element;
        ISelection selection = this.fViewer.getSelection();
        ITmfFilterTreeNode filterTreeNode = null;
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ITmfFilterTreeNode) {
            filterTreeNode = (ITmfFilterTreeNode)element;
        }
        ITmfFilterTreeNode selectedNode = filterTreeNode;
        return selectedNode;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fViewer.removeSelectionChangedListener(listener);
    }

    public boolean setFocus() {
        return this.fViewer.getControl().setFocus();
    }

    public boolean isTreeInFocus() {
        return this.fViewer.getControl().isFocusControl();
    }

    TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    private static class AspectItem
    extends TraceTypeItem {
        private ITmfEventAspect<?> fEventAspect;

        public AspectItem(String label) {
            this(label, null, null);
        }

        public AspectItem(String label, ITmfEventAspect<?> eventAspect, String traceTypeId) {
            super(label, traceTypeId);
            this.fEventAspect = eventAspect;
        }

        public ITmfEventAspect<?> getEventAspect() {
            return this.fEventAspect;
        }

        public void setEventAspect(ITmfEventAspect<?> eventAspect) {
            this.fEventAspect = eventAspect;
        }
    }

    private class FilterAndNodeComposite
    extends FilterBaseNodeComposite {
        FilterAndNodeComposite(Composite parent, TmfFilterAndNode node) {
            super(parent, (ITmfFilterTreeNode)node);
        }
    }

    private abstract class FilterAspectNodeComposite
    extends FilterBaseNodeComposite {
        private final TmfFilterAspectNode fAspectNode;
        private CCombo fTraceTypeCombo;
        private CCombo fAspectCombo;
        private Label fFieldLabel;
        private Text fFieldText;
        private List<AspectItem> fAspectList;

        FilterAspectNodeComposite(Composite parent, TmfFilterAspectNode node) {
            super(parent, (ITmfFilterTreeNode)node);
            this.fAspectList = null;
            this.fAspectNode = node;
        }

        protected void createAspectControls() {
            Label label = new Label((Composite)this, 0);
            label.setText(Messages.FilterViewer_TypeLabel);
            final List<TraceTypeItem> traceTypeList = this.getTraceTypeList((ITmfFilterTreeNode)this.fAspectNode, this.fAspectNode.getTraceTypeId());
            this.fTraceTypeCombo = new CCombo((Composite)this, 12);
            this.fTraceTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            List<String> items = traceTypeList.stream().map(it -> it.getLabel()).collect(Collectors.toList());
            this.fTraceTypeCombo.setItems(items.toArray(new String[0]));
            if (this.fAspectNode.getTraceTypeId() == null) {
                this.fTraceTypeCombo.select(0);
                this.fAspectNode.setTraceTypeId(traceTypeList.get(0).getTraceTypeId());
            } else {
                int i = 0;
                while (i < traceTypeList.size()) {
                    TraceTypeItem traceType = traceTypeList.get(i);
                    if (this.fAspectNode.getTraceTypeId().equals(traceType.getTraceTypeId())) {
                        this.fTraceTypeCombo.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.fTraceTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TraceTypeItem traceType = (TraceTypeItem)traceTypeList.get(FilterAspectNodeComposite.this.fTraceTypeCombo.getSelectionIndex());
                    FilterAspectNodeComposite.this.fAspectNode.setTraceTypeId(traceType.getTraceTypeId());
                    FilterAspectNodeComposite.this.fAspectList = FilterAspectNodeComposite.this.getAspectList(FilterAspectNodeComposite.this.fAspectNode.getTraceTypeId());
                    List<String> aspectItems = FilterAspectNodeComposite.this.fAspectList.stream().map(it -> it.getLabel()).collect(Collectors.toList());
                    String text = FilterAspectNodeComposite.this.fAspectCombo.getText();
                    FilterAspectNodeComposite.this.fAspectCombo.removeAll();
                    FilterAspectNodeComposite.this.fAspectCombo.setItems(aspectItems.toArray(new String[0]));
                    int index = Arrays.asList(FilterAspectNodeComposite.this.fAspectCombo.getItems()).indexOf(text);
                    if (index >= 0 && !text.isEmpty()) {
                        FilterAspectNodeComposite.this.fAspectCombo.select(index);
                    }
                    ((FilterAspectNodeComposite)FilterAspectNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)FilterAspectNodeComposite.this.fAspectNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setText(Messages.FilterViewer_AspectLabel);
            this.fAspectList = this.getAspectList(this.fAspectNode.getTraceTypeId());
            this.fAspectCombo = new CCombo((Composite)this, 12);
            this.fAspectCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            for (AspectItem aspect : this.fAspectList) {
                this.fAspectCombo.add(aspect.getLabel());
            }
            if (this.fAspectNode.getEventAspect() != null) {
                int i = 0;
                while (i < this.fAspectList.size()) {
                    AspectItem aspect = this.fAspectList.get(i);
                    if (aspect.getEventAspect() != null && this.fAspectNode.getEventAspect().getName().equals(aspect.getEventAspect().getName()) && (this.fAspectNode.getTraceTypeId().equals(aspect.getTraceTypeId()) || this.fAspectNode.getTraceTypeId().equals("BASE.ASPECT.ID"))) {
                        this.fAspectCombo.select(i);
                        if (!(this.fAspectNode.getEventAspect() instanceof TmfEventFieldAspect)) break;
                        aspect.setEventAspect(this.fAspectNode.getEventAspect());
                        this.createFieldControls((TmfEventFieldAspect)this.fAspectNode.getEventAspect(), aspect);
                        break;
                    }
                    ++i;
                }
            }
            this.fAspectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selection = FilterAspectNodeComposite.this.fAspectCombo.getSelectionIndex();
                    AspectItem aspect = null;
                    if (selection != -1) {
                        aspect = FilterAspectNodeComposite.this.fAspectList.get(FilterAspectNodeComposite.this.fAspectCombo.getSelectionIndex());
                        FilterAspectNodeComposite.this.fAspectNode.setEventAspect(aspect.getEventAspect());
                    } else {
                        FilterAspectNodeComposite.this.fAspectNode.setEventAspect(null);
                    }
                    if (FilterAspectNodeComposite.this.fAspectNode.getEventAspect() instanceof TmfEventFieldAspect) {
                        TmfEventFieldAspect eventFieldAspect = (TmfEventFieldAspect)FilterAspectNodeComposite.this.fAspectNode.getEventAspect();
                        FilterAspectNodeComposite.this.createFieldControls(eventFieldAspect, aspect);
                        FilterAspectNodeComposite.this.layout();
                    } else if (FilterAspectNodeComposite.this.fFieldLabel != null && FilterAspectNodeComposite.this.fFieldText != null) {
                        FilterAspectNodeComposite.this.fFieldLabel.dispose();
                        FilterAspectNodeComposite.this.fFieldLabel = null;
                        FilterAspectNodeComposite.this.fFieldText.dispose();
                        FilterAspectNodeComposite.this.fFieldText = null;
                        FilterAspectNodeComposite.this.layout();
                    }
                    ((FilterAspectNodeComposite)FilterAspectNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)FilterAspectNodeComposite.this.fAspectNode);
                }
            });
        }

        private void createFieldControls(TmfEventFieldAspect eventFieldAspect, AspectItem aspect) {
            if (this.fFieldLabel != null) {
                this.fFieldLabel.dispose();
            }
            this.fFieldLabel = new Label((Composite)this, 0);
            this.fFieldLabel.moveBelow((Control)this.fAspectCombo);
            this.fFieldLabel.setText(Messages.FilterViewer_FieldLabel);
            if (this.fFieldText != null) {
                this.fFieldText.dispose();
            }
            this.fFieldText = new Text((Composite)this, 2048);
            this.fFieldText.moveBelow((Control)this.fFieldLabel);
            this.fFieldText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fFieldText.setToolTipText(Messages.FilterViewer_Subfield_ToolTip);
            if (eventFieldAspect.getFieldPath() != null) {
                this.fFieldText.setText(eventFieldAspect.getFieldPath());
            }
            if (this.fFieldText.getText().length() == 0) {
                this.fFieldText.setData((Object)"$text-hint--");
                this.fFieldText.setText(Messages.FilterViewer_FieldHint);
                this.layout();
                this.fFieldText.setForeground(SEL_FOREGROUND_COLOR);
            }
            this.fFieldText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterAspectNodeComposite.this.fFieldText.getText().length() == 0) {
                        FilterAspectNodeComposite.this.fFieldText.setData((Object)"$text-hint--");
                        FilterAspectNodeComposite.this.fFieldText.setForeground(SEL_FOREGROUND_COLOR);
                        FilterAspectNodeComposite.this.fFieldText.setText(Messages.FilterViewer_FieldHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterAspectNodeComposite.this.fFieldText.getData() != null) {
                        FilterAspectNodeComposite.this.fFieldText.setData(null);
                        FilterAspectNodeComposite.this.fFieldText.setText("");
                    }
                    FilterAspectNodeComposite.this.fFieldText.setForeground(FOREGROUND_COLOR);
                }
            });
            this.fFieldText.addModifyListener(e -> {
                if (this.fFieldText.getData() == null) {
                    if (this.fFieldText.getText().isEmpty()) {
                        this.fAspectNode.setEventAspect((ITmfEventAspect)eventFieldAspect.forField(null));
                    } else {
                        this.fAspectNode.setEventAspect((ITmfEventAspect)eventFieldAspect.forField(this.fFieldText.getText()));
                    }
                    aspect.setEventAspect(this.fAspectNode.getEventAspect());
                    FilterViewer.this.fViewer.refresh((Object)this.fAspectNode);
                }
            });
        }

        private List<TraceTypeItem> getTraceTypeList(ITmfFilterTreeNode node, String selected) {
            ArrayList<TraceTypeItem> traceTypeList = new ArrayList<TraceTypeItem>();
            traceTypeList.add(new TraceTypeItem(Messages.FilterViewer_CommonCategory, "BASE.ASPECT.ID"));
            ITmfFilterTreeNode curNode = node;
            while (curNode != null) {
                if (curNode instanceof TmfFilterTraceTypeNode) {
                    TmfFilterTraceTypeNode traceTypeNode = (TmfFilterTraceTypeNode)curNode;
                    TraceTypeHelper helper = TmfTraceType.getTraceType((String)traceTypeNode.getTraceTypeId());
                    if (helper != null) {
                        traceTypeList.set(0, new TraceTypeItem(helper.getLabel(), helper.getTraceTypeId()));
                    }
                    return traceTypeList;
                }
                curNode = curNode.getParent();
            }
            for (TraceTypeHelper helper : this.getTraceTypeMap(selected).values()) {
                traceTypeList.add(new TraceTypeItem(helper.getLabel(), helper.getTraceTypeId()));
            }
            return traceTypeList;
        }

        private List<AspectItem> getAspectList(String traceTypeId) {
            ArrayList<AspectItem> aspectList = new ArrayList<AspectItem>();
            aspectList.add(new AspectItem(Messages.FilterViewer_CommonCategory));
            for (ITmfEventAspect aspect : TmfBaseAspects.getBaseAspects()) {
                aspectList.add(new AspectItem(aspect.getName(), aspect, "BASE.ASPECT.ID"));
            }
            TraceTypeHelper helper = TmfTraceType.getTraceType((String)traceTypeId);
            if (helper != null) {
                aspectList.add(new AspectItem(""));
                aspectList.add(new AspectItem("[" + helper.getLabel() + "]"));
                for (ITmfEventAspect aspect : helper.getTrace().getEventAspects()) {
                    for (AspectItem baseAspect : aspectList) {
                        if (!aspect.equals(baseAspect.getEventAspect())) continue;
                        aspectList.remove(baseAspect);
                        break;
                    }
                    aspectList.add(new AspectItem(aspect.getName(), aspect, helper.getTraceTypeId()));
                }
            }
            return aspectList;
        }
    }

    private class FilterBaseNodeComposite
    extends Composite {
        FilterBaseNodeComposite(Composite parent, ITmfFilterTreeNode node) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout(2, false));
            this.setLayoutData(new GridData(4, 4, true, true));
            if (node instanceof ITmfFilterWithNot) {
                this.createNotButton((ITmfFilterWithNot)node);
            }
        }

        protected Map<String, TraceTypeHelper> getTraceTypeMap(String selected) {
            TreeMap<String, TraceTypeHelper> traceTypeMap = new TreeMap<String, TraceTypeHelper>();
            for (TraceTypeHelper helper : TmfTraceType.getTraceTypeHelpers()) {
                if (helper.isExperimentType() || !helper.isEnabled() && !helper.getTraceTypeId().equals(selected)) continue;
                traceTypeMap.put(helper.getLabel(), helper);
            }
            return traceTypeMap;
        }

        protected Button createNotButton(final ITmfFilterWithNot node) {
            Label label = new Label((Composite)this, 0);
            label.setText(Messages.FilterViewer_NotLabel);
            final Button notButton = new Button((Composite)this, 32);
            notButton.setSelection(node.isNot());
            notButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    node.setNot(notButton.getSelection());
                    ((FilterBaseNodeComposite)FilterBaseNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)node);
                }
            });
            return notButton;
        }

        protected Text createValueText(final ITmfFilterWithValue valueNode) {
            Label label = new Label((Composite)this, 0);
            label.setText(Messages.FilterViewer_ValueLabel);
            final Text valueText = new Text((Composite)this, 2048);
            valueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            String value = valueNode.getValue();
            if (value != null && value.length() > 0) {
                valueText.setText(value);
                valueText.setData(null);
            } else {
                valueText.setText(Messages.FilterViewer_ValueHint);
                valueText.setData((Object)"$text-hint--");
                this.layout();
                valueText.setForeground(SEL_FOREGROUND_COLOR);
            }
            valueText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    String myValue = valueNode.getValue();
                    if (myValue == null || myValue.length() == 0) {
                        valueText.setData((Object)"$text-hint--");
                        valueText.setForeground(SEL_FOREGROUND_COLOR);
                        valueText.setText(Messages.FilterViewer_ValueHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (valueText.getData() != null) {
                        valueText.setData(null);
                        valueText.setText("");
                    }
                    valueText.setForeground(FOREGROUND_COLOR);
                }
            });
            valueText.addModifyListener(e -> {
                if (valueText.getData() == null) {
                    valueNode.setValue(valueText.getText());
                    FilterViewer.this.fViewer.refresh((Object)valueNode);
                }
            });
            return valueText;
        }
    }

    private class FilterCompareNodeComposite
    extends FilterAspectNodeComposite {
        private final TmfFilterCompareNode fNode;
        private final Button fLTButton;
        private final Button fEQButton;
        private final Button fGTButton;
        private final Button fNumButton;
        private final Button fAlphaButton;
        private final Button fTimestampButton;

        FilterCompareNodeComposite(Composite parent, TmfFilterCompareNode node) {
            super(parent, (TmfFilterAspectNode)node);
            this.fNode = node;
            this.createAspectControls();
            Label label = new Label((Composite)this, 0);
            label.setText(Messages.FilterViewer_ResultLabel);
            Composite resultGroup = new Composite((Composite)this, 0);
            GridLayout rggl = new GridLayout(3, true);
            rggl.marginHeight = 0;
            rggl.marginWidth = 0;
            resultGroup.setLayout((Layout)rggl);
            this.fLTButton = new Button(resultGroup, 16);
            this.fLTButton.setSelection(this.fNode.getResult() < 0);
            this.fLTButton.setText("<");
            this.fLTButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fLTButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setResult(-1);
                    }
                    ((FilterCompareNodeComposite)FilterCompareNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fEQButton = new Button(resultGroup, 16);
            this.fEQButton.setSelection(this.fNode.getResult() == 0);
            this.fEQButton.setText("=");
            this.fEQButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fEQButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setResult(0);
                    }
                    ((FilterCompareNodeComposite)FilterCompareNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fGTButton = new Button(resultGroup, 16);
            this.fGTButton.setSelection(this.fNode.getResult() > 0);
            this.fGTButton.setText(">");
            this.fGTButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fGTButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setResult(1);
                    }
                    ((FilterCompareNodeComposite)FilterCompareNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            label = new Label((Composite)this, 0);
            label.setText(Messages.FilterViewer_TypeLabel);
            Composite typeGroup = new Composite((Composite)this, 0);
            GridLayout tggl = new GridLayout(3, false);
            tggl.marginHeight = 0;
            tggl.marginWidth = 0;
            typeGroup.setLayout((Layout)tggl);
            this.fNumButton = new Button(typeGroup, 16);
            this.fNumButton.setSelection(this.fNode.getType() == TmfFilterCompareNode.Type.NUM);
            this.fNumButton.setText(Messages.FilterViewer_NumButtonText);
            this.fNumButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fNumButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setType(TmfFilterCompareNode.Type.NUM);
                    }
                    ((FilterCompareNodeComposite)FilterCompareNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fAlphaButton = new Button(typeGroup, 16);
            this.fAlphaButton.setSelection(this.fNode.getType() == TmfFilterCompareNode.Type.ALPHA);
            this.fAlphaButton.setText(Messages.FilterViewer_AlphaButtonText);
            this.fAlphaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fAlphaButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setType(TmfFilterCompareNode.Type.ALPHA);
                    }
                    ((FilterCompareNodeComposite)FilterCompareNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.fTimestampButton = new Button(typeGroup, 16);
            this.fTimestampButton.setSelection(this.fNode.getType() == TmfFilterCompareNode.Type.TIMESTAMP);
            this.fTimestampButton.setText(Messages.FilterViewer_TimestampButtonText);
            this.fTimestampButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FilterCompareNodeComposite.this.fTimestampButton.getSelection()) {
                        FilterCompareNodeComposite.this.fNode.setType(TmfFilterCompareNode.Type.TIMESTAMP);
                    }
                    ((FilterCompareNodeComposite)FilterCompareNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)FilterCompareNodeComposite.this.fNode);
                }
            });
            this.createValueText((ITmfFilterWithValue)this.fNode);
        }
    }

    private class FilterContainsNodeComposite
    extends FilterAspectNodeComposite {
        private final TmfFilterContainsNode fNode;
        private final Button fIgnoreCaseButton;

        FilterContainsNodeComposite(Composite parent, TmfFilterContainsNode node) {
            super(parent, (TmfFilterAspectNode)node);
            this.fNode = node;
            this.createAspectControls();
            this.createValueText((ITmfFilterWithValue)this.fNode);
            new Label((Composite)this, 0);
            this.fIgnoreCaseButton = new Button((Composite)this, 32);
            this.fIgnoreCaseButton.setSelection(this.fNode.isIgnoreCase());
            this.fIgnoreCaseButton.setText(Messages.FilterViewer_IgnoreCaseButtonText);
            this.fIgnoreCaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterContainsNodeComposite.this.fNode.setIgnoreCase(FilterContainsNodeComposite.this.fIgnoreCaseButton.getSelection());
                    ((FilterContainsNodeComposite)FilterContainsNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)FilterContainsNodeComposite.this.fNode);
                }
            });
        }
    }

    private class FilterEqualsNodeComposite
    extends FilterAspectNodeComposite {
        private final TmfFilterEqualsNode fNode;
        private final Button fIgnoreCaseButton;

        FilterEqualsNodeComposite(Composite parent, TmfFilterEqualsNode node) {
            super(parent, (TmfFilterAspectNode)node);
            this.fNode = node;
            this.createAspectControls();
            this.createValueText((ITmfFilterWithValue)this.fNode);
            new Label((Composite)this, 0);
            this.fIgnoreCaseButton = new Button((Composite)this, 32);
            this.fIgnoreCaseButton.setSelection(this.fNode.isIgnoreCase());
            this.fIgnoreCaseButton.setText(Messages.FilterViewer_IgnoreCaseButtonText);
            this.fIgnoreCaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FilterEqualsNodeComposite.this.fNode.setIgnoreCase(FilterEqualsNodeComposite.this.fIgnoreCaseButton.getSelection());
                    ((FilterEqualsNodeComposite)FilterEqualsNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)FilterEqualsNodeComposite.this.fNode);
                }
            });
        }
    }

    private class FilterMatchesNodeComposite
    extends FilterAspectNodeComposite {
        private final TmfFilterMatchesNode fNode;
        private final Text fRegexText;

        FilterMatchesNodeComposite(Composite parent, TmfFilterMatchesNode node) {
            super(parent, (TmfFilterAspectNode)node);
            this.fNode = node;
            this.createAspectControls();
            Label label = new Label((Composite)this, 0);
            label.setText(Messages.FilterViewer_RegexLabel);
            this.fRegexText = new Text((Composite)this, 2048);
            this.fRegexText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getRegex() != null && node.getRegex().length() > 0) {
                this.fRegexText.setText(node.getRegex());
            } else {
                this.fRegexText.setText(Messages.FilterViewer_RegexHint);
                this.fRegexText.setData((Object)"$text-hint--");
                this.layout();
                this.fRegexText.setForeground(SEL_FOREGROUND_COLOR);
            }
            this.fRegexText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterMatchesNodeComposite.this.fNode.getRegex() == null || FilterMatchesNodeComposite.this.fNode.getRegex().length() == 0) {
                        FilterMatchesNodeComposite.this.fRegexText.setData((Object)"$text-hint--");
                        FilterMatchesNodeComposite.this.fRegexText.setForeground(SEL_FOREGROUND_COLOR);
                        FilterMatchesNodeComposite.this.fRegexText.setText(Messages.FilterViewer_RegexHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterMatchesNodeComposite.this.fRegexText.getData() != null) {
                        FilterMatchesNodeComposite.this.fRegexText.setData(null);
                        FilterMatchesNodeComposite.this.fRegexText.setText("");
                    }
                    FilterMatchesNodeComposite.this.fRegexText.setForeground(FOREGROUND_COLOR);
                }
            });
            this.fRegexText.addModifyListener(e -> {
                if (this.fRegexText.getData() == null) {
                    this.fNode.setRegex(this.fRegexText.getText());
                    FilterViewer.this.fViewer.refresh((Object)this.fNode);
                }
            });
        }
    }

    private class FilterNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterNode fNode;
        Text fNameText;

        FilterNodeComposite(Composite parent, TmfFilterNode node) {
            super(parent, (ITmfFilterTreeNode)node);
            this.fNode = node;
            Label label = new Label((Composite)this, 0);
            label.setText(Messages.FilterViewer_NameLabel);
            this.fNameText = new Text((Composite)this, 2048);
            this.fNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (node.getFilterName() != null && node.getFilterName().length() > 0) {
                this.fNameText.setText(node.getFilterName());
            } else {
                this.fNameText.setText(Messages.FilterViewer_FilterNameHint);
                this.fNameText.setData((Object)"$text-hint--");
                this.layout();
                this.fNameText.setForeground(SEL_FOREGROUND_COLOR);
            }
            this.fNameText.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (FilterNodeComposite.this.fNode.getFilterName() == null || FilterNodeComposite.this.fNode.getFilterName().length() == 0) {
                        FilterNodeComposite.this.fNameText.setForeground(SEL_FOREGROUND_COLOR);
                        FilterNodeComposite.this.fNameText.setData((Object)"$text-hint--");
                        FilterNodeComposite.this.fNameText.setText(Messages.FilterViewer_FilterNameHint);
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (FilterNodeComposite.this.fNameText.getData() != null) {
                        FilterNodeComposite.this.fNameText.setData(null);
                        FilterNodeComposite.this.fNameText.setText("");
                    }
                    FilterNodeComposite.this.fNameText.setForeground(FOREGROUND_COLOR);
                }
            });
            this.fNameText.addModifyListener(e -> {
                if (this.fNameText.getData() == null) {
                    this.fNode.setFilterName(this.fNameText.getText());
                    FilterViewer.this.fViewer.refresh((Object)this.fNode);
                }
            });
        }
    }

    private class FilterOrNodeComposite
    extends FilterBaseNodeComposite {
        FilterOrNodeComposite(Composite parent, TmfFilterOrNode node) {
            super(parent, (ITmfFilterTreeNode)node);
        }
    }

    private class FilterTraceTypeNodeComposite
    extends FilterBaseNodeComposite {
        TmfFilterTraceTypeNode fNode;
        CCombo fTypeCombo;
        Map<String, TraceTypeHelper> fTraceTypeMap;

        FilterTraceTypeNodeComposite(Composite parent, TmfFilterTraceTypeNode node) {
            super(parent, (ITmfFilterTreeNode)node);
            this.fNode = node;
            this.fTraceTypeMap = this.getTraceTypeMap(this.fNode.getTraceTypeId());
            Label label = new Label((Composite)this, 0);
            label.setText(Messages.FilterViewer_TypeLabel);
            this.fTypeCombo = new CCombo((Composite)this, 12);
            this.fTypeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fTypeCombo.setItems(this.fTraceTypeMap.keySet().toArray(new String[0]));
            if (this.fNode.getTraceTypeId() != null) {
                this.fTypeCombo.setText(this.fNode.getName());
            }
            this.fTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TraceTypeHelper helper = (TraceTypeHelper)NonNullUtils.checkNotNull((Object)FilterTraceTypeNodeComposite.this.fTraceTypeMap.get(FilterTraceTypeNodeComposite.this.fTypeCombo.getText()));
                    FilterTraceTypeNodeComposite.this.fNode.setTraceTypeId(helper.getTraceTypeId());
                    FilterTraceTypeNodeComposite.this.fNode.setTraceClass(helper.getTraceClass());
                    FilterTraceTypeNodeComposite.this.fNode.setName(FilterTraceTypeNodeComposite.this.fTypeCombo.getText());
                    ((FilterTraceTypeNodeComposite)FilterTraceTypeNodeComposite.this).FilterViewer.this.fViewer.refresh((Object)FilterTraceTypeNodeComposite.this.fNode);
                }
            });
        }
    }

    private static class TraceTypeItem {
        private final String fLabel;
        private final String fTraceTypeId;

        public TraceTypeItem(String label, String traceTypeId) {
            this.fLabel = label;
            this.fTraceTypeId = traceTypeId;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getTraceTypeId() {
            return this.fTraceTypeId;
        }
    }
}

