/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.snapshot;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Since;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.interval.json.TmfIntervalDeserializer;
import org.eclipse.tracecompass.internal.statesystem.core.interval.json.TmfIntervalSerializer;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;

@NonNullByDefault
public class StateSnapshot {
    private static final int SNAPSHOT_FORMAT_VERSION = 1;
    private static final String SNAPSHOT_DIRECTORY = ".tc-states";
    private static final String FILE_SUFFIX = ".snapshot.json";
    private static final Gson GSON = Objects.requireNonNull(new GsonBuilder().registerTypeAdapter(ITmfStateInterval.class, (Object)new TmfIntervalDeserializer()).registerTypeAdapter(ITmfStateInterval.class, (Object)new TmfIntervalSerializer()).create());
    @SerializedName(value="snapshot_format_version")
    @Since(value=1.0)
    private int fStateFormatVersion = 1;
    @SerializedName(value="ssid")
    @Since(value=1.0)
    private String fSsid;
    @SerializedName(value="snapshot_version")
    @Since(value=1.0)
    private int fVersion;
    @SerializedName(value="timestamp")
    @Since(value=1.0)
    private int fTimestamp;
    @SerializedName(value="attributes")
    @Since(value=1.0)
    private Collection<AttributeAndInterval> fAttributes = Collections.emptyList();
    private final long fEndTime;
    private long fStartTime;

    public int getStateFormatVersion() {
        return this.fStateFormatVersion;
    }

    public String getSsid() {
        return this.fSsid;
    }

    public Map<List<String>, ITmfStateInterval> getStates() {
        return this.fAttributes.stream().collect(Collectors.toMap(AttributeAndInterval::getPath, AttributeAndInterval::getInterval));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public StateSnapshot(ITmfStateSystem ss, long start, long end, int version) {
        List<ITmfStateInterval> fullQuery;
        this.fStartTime = start;
        this.fEndTime = end;
        this.fVersion = version;
        this.fSsid = String.valueOf(ss.getSSID());
        try {
            fullQuery = ss.queryFullState(start);
        }
        catch (StateSystemDisposedException e1) {
            this.fVersion = -1;
            return;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull ImmutableList.Builder states = new ImmutableList.Builder();
        int quark = 0;
        while (quark < ss.getNbAttributes()) {
            String @NonNull [] fullAttributePathArray = ss.getFullAttributePathArray(quark);
            ITmfStateInterval interval = fullQuery.get(quark);
            long startTime = Math.max(interval.getStartTime(), this.fStartTime);
            long endTime = interval.getEndTime() > this.fEndTime ? Long.MIN_VALUE : interval.getEndTime();
            interval = new TmfStateInterval(startTime, endTime, interval.getAttribute(), interval.getValue());
            states.add((Object)new AttributeAndInterval(Arrays.asList(fullAttributePathArray), interval));
            ++quark;
        }
        this.fAttributes = states.build();
    }

    public StateSnapshot(ITmfStateSystem ss, long timestamp, int version) {
        this(ss, timestamp, timestamp, version);
    }

    public int getVersion() {
        return this.fVersion;
    }

    public void write(Path parentPath) throws IOException {
        String fileName;
        Path filePath;
        Path sdPath = parentPath.resolve(SNAPSHOT_DIRECTORY);
        if (!sdPath.toFile().exists()) {
            Files.createDirectory(sdPath, new FileAttribute[0]);
        }
        if ((filePath = sdPath.resolve(fileName = this.fSsid + FILE_SUFFIX)).toFile().exists()) {
            Files.delete(filePath);
        }
        Files.createFile(filePath, new FileAttribute[0]);
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedWriter bw = Files.newBufferedWriter(filePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            String json = GSON.toJson((Object)this);
            bw.write(json);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static @Nullable StateSnapshot read(Path parentPath, String ssid) {
        Path sdPath = parentPath.resolve(SNAPSHOT_DIRECTORY);
        if (!sdPath.toFile().isDirectory()) {
            return null;
        }
        String fileName = ssid + FILE_SUFFIX;
        Path filePath = sdPath.resolve(fileName);
        if (!filePath.toFile().exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStreamReader in = new InputStreamReader(Files.newInputStream(filePath, StandardOpenOption.READ));){
                BufferedReader bufReader = new BufferedReader(in);
                String json = bufReader.lines().collect(Collectors.joining("\n"));
                return (StateSnapshot)GSON.fromJson(json, StateSnapshot.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError("Error reading snapshot " + String.valueOf(parentPath) + " " + ssid, e);
            return null;
        }
    }

    private static final class AttributeAndInterval {
        @SerializedName(value="Path")
        @Since(value=1.0)
        private final List<@NonNull String> fAttribute;
        @SerializedName(value="Value")
        @Since(value=1.0)
        private final ITmfStateInterval fInterval;

        public AttributeAndInterval(List<@NonNull String> path, ITmfStateInterval value) {
            this.fAttribute = path;
            this.fInterval = value;
        }

        public List<@NonNull String> getPath() {
            return this.fAttribute;
        }

        public ITmfStateInterval getInterval() {
            return this.fInterval;
        }
    }
}

