/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.ui.views.global;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.incubator.internal.filters.ui.views.global.GlobalFilterViewer;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TmfFilterAppliedSignal;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TraceCompassFilter;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.component.ITmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;

public class GlobalFilterView
extends TmfView {
    private @Nullable GlobalFilterViewer fViewer = null;

    public GlobalFilterView() {
        super("Global Filters View");
    }

    public void setFocus() {
        if (this.fViewer != null) {
            this.fViewer.setFocus();
        }
    }

    public void createPartControl(@Nullable Composite parent) {
        super.createPartControl(parent);
        if (parent == null) {
            return;
        }
        this.fViewer = new GlobalFilterViewer((ITmfComponent)this, parent, 0);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new Action(){

            public String getDescription() {
                return "Delete the currently selected filters";
            }

            public String getText() {
                return "Delete";
            }

            public ImageDescriptor getImageDescriptor() {
                return Activator.getDefault().getImageDescripterFromPath("icons/elcl16/remove_bookmark.gif");
            }

            public void run() {
                if (GlobalFilterView.this.fViewer != null) {
                    GlobalFilterView.this.fViewer.deleteSelected();
                }
            }
        });
    }

    @TmfSignalHandler
    public void eventSearchApplied(TmfFilterAppliedSignal signal) {
        if (signal.getSource() == this) {
            return;
        }
        this.applySearchOrFilter(signal.getFilter().getRegexes());
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (trace == null) {
            this.applySearchOrFilter(Collections.emptyList());
            return;
        }
        TraceCompassFilter filter = TraceCompassFilter.getFilterForTrace((ITmfTrace)trace);
        this.applySearchOrFilter(filter == null ? Collections.emptyList() : filter.getRegexes());
    }

    private void applySearchOrFilter(Collection<String> regexes) {
        GlobalFilterViewer viewer = this.fViewer;
        if (viewer == null) {
            return;
        }
        viewer.eventFilterApplied(regexes);
    }
}

