/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.ISimpleDatatypeDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerRange;
import org.eclipse.tracecompass.internal.ctf.core.utils.LEB128;

@NonNullByDefault
public final class IntegerDeclaration
extends Declaration
implements ISimpleDatatypeDeclaration {
    private static final int BYTE_ALIGN = 8;
    private static final int BASE_10 = 10;
    private static final int SIZE_8 = 8;
    public static final IntegerDeclaration UINT_32B_DECL = new IntegerDeclaration(32, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_32L_DECL = new IntegerDeclaration(32, false, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration INT_32B_DECL = new IntegerDeclaration(32, true, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration INT_32L_DECL = new IntegerDeclaration(32, true, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration UINT_64B_DECL = new IntegerDeclaration(64, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_64L_DECL = new IntegerDeclaration(64, false, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration INT_64B_DECL = new IntegerDeclaration(64, true, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration INT_64L_DECL = new IntegerDeclaration(64, true, ByteOrder.LITTLE_ENDIAN);
    public static final IntegerDeclaration UINT_8_DECL = new IntegerDeclaration(8, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration INT_8_DECL = new IntegerDeclaration(8, true, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_5B_DECL = new IntegerDeclaration(5, false, 10, ByteOrder.BIG_ENDIAN, Encoding.NONE, "", 1L);
    public static final IntegerDeclaration UINT_5L_DECL = new IntegerDeclaration(5, false, 10, ByteOrder.LITTLE_ENDIAN, Encoding.NONE, "", 1L);
    public static final IntegerDeclaration UINT_27B_DECL = new IntegerDeclaration(27, false, 10, ByteOrder.BIG_ENDIAN, Encoding.NONE, "", 1L);
    @Deprecated
    public static final IntegerDeclaration UINT_27L_DECL = new IntegerDeclaration(27, false, 10, ByteOrder.LITTLE_ENDIAN, Encoding.NONE, "", 1L);
    public static final IntegerDeclaration UINT_16B_DECL = new IntegerDeclaration(16, false, ByteOrder.BIG_ENDIAN);
    public static final IntegerDeclaration UINT_16L_DECL = new IntegerDeclaration(16, false, ByteOrder.LITTLE_ENDIAN);
    private final int fLength;
    private final boolean fSigned;
    private final int fBase;
    private final boolean fIsByteOrderSet;
    private final ByteOrder fByteOrder;
    private final Encoding fEncoding;
    private final long fAlignment;
    private final String fClock;
    private boolean fVarint = false;
    private Map<String, List<IntegerRange>> fMappings = new TreeMap<String, List<IntegerRange>>();
    private List<IntervalNode> fIntervalTree = new ArrayList<IntervalNode>();

    public static IntegerDeclaration createDeclaration(int len, boolean signed, int base, @Nullable ByteOrder byteOrder, Encoding encoding, String clock, long alignment, @Nullable String role) {
        return new IntegerDeclaration(len, signed, base, byteOrder, encoding, clock, alignment, role, null);
    }

    public static IntegerDeclaration createDeclaration(int len, boolean signed, int base, @Nullable ByteOrder byteOrder, Encoding encoding, String clock, long alignment, @Nullable String role, Map<String, List<IntegerRange>> mappings) {
        IntegerDeclaration decl = IntegerDeclaration.createDeclaration(len, signed, base, byteOrder, encoding, clock, alignment, role);
        decl.setMappings(mappings);
        return decl;
    }

    public static IntegerDeclaration createVarintDeclaration(boolean signed, int base, @Nullable String role, boolean varint) {
        IntegerDeclaration decl = new IntegerDeclaration(0, signed, base, null, Encoding.NONE, "", 0L);
        decl.setRole(role);
        decl.setVarint(varint);
        return decl;
    }

    public static IntegerDeclaration createVarintDeclaration(boolean signed, int base, @Nullable String role, boolean varint, @Nullable Map<String, List<IntegerRange>> mappings) {
        IntegerDeclaration decl = new IntegerDeclaration(0, signed, base, null, Encoding.NONE, "", 0L);
        decl.setRole(role);
        decl.setVarint(varint);
        if (mappings != null) {
            decl.setMappings(mappings);
        }
        return decl;
    }

    private IntegerDeclaration(int len, boolean signed, int base, @Nullable ByteOrder byteOrder, Encoding encoding, String clock, long alignment) {
        this.fLength = len;
        this.fSigned = signed;
        this.fBase = base;
        this.fIsByteOrderSet = byteOrder != null;
        this.fByteOrder = byteOrder == null ? ByteOrder.nativeOrder() : byteOrder;
        this.fEncoding = encoding;
        this.fClock = clock;
        this.fAlignment = Math.max(alignment, 1L);
    }

    private IntegerDeclaration(int len, boolean signed, int base, @Nullable ByteOrder byteOrder, Encoding encoding, String clock, long alignment, @Nullable String role, @Nullable Map<String, List<IntegerRange>> mappings) {
        this(len, signed, base, byteOrder, encoding, clock, alignment);
        this.setRole(role);
        if (mappings != null) {
            this.setMappings(mappings);
        }
    }

    private IntegerDeclaration(int len, boolean signed, @Nullable ByteOrder byteOrder) {
        this(len, signed, 10, byteOrder, Encoding.NONE, "", 8L, null, null);
    }

    public boolean isSigned() {
        return this.fSigned;
    }

    public boolean isVarint() {
        return this.fVarint;
    }

    private void setVarint(boolean varint) {
        this.fVarint = varint;
    }

    public Map<String, List<IntegerRange>> getMappings() {
        return this.fMappings;
    }

    private void setMappings(Map<String, List<IntegerRange>> mappings) {
        this.fMappings.clear();
        this.fMappings.putAll(mappings);
        this.buildIntervalTree();
    }

    private void buildIntervalTree() {
        this.fIntervalTree.clear();
        for (Map.Entry<String, List<IntegerRange>> entry : this.fMappings.entrySet()) {
            String name = entry.getKey();
            for (IntegerRange range : entry.getValue()) {
                this.fIntervalTree.add(new IntervalNode(range.getStart(), range.getEnd(), name));
            }
        }
        Collections.sort(this.fIntervalTree, Comparator.comparingLong(n -> n.start));
    }

    public int getBase() {
        return this.fBase;
    }

    @Override
    public boolean isByteOrderSet() {
        return this.fIsByteOrderSet;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.fByteOrder;
    }

    public Encoding getEncoding() {
        return this.fEncoding;
    }

    public boolean isCharacter() {
        return this.fLength == 8 && this.fEncoding != Encoding.NONE;
    }

    public boolean isUnsignedByte() {
        return this.fLength == 8 && !this.fSigned;
    }

    public int getLength() {
        return this.fLength;
    }

    @Override
    public long getAlignment() {
        return this.fAlignment;
    }

    public String getClock() {
        return this.fClock;
    }

    @Override
    public int getMaximumSize() {
        return this.fLength;
    }

    @Override
    public IntegerDefinition createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        ByteOrder byteOrder = input.getByteOrder();
        input.setByteOrder(this.fByteOrder);
        long value = this.read(input);
        input.setByteOrder(byteOrder);
        return new IntegerDefinition(this, definitionScope, fieldName, value);
    }

    public String toString() {
        return "[declaration] integer[length:" + this.fLength + (this.fSigned ? " " : " un") + "signed base:" + this.fBase + " byteOrder:" + String.valueOf(this.fByteOrder) + " encoding:" + String.valueOf((Object)this.fEncoding) + " alignment:" + this.fAlignment + "  clock:" + this.fClock + "]";
    }

    public BigInteger getMaxValue() {
        int significantBits = this.fLength - (this.fSigned ? 1 : 0);
        return Objects.requireNonNull(BigInteger.ONE.shiftLeft(significantBits).subtract(BigInteger.ONE));
    }

    public BigInteger getMinValue() {
        if (!this.fSigned) {
            return Objects.requireNonNull(BigInteger.ZERO);
        }
        int significantBits = this.fLength - 1;
        return Objects.requireNonNull(BigInteger.ONE.shiftLeft(significantBits).negate());
    }

    private long read(BitBuffer input) throws CTFException {
        if (this.isVarint()) {
            if (this.isSigned()) {
                return LEB128.readSignedLeb(input);
            }
            return LEB128.readUnsignedLeb(input);
        }
        this.alignRead(input);
        boolean signed = this.isSigned();
        int length = this.getLength();
        long bits = 0L;
        ByteOrder previousByteOrder = input.getByteOrder();
        if (this.getByteOrder() != input.getByteOrder()) {
            input.setByteOrder(this.getByteOrder());
        }
        if (length > 64) {
            throw new CTFException("Cannot read an integer with over 64 bits. Length given: " + length);
        }
        bits = input.get(length, signed);
        if (previousByteOrder != input.getByteOrder()) {
            input.setByteOrder(previousByteOrder);
        }
        return bits;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fAlignment, this.fBase, this.fByteOrder, this.fClock, this.fEncoding, this.fLength, this.fSigned, this.fMappings, this.getRole()});
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerDeclaration other = (IntegerDeclaration)obj;
        if (!this.isBinaryEquivalent(other)) {
            return false;
        }
        if (!this.fByteOrder.equals(other.fByteOrder)) {
            return false;
        }
        if (!this.fClock.equals(other.fClock)) {
            return false;
        }
        if (this.fEncoding != other.fEncoding) {
            return false;
        }
        if (!Objects.equals(this.fMappings, other.fMappings)) {
            return false;
        }
        if (!Objects.equals(this.getRole(), other.getRole())) {
            return false;
        }
        return this.fBase == other.fBase;
    }

    @Override
    public boolean isBinaryEquivalent(@Nullable IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerDeclaration other = (IntegerDeclaration)obj;
        return this.isBinaryEquivalent(other);
    }

    private boolean isBinaryEquivalent(IntegerDeclaration other) {
        if (this.fAlignment != other.fAlignment) {
            return false;
        }
        if (this.fLength != other.fLength) {
            return false;
        }
        if (this.fSigned != other.fSigned) {
            return false;
        }
        return this.fLength == 8 || this.fByteOrder.equals(other.fByteOrder);
    }

    String getMappingForValue(long value) {
        if (this.fIntervalTree.isEmpty()) {
            return "";
        }
        ArrayList<String> matches = new ArrayList<String>();
        int left = 0;
        int right = this.fIntervalTree.size() - 1;
        int lastValid = -1;
        while (left <= right) {
            int mid = (left + right) / 2;
            if (this.fIntervalTree.get((int)mid).start <= value) {
                lastValid = mid;
                left = mid + 1;
                continue;
            }
            right = mid - 1;
        }
        int i = lastValid;
        while (i >= 0) {
            IntervalNode node = this.fIntervalTree.get(i);
            if (node.end >= value) {
                matches.add(node.name);
            }
            --i;
        }
        return matches.isEmpty() ? "" : Objects.requireNonNull(String.join((CharSequence)" ", matches));
    }

    private static class IntervalNode {
        final long start;
        final long end;
        final String name;

        IntervalNode(long start, long end, String name) {
            this.start = start;
            this.end = end;
            this.name = name;
        }
    }
}

