/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.NamedMember;
import org.eclipse.wst.jsdt.internal.core.ResolvedSourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceMethodElementInfo;

public class SourceMethod
extends NamedMember
implements IFunction {
    protected String[] parameterTypes;

    protected SourceMethod(JavaElement parent, String name, String[] parameterTypes) {
        super(parent, name);
        this.parameterTypes = parameterTypes == null ? CharOperation.NO_STRINGS : parameterTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SourceMethod)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int getElementType() {
        return 9;
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '~';
    }

    @Override
    public String getKey() {
        try {
            return this.getKey(this, false);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
    }

    @Override
    public int getNumberOfParameters() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    @Override
    public String[] getParameterNames() throws JavaScriptModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        char[][] names = info.getArgumentNames();
        return CharOperation.toStrings(names);
    }

    @Override
    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public IJavaScriptElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && (cu = (CompilationUnit)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        IJavaScriptElement primaryParent = this.parent.getPrimaryElement(false);
        if (primaryParent instanceof IType) {
            return ((IType)primaryParent).getFunction(this.name, this.parameterTypes);
        }
        return ((IJavaScriptUnit)primaryParent).getFunction(this.name, this.parameterTypes);
    }

    @Override
    public String[] getRawParameterNames() throws JavaScriptModelException {
        return this.getParameterNames();
    }

    @Override
    public String getReturnType() throws JavaScriptModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return Signature.createTypeSignature(info.getReturnTypeName(), false);
    }

    @Override
    public String getSignature() throws JavaScriptModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return Signature.createMethodSignature(this.parameterTypes, Signature.createTypeSignature(info.getReturnTypeName(), false));
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return hash;
    }

    @Override
    public boolean isConstructor() throws JavaScriptModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return info.isConstructor();
    }

    public boolean isMainMethod() throws JavaScriptModelException {
        return this.isMainMethod(this);
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public boolean isSimilar(IFunction method) {
        return SourceMethod.areSimilarMethods(this.getElementName(), this.getParameterTypes(), method.getElementName(), method.getParameterTypes(), null);
    }

    @Override
    public String readableName() {
        int length;
        StringBuffer buffer = new StringBuffer(super.readableName());
        buffer.append('(');
        if (this.parameterTypes != null && (length = this.parameterTypes.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString(this.parameterTypes[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedSourceMethod resolvedHandle = new ResolvedSourceMethod(this.parent, this.name, this.parameterTypes, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            SourceMethodElementInfo methodInfo = (SourceMethodElementInfo)info;
            int flags = methodInfo.getModifiers();
            if (Flags.isStatic(flags)) {
                buffer.append("static ");
            }
            if (!methodInfo.isConstructor()) {
                buffer.append("function ");
            }
            this.toStringName(buffer, flags);
        }
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        this.toStringName(buffer, 0);
    }

    protected void toStringName(StringBuffer buffer, int flags) {
        int length;
        buffer.append(this.getElementName());
        buffer.append('(');
        String[] parameters = this.getParameterTypes();
        if (parameters != null && (length = parameters.length) > 0) {
            boolean isVarargs = Flags.isVarargs(flags);
            int i = 0;
            while (i < length) {
                try {
                    if (i < length - 1) {
                        buffer.append("p" + i);
                        buffer.append(", ");
                    } else if (isVarargs) {
                        String parameter = parameters[i].substring(1);
                        buffer.append(Signature.toString(parameter));
                        buffer.append(" ...");
                    } else {
                        buffer.append("p" + i);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    buffer.append("*** invalid signature: ");
                    buffer.append(parameters[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }

    @Override
    public IFunction getFunction(String selector, String[] parameterTypeSignatures) {
        return new SourceMethod(this, selector, parameterTypeSignatures);
    }

    @Override
    public String getDisplayName() {
        String displayName = super.getDisplayName();
        if (displayName.equals("___anonymous")) {
            displayName = "";
        }
        return displayName;
    }
}

