/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.dnd;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.ease.ui.dialogs.ParametersDialog;
import org.eclipse.ease.ui.dnd.AbstractModuleDropHandler;
import org.eclipse.ease.ui.dnd.IShellDropHandler;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.swt.widgets.Display;

public class ModulesDropHandler
extends AbstractModuleDropHandler
implements IShellDropHandler {
    public static final String NULL_INDICATOR = "<null>";

    @Override
    public boolean accepts(IScriptEngine scriptEngine, Object element) {
        return element instanceof ModuleDefinition || element instanceof ModulesTools.ModuleEntry;
    }

    @Override
    public void performDrop(IScriptEngine scriptEngine, Object element) {
        this.performDrop(scriptEngine, element, 1);
    }

    @Override
    public void performDrop(IScriptEngine scriptEngine, Object element, int detail) {
        if (element instanceof ModuleDefinition) {
            this.loadModule(scriptEngine, ((ModuleDefinition)element).getPath().toString(), true);
        } else if (element instanceof ModulesTools.ModuleEntry) {
            ModuleDefinition declaringModule = ((ModulesTools.ModuleEntry)element).getModuleDefinition();
            this.loadModule(scriptEngine, declaringModule.getPath().toString(), false);
            if (((ModulesTools.ModuleEntry)element).getEntry() instanceof Method) {
                Method method = (Method)((ModulesTools.ModuleEntry)element).getEntry();
                if (detail != 1 && this.hasParameters(method)) {
                    this.executeCallWithParameters(scriptEngine, method);
                } else {
                    this.executeDefaultCall(scriptEngine, method);
                }
            } else if (((ModulesTools.ModuleEntry)element).getEntry() instanceof Field) {
                scriptEngine.execute((Object)((Field)((ModulesTools.ModuleEntry)element).getEntry()).getName());
            }
        }
    }

    private boolean hasParameters(Method method) {
        return method.getParameterCount() > 0;
    }

    private void executeCallWithParameters(IScriptEngine scriptEngine, Method method) {
        ICodeFactory codeFactory = ScriptService.getCodeFactory((IScriptEngine)scriptEngine);
        ParametersDialog dialog = new ParametersDialog(Display.getDefault().getActiveShell(), method, method.getParameters());
        if (dialog.open() == 0) {
            String call = codeFactory.createFunctionCall(method, this.createParameterInstances(method, dialog.getParameters()));
            scriptEngine.execute((Object)call);
        }
    }

    private Object[] createParameterInstances(Method method, List<String> parameters) {
        ArrayList<Object> instances = new ArrayList<Object>();
        int index = 0;
        while (index < Math.min(method.getParameterCount(), parameters.size())) {
            Parameter parameter = method.getParameters()[index];
            instances.add(this.convert(parameters.get(index), parameter.getType()));
            ++index;
        }
        return instances.toArray();
    }

    private Object convert(String input, Class<?> targetClass) {
        if (NULL_INDICATOR.equals(input)) {
            return null;
        }
        if (String.class.equals(targetClass) || Object.class.equals(targetClass)) {
            return input;
        }
        if (Integer.class.equals(targetClass) || Integer.TYPE.equals(targetClass)) {
            return Integer.valueOf(input);
        }
        if (Long.class.equals(targetClass) || Long.TYPE.equals(targetClass)) {
            return Long.valueOf(input);
        }
        if (Double.class.equals(targetClass) || Double.TYPE.equals(targetClass)) {
            return Double.valueOf(input);
        }
        if (Float.class.equals(targetClass) || Float.TYPE.equals(targetClass)) {
            return Float.valueOf(input);
        }
        if (Boolean.class.equals(targetClass) || Boolean.TYPE.equals(targetClass)) {
            return Boolean.valueOf(input);
        }
        throw new IllegalArgumentException(String.format("Cannot convert '%s' to %s", input, targetClass.getCanonicalName()));
    }

    private void executeDefaultCall(IScriptEngine scriptEngine, Method entry) {
        ICodeFactory codeFactory = ScriptService.getCodeFactory((IScriptEngine)scriptEngine);
        String call = codeFactory.createFunctionCall(entry, new Object[0]);
        scriptEngine.execute((Object)call);
    }
}

