/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.ui.views.executor;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ros2.core.analysis.executor.Ros2ExecutorDataProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.AbstractRos2DataProviderTimeGraphView;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.Ros2ObjectTreeLabelProvider;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.views.executor.Ros2ExecutorPresentationProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class Ros2ExecutorView
extends AbstractRos2DataProviderTimeGraphView {
    private static final String[] TREE_COLUMNS = new String[]{"", "Hostname"};
    private static final String ID_SUFFIX = ".executor";
    private static final String COLUMN_TEXT_PREFIX_MACHINE = "\ud83e\udd16 ";

    public Ros2ExecutorView() {
        super(Ros2ExecutorView.getFullViewId(), new Ros2ExecutorPresentationProvider(), Ros2ExecutorDataProvider.getFullDataProviderId());
        this.setTreeColumns(TREE_COLUMNS);
        this.setTreeLabelProvider(new Ros2ExecutorViewFilterLabelProvider());
        this.setFilterColumns(TREE_COLUMNS);
        this.setFilterLabelProvider(new Ros2ExecutorViewFilterLabelProvider());
    }

    public static @NonNull String getFullViewId() {
        return AbstractRos2DataProviderTimeGraphView.getViewIdFromSuffix(ID_SUFFIX);
    }

    private static class Ros2ExecutorViewFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private Ros2ExecutorViewFilterLabelProvider() {
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public String getColumnText(Object element, int columnIndex) {
            TimeGraphEntry entry = (TimeGraphEntry)element;
            ITmfTreeDataModel model = entry.getEntryModel();
            @NonNull List labels = model.getLabels();
            if (columnIndex >= 0 && columnIndex < TREE_COLUMNS.length) {
                if (labels.size() <= 1) {
                    if (columnIndex == 0) {
                        return entry.getName();
                    }
                } else {
                    if (columnIndex == 0) {
                        return Ros2ExecutorView.COLUMN_TEXT_PREFIX_MACHINE + entry.getName();
                    }
                    if (1 == columnIndex) {
                        return Ros2ObjectTreeLabelProvider.hostnameToString((String)labels.get(1));
                    }
                }
            } else if (columnIndex == 0) {
                return entry.getName();
            }
            return "";
        }
    }
}

