/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.ls.core.internal.DiagnosticsState;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.ActionMessages;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class NonProjectFixProcessor {
    public static final String REFRESH_DIAGNOSTICS_COMMAND = "java.project.refreshDiagnostics";
    private PreferenceManager preferenceManager;
    private DiagnosticsState nonProjectDiagnosticsState;

    public NonProjectFixProcessor(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
        this.nonProjectDiagnosticsState = JavaLanguageServerPlugin.getNonProjectDiagnosticsState();
    }

    public List<Either<Command, CodeAction>> getCorrections(CodeActionParams params, IInvocationContext context, IProblemLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Either<Command, CodeAction>> $ = new ArrayList<Either<Command, CodeAction>>();
        String uri = JDTUtils.toURI(context.getCompilationUnit());
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            Integer id = curr.getProblemId();
            if (id == 16 || id == 32) {
                if (this.nonProjectDiagnosticsState.isOnlySyntaxReported(uri)) {
                    $.add(this.getDiagnosticsFixes(ActionMessages.ReportAllErrorsForThisFile, uri, "thisFile", false));
                    $.add(this.getDiagnosticsFixes(ActionMessages.ReportAllErrorsForAnyNonProjectFile, uri, "anyNonProjectFile", false));
                } else {
                    $.add(this.getDiagnosticsFixes(ActionMessages.ReportSyntaxErrorsForThisFile, uri, "thisFile", true));
                    $.add(this.getDiagnosticsFixes(ActionMessages.ReportSyntaxErrorsForAnyNonProjectFile, uri, "anyNonProjectFile", true));
                }
            }
            ++i;
        }
        return $;
    }

    private Either<Command, CodeAction> getDiagnosticsFixes(String message, String uri, String scope, boolean syntaxOnly) {
        Command command = new Command(message, REFRESH_DIAGNOSTICS_COMMAND, Arrays.asList(uri, scope, syntaxOnly));
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("quickfix")) {
            CodeAction codeAction = new CodeAction(message);
            codeAction.setKind("quickfix");
            codeAction.setCommand(command);
            codeAction.setDiagnostics(Collections.emptyList());
            return Either.forRight((Object)codeAction);
        }
        return Either.forLeft((Object)command);
    }
}

