/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.compile;

import com.microsoft.gradle.compile.GradleCompilationUnit;
import com.microsoft.gradle.utils.LSPUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.eclipse.lsp4j.Range;

public class CompletionVisitor
extends ClassCodeVisitorSupport {
    private URI currentUri;
    private Map<URI, List<DependencyItem>> dependencies = new HashMap<URI, List<DependencyItem>>();
    private Map<URI, Set<MethodCallExpression>> methodCalls = new HashMap<URI, Set<MethodCallExpression>>();
    private Map<URI, List<Statement>> statements = new HashMap<URI, List<Statement>>();
    private Map<URI, List<Expression>> constants = new HashMap<URI, List<Expression>>();
    private Map<URI, Set<String>> plugins = new HashMap<URI, Set<String>>();

    public List<DependencyItem> getDependencies(URI uri) {
        return this.dependencies.get(uri);
    }

    public Set<MethodCallExpression> getMethodCalls(URI uri) {
        return this.methodCalls.get(uri);
    }

    public List<Statement> getStatements(URI uri) {
        return this.statements.get(uri);
    }

    public List<Expression> getConstants(URI uri) {
        return this.constants.get(uri);
    }

    public Set<String> getPlugins(URI uri) {
        return this.plugins.get(uri);
    }

    public void visitCompilationUnit(URI uri, GradleCompilationUnit compilationUnit) {
        this.currentUri = uri;
        compilationUnit.iterator().forEachRemaining(unit -> this.visitSourceUnit((SourceUnit)unit));
    }

    public void visitSourceUnit(SourceUnit unit) {
        ModuleNode moduleNode = unit.getAST();
        if (moduleNode != null) {
            this.dependencies.put(this.currentUri, new ArrayList());
            this.methodCalls.put(this.currentUri, new HashSet());
            this.statements.put(this.currentUri, new ArrayList());
            this.constants.put(this.currentUri, new ArrayList());
            this.plugins.put(this.currentUri, new HashSet());
            this.visitModule(moduleNode);
        }
    }

    public void visitModule(ModuleNode node) {
        BlockStatement blockStatement = node.getStatementBlock();
        this.statements.put(this.currentUri, blockStatement.getStatements());
        node.getClasses().forEach(classNode -> super.visitClass(classNode));
    }

    public void visitMethodCallExpression(MethodCallExpression node) {
        String plugin;
        this.methodCalls.get(this.currentUri).add(node);
        String methodName = node.getMethodAsString();
        if ("dependencies".equals(methodName)) {
            this.dependencies.get(this.currentUri).addAll(this.getDependencies(node));
        } else if ("plugins".equals(methodName)) {
            List<String> plugins = this.getPluginFromPlugins(node);
            this.plugins.get(this.currentUri).addAll(plugins);
        } else if ("apply".equals(methodName) && (plugin = this.getPluginFromApply(node)) != null) {
            this.plugins.get(this.currentUri).add(plugin);
        }
        super.visitMethodCallExpression(node);
    }

    private List<DependencyItem> getDependencies(MethodCallExpression expression) {
        Expression argument = expression.getArguments();
        if (argument instanceof ArgumentListExpression) {
            return this.getDependencies((ArgumentListExpression)argument);
        }
        return Collections.emptyList();
    }

    private List<DependencyItem> getDependencies(ArgumentListExpression argumentListExpression) {
        List expressions = argumentListExpression.getExpressions();
        ArrayList<DependencyItem> symbols = new ArrayList<DependencyItem>();
        for (Expression expression : expressions) {
            if (expression instanceof ClosureExpression) {
                symbols.addAll(this.getDependencies((ClosureExpression)expression));
                continue;
            }
            if (expression instanceof GStringExpression || expression instanceof ConstantExpression) {
                symbols.add(new DependencyItem(expression.getText(), LSPUtils.toDependencyRange(expression)));
                continue;
            }
            if (!(expression instanceof MethodCallExpression)) continue;
            symbols.addAll(this.getDependencies((MethodCallExpression)expression));
        }
        return symbols;
    }

    private List<DependencyItem> getDependencies(ClosureExpression expression) {
        Statement code = expression.getCode();
        if (code instanceof BlockStatement) {
            return this.getDependencies((BlockStatement)code);
        }
        return Collections.emptyList();
    }

    private List<DependencyItem> getDependencies(BlockStatement blockStatement) {
        List statements = blockStatement.getStatements();
        ArrayList<DependencyItem> results = new ArrayList<DependencyItem>();
        for (Statement statement : statements) {
            if (!(statement instanceof ExpressionStatement)) continue;
            results.addAll(this.getDependencies((ExpressionStatement)statement));
        }
        return results;
    }

    private List<DependencyItem> getDependencies(ExpressionStatement expressionStatement) {
        Expression expression = expressionStatement.getExpression();
        if (expression instanceof MethodCallExpression) {
            return this.getDependencies((MethodCallExpression)expression);
        }
        return Collections.emptyList();
    }

    private String getPluginFromApply(MethodCallExpression node) {
        Expression argument = node.getArguments();
        if (argument instanceof TupleExpression) {
            List expressions = ((TupleExpression)argument).getExpressions();
            for (Expression expression : expressions) {
                if (!(expression instanceof NamedArgumentListExpression)) continue;
                List mapEntryExpressions = ((NamedArgumentListExpression)expression).getMapEntryExpressions();
                for (MapEntryExpression mapEntryExp : mapEntryExpressions) {
                    Expression keyExpression = mapEntryExp.getKeyExpression();
                    if (!(keyExpression instanceof ConstantExpression) || !keyExpression.getText().equals("plugin")) continue;
                    return mapEntryExp.getValueExpression().getText();
                }
            }
        }
        return null;
    }

    private List<String> getPluginFromPlugins(MethodCallExpression node) {
        Expression objectExpression = node.getObjectExpression();
        if (objectExpression instanceof MethodCallExpression) {
            return this.getPluginFromPlugins((MethodCallExpression)objectExpression);
        }
        ArrayList<String> results = new ArrayList<String>();
        Expression argument = node.getArguments();
        if (argument instanceof ArgumentListExpression) {
            List expressions = ((ArgumentListExpression)argument).getExpressions();
            for (Expression expression : expressions) {
                Statement code;
                if (expression instanceof ConstantExpression && "id".equals(node.getMethodAsString())) {
                    results.add(expression.getText());
                    continue;
                }
                if (!(expression instanceof ClosureExpression) || !((code = ((ClosureExpression)expression).getCode()) instanceof BlockStatement)) continue;
                results.addAll(this.getPluginFromPlugins((BlockStatement)code));
            }
        }
        return results;
    }

    private List<String> getPluginFromPlugins(BlockStatement code) {
        ArrayList<String> results = new ArrayList<String>();
        List statements = code.getStatements();
        for (Statement statement : statements) {
            Expression expression;
            if (!(statement instanceof ExpressionStatement) || !((expression = ((ExpressionStatement)statement).getExpression()) instanceof MethodCallExpression)) continue;
            results.addAll(this.getPluginFromPlugins((MethodCallExpression)expression));
        }
        return results;
    }

    public void visitConstantExpression(ConstantExpression expression) {
        this.constants.get(this.currentUri).add((Expression)expression);
        super.visitConstantExpression(expression);
    }

    public void visitGStringExpression(GStringExpression expression) {
        this.constants.get(this.currentUri).add((Expression)expression);
        super.visitGStringExpression(expression);
    }

    public class DependencyItem {
        private String text;
        private Range range;

        public DependencyItem(String text, Range range) {
            this.text = text;
            this.range = range;
        }

        public String getText() {
            return this.text;
        }

        public Range getRange() {
            return this.range;
        }
    }
}

