/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.microsoft.gradle.compile.CompletionVisitor;
import com.microsoft.gradle.compile.DocumentSymbolVisitor;
import com.microsoft.gradle.compile.GradleCompilationUnit;
import com.microsoft.gradle.compile.SemanticTokenVisitor;
import com.microsoft.gradle.handlers.CompletionHandler;
import com.microsoft.gradle.handlers.DefaultDependenciesHandler;
import com.microsoft.gradle.handlers.MavenCentralCompletionHandler;
import com.microsoft.gradle.handlers.MavenIndexCompletionHandler;
import com.microsoft.gradle.handlers.MavenLocalCompletionHandler;
import com.microsoft.gradle.manager.GradleFilesManager;
import com.microsoft.gradle.resolver.GradleClosure;
import com.microsoft.gradle.resolver.GradleLibraryResolver;
import com.microsoft.gradle.semantictokens.SemanticToken;
import com.microsoft.gradle.utils.LSPUtils;
import com.microsoft.gradle.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.eclipse.lsp4j.util.Ranges;

public class GradleServices
implements TextDocumentService,
WorkspaceService,
LanguageClientAware {
    public static final List<String> supportedCommands = Arrays.asList("gradle.getDependencies", "gradle.distributionChanged", "gradle.setPlugins", "gradle.setClosures", "gradle.setScriptClasspaths");
    private LanguageClient client;
    private GradleFilesManager gradleFilesManager = new GradleFilesManager();
    private SemanticTokenVisitor semanticTokenVisitor = new SemanticTokenVisitor();
    private DocumentSymbolVisitor documentSymbolVisitor = new DocumentSymbolVisitor();
    private CompletionVisitor completionVisitor = new CompletionVisitor();
    private GradleLibraryResolver libraryResolver = new GradleLibraryResolver(this.gradleFilesManager);
    private DefaultDependenciesHandler defaultDependenciesHandler = new DefaultDependenciesHandler();
    private MavenCentralCompletionHandler mavenCentralCompletionHandler = new MavenCentralCompletionHandler();
    private MavenLocalCompletionHandler mavenLocalCompletionHandler = new MavenLocalCompletionHandler();
    private MavenIndexCompletionHandler mavenIndexCompletionHandler = new MavenIndexCompletionHandler();

    public GradleLibraryResolver getLibraryResolver() {
        return this.libraryResolver;
    }

    public void connect(LanguageClient client) {
        this.client = client;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        URI uri = URI.create(params.getTextDocument().getUri());
        this.gradleFilesManager.didOpen(uri, params.getTextDocument().getText());
        GradleCompilationUnit unit = this.gradleFilesManager.getCompilationUnit(uri, params.getTextDocument().getVersion(), false);
        this.compile(uri, unit);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        URI uri = URI.create(params.getTextDocument().getUri());
        for (TextDocumentContentChangeEvent change : params.getContentChanges()) {
            this.gradleFilesManager.didChange(uri, change);
        }
        GradleCompilationUnit unit = this.gradleFilesManager.getCompilationUnit(uri, params.getTextDocument().getVersion(), false);
        this.compile(uri, unit);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        URI uri = URI.create(params.getTextDocument().getUri());
        this.gradleFilesManager.didClose(uri);
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        Map settings = (Map)new Gson().fromJson((JsonElement)params.getSettings(), Map.class);
        this.applySetting(settings);
    }

    public void applySetting(Object settings) {
        if (settings instanceof Map) {
            this.getLibraryResolver().setGradleHome((String)((Map)settings).get("gradleHome"));
            this.getLibraryResolver().setGradleVersion((String)((Map)settings).get("gradleVersion"));
            this.getLibraryResolver().setGradleWrapperEnabled((Boolean)((Map)settings).get("gradleWrapperEnabled"));
            this.getLibraryResolver().setGradleUserHomePath((String)((Map)settings).get("gradleUserHome"));
            this.getLibraryResolver().resolveGradleAPI();
        }
    }

    private void compile(URI uri, GradleCompilationUnit unit) {
        if (unit == null) {
            return;
        }
        Set<Object> diagnostics = new HashSet<PublishDiagnosticsParams>();
        try {
            unit.compile(5);
            diagnostics.add(new PublishDiagnosticsParams(uri.toString(), Collections.emptyList()));
        }
        catch (CompilationFailedException e) {
            diagnostics = this.generateDiagnostics(unit.getErrorCollector());
        }
        for (PublishDiagnosticsParams publishDiagnosticsParams : diagnostics) {
            this.client.publishDiagnostics(publishDiagnosticsParams);
        }
    }

    private void recompileAll() {
        for (Map.Entry<URI, GradleCompilationUnit> entry : this.gradleFilesManager.getUnitStorage().entrySet()) {
            URI uri = entry.getKey();
            GradleCompilationUnit unit = this.gradleFilesManager.getCompilationUnit(uri, entry.getValue().getVersion(), true);
            this.compile(uri, unit);
        }
    }

    private Set<PublishDiagnosticsParams> generateDiagnostics(ErrorCollector collector) {
        HashMap diagnosticsStorage = new HashMap();
        for (Message error : collector.getErrors()) {
            if (!(error instanceof SyntaxErrorMessage)) continue;
            SyntaxException exp = ((SyntaxErrorMessage)error).getCause();
            Range range = LSPUtils.toRange(exp);
            Diagnostic diagnostic = new Diagnostic();
            diagnostic.setRange(range);
            diagnostic.setSeverity(DiagnosticSeverity.Error);
            diagnostic.setMessage(exp.getMessage());
            diagnostic.setSource("Gradle");
            if (diagnosticsStorage.containsKey(exp.getSourceLocator())) {
                ((List)diagnosticsStorage.get(exp.getSourceLocator())).add(diagnostic);
                continue;
            }
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            diagnostics.add(diagnostic);
            diagnosticsStorage.put(exp.getSourceLocator(), diagnostics);
        }
        HashSet<PublishDiagnosticsParams> diagnosticsParams = new HashSet<PublishDiagnosticsParams>();
        for (Map.Entry entry : diagnosticsStorage.entrySet()) {
            diagnosticsParams.add(new PublishDiagnosticsParams((String)entry.getKey(), (List)entry.getValue()));
        }
        return diagnosticsParams;
    }

    public CompletableFuture<SemanticTokens> semanticTokensFull(SemanticTokensParams params) {
        URI uri = URI.create(params.getTextDocument().getUri());
        GradleCompilationUnit unit = this.gradleFilesManager.getCompilationUnit(uri);
        if (unit == null) {
            return CompletableFuture.completedFuture(new SemanticTokens(Collections.emptyList()));
        }
        this.semanticTokenVisitor.visitCompilationUnit(uri, unit);
        List<SemanticToken> semanticTokens = this.semanticTokenVisitor.getSemanticTokens(uri);
        if (semanticTokens == null) {
            return CompletableFuture.completedFuture(new SemanticTokens(Collections.emptyList()));
        }
        return CompletableFuture.completedFuture(new SemanticTokens(SemanticToken.encodedTokens(semanticTokens)));
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        URI uri = URI.create(params.getTextDocument().getUri());
        GradleCompilationUnit unit = this.gradleFilesManager.getCompilationUnit(uri);
        if (unit == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        this.documentSymbolVisitor.visitCompilationUnit(uri, unit);
        List<DocumentSymbol> documentSymbols = this.documentSymbolVisitor.getDocumentSymbols(uri);
        if (documentSymbols == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList<Either> result = new ArrayList<Either>();
        for (DocumentSymbol symbol : documentSymbols) {
            result.add(Either.forRight((Object)symbol));
        }
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        URI uri = URI.create(params.getTextDocument().getUri());
        GradleCompilationUnit unit = this.gradleFilesManager.getCompilationUnit(uri);
        if (unit == null) {
            return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
        }
        this.completionVisitor.visitCompilationUnit(uri, unit);
        List<CompletionVisitor.DependencyItem> dependencies = this.completionVisitor.getDependencies(uri);
        if (dependencies == null) {
            return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
        }
        for (CompletionVisitor.DependencyItem dependencyItem : dependencies) {
            if (!Ranges.containsPosition((Range)dependencyItem.getRange(), (Position)params.getPosition())) continue;
            List<Object> results = new ArrayList<CompletionItem>();
            results.addAll(this.mavenIndexCompletionHandler.getDependencyCompletionItems(dependencyItem, params.getPosition()));
            results.addAll(this.mavenLocalCompletionHandler.getDependencyCompletionItems(dependencyItem, params.getPosition()));
            results.addAll(this.mavenCentralCompletionHandler.getDependencyCompletionItems(dependencyItem, params.getPosition()));
            results = results.stream().filter(Utils.distinctByKey(CompletionItem::getLabel)).collect(Collectors.toList());
            return CompletableFuture.completedFuture(Either.forLeft(results));
        }
        List<Expression> constants = this.completionVisitor.getConstants(uri);
        for (Expression constant : constants) {
            Range range = LSPUtils.toRange(constant);
            if (!Ranges.containsPosition((Range)range, (Position)params.getPosition())) continue;
            return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
        }
        Set<MethodCallExpression> set = this.completionVisitor.getMethodCalls(uri);
        MethodCallExpression containingCall = null;
        for (MethodCallExpression call : set) {
            Expression expression = call.getArguments();
            Range range = LSPUtils.toRange(expression);
            if (!Ranges.containsPosition((Range)range, (Position)params.getPosition()) || containingCall != null && !Ranges.containsRange((Range)LSPUtils.toRange(containingCall.getArguments()), (Range)LSPUtils.toRange(call.getArguments()))) continue;
            containingCall = call;
        }
        this.libraryResolver.loadGradleClasses(uri);
        boolean javaPluginsIncluded = this.libraryResolver.isJavaPluginsIncluded(uri, this.completionVisitor.getPlugins(uri));
        CompletionHandler handler = new CompletionHandler();
        String projectPath = Utils.getFolderPath(uri);
        if (containingCall == null && this.isGradleRoot(uri, params.getPosition())) {
            return CompletableFuture.completedFuture(Either.forLeft(handler.getCompletionItems(null, Paths.get(uri).getFileName().toString(), this.libraryResolver, javaPluginsIncluded, projectPath)));
        }
        return CompletableFuture.completedFuture(Either.forLeft(handler.getCompletionItems(containingCall, Paths.get(uri).getFileName().toString(), this.libraryResolver, javaPluginsIncluded, projectPath)));
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        String command = params.getCommand();
        List arguments = params.getArguments();
        if (command.equals("gradle.getDependencies")) {
            List<DocumentSymbol> dependencies;
            if (arguments.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            String uriString = (String)new Gson().fromJson((JsonElement)arguments.get(0), String.class);
            URI uri = URI.create(uriString);
            if (this.gradleFilesManager.getCompilationUnit(uri) == null) {
                try {
                    Path uriPath = Paths.get(uri);
                    String content = Files.asCharSource((File)uriPath.toFile(), (Charset)Charsets.UTF_8).read();
                    DidOpenTextDocumentParams openDocumentParams = new DidOpenTextDocumentParams(new TextDocumentItem(uriString, "gradle", 1, content));
                    this.didOpen(openDocumentParams);
                    DocumentSymbolParams documentSymbolParams = new DocumentSymbolParams(new TextDocumentIdentifier(uriString));
                    this.documentSymbol(documentSymbolParams);
                }
                catch (IOException e) {
                    return CompletableFuture.completedFuture(null);
                }
            }
            if ((dependencies = this.documentSymbolVisitor.getDependencies(uri)) == null) {
                return CompletableFuture.completedFuture(null);
            }
            List<DefaultDependenciesHandler.DefaultDependencyItem> result = this.defaultDependenciesHandler.getDefaultDependencies(dependencies);
            return CompletableFuture.completedFuture(result);
        }
        if (command.equals("gradle.distributionChanged")) {
            this.libraryResolver.resolveGradleAPI();
        } else if (command.equals("gradle.setPlugins")) {
            if (arguments.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            String projectPath = (String)new Gson().fromJson((JsonElement)arguments.get(0), String.class);
            String[] plugins = (String[])new Gson().fromJson((JsonElement)arguments.get(1), String[].class);
            this.libraryResolver.setProjectPlugins(projectPath, Arrays.asList(plugins));
        } else if (command.equals("gradle.setClosures")) {
            if (arguments.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            String projectPath = (String)new Gson().fromJson((JsonElement)arguments.get(0), String.class);
            GradleClosure[] closures = (GradleClosure[])new Gson().fromJson((JsonElement)arguments.get(1), GradleClosure[].class);
            this.libraryResolver.setExtClosures(projectPath, Arrays.asList(closures));
        } else if (command.equals("gradle.setScriptClasspaths")) {
            if (arguments.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            String projectPath = (String)new Gson().fromJson((JsonElement)arguments.get(0), String.class);
            String[] scriptClasspaths = (String[])new Gson().fromJson((JsonElement)arguments.get(1), String[].class);
            this.gradleFilesManager.setScriptClasspaths(projectPath, Arrays.asList(scriptClasspaths));
            this.recompileAll();
        }
        return CompletableFuture.completedFuture(null);
    }

    private boolean isGradleRoot(URI uri, Position position) {
        List<Statement> statements = this.completionVisitor.getStatements(uri);
        for (Statement statement : statements) {
            Range range = LSPUtils.toRange(statement);
            if (!Ranges.containsPosition((Range)range, (Position)position)) continue;
            return false;
        }
        return true;
    }
}

