/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.util.ISourceAttribute;
import org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class SourceFileAttributeReader {
    private SourceFileAttributeReader() {
    }

    public static String getSourceFileName(IClassFile classFile) {
        if (classFile == null) {
            return null;
        }
        try {
            return SourceFileAttributeReader.getSourceFileName(classFile.getBytes());
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Error reading class file bytes", e);
            return null;
        }
    }

    public static String getSourceFileName(byte[] classFileBytes) {
        char[] sourceFileName;
        block6: {
            ISourceAttribute sourceFileAttribute;
            block5: {
                if (classFileBytes == null || classFileBytes.length == 0) {
                    return null;
                }
                try {
                    ClassFileReader reader = new ClassFileReader(classFileBytes, 17);
                    sourceFileAttribute = reader.getSourceFileAttribute();
                    if (sourceFileAttribute != null) break block5;
                    return null;
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logException("Error parsing class file format", e);
                    return null;
                }
            }
            sourceFileName = sourceFileAttribute.getSourceFileName();
            if (sourceFileName != null && sourceFileName.length != 0) break block6;
            return null;
        }
        return new String(sourceFileName);
    }
}

