/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;

public class CoreJavaElementLinks {
    public static final String OPEN_LINK_SCHEME = "eclipse-open";
    public static final String JAVADOC_SCHEME = "eclipse-javadoc";
    public static final String JAVADOC_VIEW_SCHEME = "eclipse-javadoc-view";
    private static final char LINK_BRACKET_REPLACEMENT = '\u2603';
    private static final char LINK_SEPARATOR = '\u2602';

    private CoreJavaElementLinks() {
    }

    public static String createURI(String scheme, IJavaElement element) throws URISyntaxException {
        return CoreJavaElementLinks.createURI(scheme, element, null, null, null);
    }

    public static String createURI(String scheme, IJavaElement element, String refTypeName, String refMemberName, String[] refParameterTypes) throws URISyntaxException {
        return CoreJavaElementLinks.createURIAsUri(scheme, element, refTypeName, refMemberName, refParameterTypes).toASCIIString();
    }

    public static URI createURIAsUri(String scheme, IJavaElement element, String refTypeName, String refMemberName, String[] refParameterTypes) throws URISyntaxException {
        StringBuilder ssp = new StringBuilder(60);
        ssp.append('\u2602');
        ssp.append(element.getHandleIdentifier().replace('[', '\u2603'));
        if (refTypeName != null) {
            ssp.append('\u2602');
            ssp.append(refTypeName);
            if (refMemberName != null) {
                ssp.append('\u2602');
                ssp.append(refMemberName);
                if (refParameterTypes != null) {
                    ssp.append('\u2602');
                    int i = 0;
                    while (i < refParameterTypes.length) {
                        ssp.append(refParameterTypes[i]);
                        if (i != refParameterTypes.length - 1) {
                            ssp.append('\u2602');
                        }
                        ++i;
                    }
                }
            }
        }
        return new URI(scheme, ssp.toString(), null);
    }

    public static IJavaElement parseURI(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        String[] segments = ssp.split(String.valueOf('\u2602'), -1);
        String refModuleName = null;
        IJavaElement element = JavaCore.create((String)segments[1].replace('\u2603', '['));
        boolean canReferModuleName = CoreJavaElementLinks.canReferModuleName(element);
        if (segments.length > 2) {
            String refTypeName = segments[2];
            int index = refTypeName.indexOf(47);
            if (index != -1 && canReferModuleName) {
                refModuleName = refTypeName.substring(0, index);
                refTypeName = refTypeName.substring(index + 1);
            }
            if (refTypeName == null || refTypeName.isEmpty() && refModuleName != null && !refModuleName.isEmpty()) {
                return CoreJavaElementLinks.getModule(element, refModuleName);
            }
            if (refTypeName.indexOf(47) == -1 && refTypeName.indexOf(46) == -1) {
                try {
                    ITypeParameter resolvedTypeVariable = CoreJavaElementLinks.resolveTypeVariable(element, refTypeName);
                    if (resolvedTypeVariable != null) {
                        return resolvedTypeVariable;
                    }
                }
                catch (JavaModelException e) {
                    JavaManipulationPlugin.log(e);
                }
            }
            if (element instanceof IAnnotation) {
                element = element.getParent();
            }
            if (element instanceof IModuleDescription) {
                element = element.getAncestor(4);
            }
            if (element instanceof ILocalVariable) {
                element = ((ILocalVariable)element).getDeclaringMember();
            } else if (element instanceof ITypeParameter) {
                element = ((ITypeParameter)element).getDeclaringMember();
            }
            if (element instanceof IMember && !(element instanceof IType)) {
                element = ((IMember)element).getDeclaringType();
            }
            if (element instanceof IPackageFragment) {
                try {
                    IPackageFragment root = (IPackageFragment)element;
                    element = CoreJavaElementLinks.resolvePackageInfoType(root, refTypeName);
                    if (element == null) {
                        IJavaProject javaProject = root.getJavaProject();
                        return JavaModelUtil.findTypeContainer(javaProject, refTypeName);
                    }
                }
                catch (JavaModelException e) {
                    JavaManipulationPlugin.log(e);
                }
            }
            if (element instanceof IType) {
                try {
                    IPackageFragment pack;
                    IType type = (IType)element;
                    if (refTypeName.length() > 0 && (type = CoreJavaElementLinks.resolveType(type, refTypeName)) == null && (pack = JavaModelUtil.getPackageFragmentRoot(element).getPackageFragment(refTypeName)).exists()) {
                        return pack;
                    }
                    if (type != null) {
                        element = type;
                        if (segments.length > 3) {
                            String refMemberName = segments[3];
                            if (segments.length > 4) {
                                String[] paramSignatures = new String[segments[4].length() == 0 ? 0 : segments.length - 4];
                                int i = 0;
                                while (i < paramSignatures.length) {
                                    paramSignatures[i] = Signature.createTypeSignature((String)segments[i + 4], (boolean)false);
                                    ++i;
                                }
                                IMethod method = type.getMethod(refMemberName, paramSignatures);
                                IMethod[] methods = type.findMethods(method);
                                if (methods != null) {
                                    return methods[0];
                                }
                                IMethod[] iMethodArray = type.getMethods();
                                int n = iMethodArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IMethod method1 = iMethodArray[n2];
                                    method = method1;
                                    if (method.getElementName().equals(refMemberName) && method.getNumberOfParameters() == paramSignatures.length) {
                                        return method;
                                    }
                                    ++n2;
                                }
                                ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
                                method = JavaModelUtil.findMethodInHierarchy(hierarchy, type, refMemberName, paramSignatures, false);
                                if (method != null) {
                                    return method;
                                }
                            } else {
                                IField field = type.getField(refMemberName);
                                if (field.exists()) {
                                    return field;
                                }
                                IMethod[] iMethodArray = type.getMethods();
                                int n = iMethodArray.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    IMethod method = iMethodArray[n3];
                                    if (method.getElementName().equals(refMemberName)) {
                                        return method;
                                    }
                                    ++n3;
                                }
                            }
                        }
                    }
                    if (type == null && refModuleName == null && canReferModuleName && segments.length <= 3) {
                        return CoreJavaElementLinks.getModule(element, refTypeName);
                    }
                    return type;
                }
                catch (JavaModelException e) {
                    JavaManipulationPlugin.log(e);
                }
            }
        }
        return element;
    }

    private static IJavaElement getModule(IJavaElement element, String moduleName) {
        if (element == null || moduleName == null) {
            return null;
        }
        IJavaProject javaProject = element.getJavaProject();
        try {
            return javaProject.findModule(moduleName, null);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static boolean canReferModuleName(IJavaElement element) {
        IJavaProject javaProject;
        boolean canRefer = false;
        if (element != null && (javaProject = element.getJavaProject()) != null) {
            canRefer = JavaModelUtil.is15OrHigher(javaProject);
        }
        return canRefer;
    }

    private static IType resolvePackageInfoType(IPackageFragment pack, String refTypeName) throws JavaModelException {
        IJavaProject javaProject = pack.getJavaProject();
        return javaProject.findType(refTypeName, null);
    }

    private static ITypeParameter resolveTypeVariable(IJavaElement baseElement, String typeVariableName) throws JavaModelException {
        while (baseElement != null) {
            switch (baseElement.getElementType()) {
                case 9: {
                    ITypeParameter typeParameter;
                    ITypeParameter[] iTypeParameterArray = ((IMethod)baseElement).getTypeParameters();
                    int n = iTypeParameterArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        typeParameter = iTypeParameterArray[n2];
                        if (typeParameter.getElementName().equals(typeVariableName)) {
                            return typeParameter;
                        }
                        ++n2;
                    }
                    break;
                }
                case 7: {
                    ITypeParameter typeParameter;
                    ITypeParameter[] iTypeParameterArray = ((IType)baseElement).getTypeParameters();
                    int n = iTypeParameterArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        typeParameter = iTypeParameterArray[n2];
                        if (typeParameter.getElementName().equals(typeVariableName)) {
                            return typeParameter;
                        }
                        ++n2;
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: 
                case 12: 
                case 13: {
                    return null;
                }
            }
            baseElement = baseElement.getParent();
        }
        return null;
    }

    private static IType resolveType(IType baseType, String refTypeName) throws JavaModelException {
        if (refTypeName.length() == 0) {
            return baseType;
        }
        String[][] resolvedNames = baseType.resolveType(refTypeName);
        if (resolvedNames != null && resolvedNames.length > 0) {
            return baseType.getJavaProject().findType(resolvedNames[0][0], resolvedNames[0][1].replace('$', '.'), null);
        }
        if (baseType.isBinary()) {
            IType type = baseType.getJavaProject().findType(refTypeName, null);
            if (type == null) {
                type = baseType.getJavaProject().findType(baseType.getPackageFragment().getElementName() + "." + refTypeName, null);
            }
            return type;
        }
        return null;
    }

    public static String createLink(String uri, String label) {
        return "<a href='" + uri + "'>" + label + "</a>";
    }

    public static String createHeaderLink(String uri, String label) {
        return CoreJavaElementLinks.createHeaderLink(uri, label, "");
    }

    public static String createHeaderLink(String uri, String label, String title) {
        if (((String)title).length() > 0) {
            title = " title='" + (String)title + "'";
        }
        return "<a class='header' href='" + uri + "'" + (String)title + ">" + label + "</a>";
    }
}

