/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceDiagnosticsHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DiagnosticTag;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;

public abstract class BaseDiagnosticsHandler
implements IProblemRequestor {
    private final ICompilationUnit cu;
    protected final List<IProblem> problems = new ArrayList<IProblem>();
    private final String uri;
    private final JavaClientConnection connection;
    private boolean isDefaultProject;
    public static final int NON_PROJECT_JAVA_FILE = 16;
    public static final int NOT_ON_CLASSPATH = 32;
    public static final String DIAG_JAVAC_CODE = "javacCode";
    public static final String DIAG_ECJ_PROBLEM_ID = "ecjProblemId";
    public static final String DIAG_ARGUMENTS = "arguments";

    public BaseDiagnosticsHandler(JavaClientConnection conn, ICompilationUnit cu) {
        this.cu = cu;
        this.uri = JDTUtils.toURI(cu);
        this.connection = conn;
        this.isDefaultProject = JDTUtils.isDefaultProject(cu);
    }

    public void acceptProblem(IProblem problem) {
        if (!this.isSyntaxMode() || this.isSyntaxLikeError(problem)) {
            this.problems.add(problem);
        }
    }

    public abstract boolean isSyntaxMode();

    public boolean isSyntaxLikeError(IProblem problem) {
        if ((problem.getID() & 0x40000000) != 0) {
            return true;
        }
        if (!this.isDefaultProject && problem.getID() == 536871240) {
            return false;
        }
        if ((problem.getID() & 0x1000000) != 0 || (problem.getID() & 0x10000000) != 0) {
            return false;
        }
        switch (problem.getID()) {
            case 16777327: 
            case 33554502: 
            case 33554515: 
            case 0x4000064: 
            case 0x4000066: 
            case 67108979: 
            case 67108984: 
            case 67109135: 
            case 67109264: 
            case 67109498: 
            case 0x8000081: 
            case 0x8000082: 
            case 0x22000032: 
            case 603979903: {
                return false;
            }
        }
        String error = this.getError(problem);
        JavaLanguageServerPlugin.logInfo(problem.getMessage() + " is of type " + error);
        return true;
    }

    private String getError(IProblem problem) {
        try {
            Field[] fieldArray = IProblem.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (Integer.TYPE.equals(field.getType()) && Integer.valueOf(problem.getID()).equals(field.get(null))) {
                    return field.getName();
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    public void beginReporting() {
        JavaLanguageServerPlugin.logInfo("begin problem for " + this.uri.substring(this.uri.lastIndexOf(47)));
        this.problems.clear();
    }

    public void endReporting() {
        if (!BaseDiagnosticsHandler.matchesDiagnosticFilter(this.uri, JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getDiagnosticFilter())) {
            JavaLanguageServerPlugin.logInfo(this.problems.size() + " problems reported for " + this.uri.substring(this.uri.lastIndexOf(47)));
            boolean isDiagnosticTagSupported = JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isDiagnosticTagSupported();
            List<Diagnostic> diagnostics = BaseDiagnosticsHandler.toDiagnosticsArray((IOpenable)this.cu, this.problems, isDiagnosticTagSupported);
            this.collectNonJavaProblems(diagnostics, isDiagnosticTagSupported);
            PublishDiagnosticsParams $ = new PublishDiagnosticsParams(ResourceUtils.toClientUri(this.uri), diagnostics);
            this.connection.publishDiagnostics($);
        }
    }

    public static boolean matchesDiagnosticFilter(String uri, List<String> diagnosticFilters) {
        return JDTUtils.isExcludedFile(diagnosticFilters, uri);
    }

    public static Set<String> getDocumentsMatchingFilter(List<String> diagnosticFilter) {
        HashSet<String> uris = new HashSet<String>();
        IProject[] iProjectArray = ProjectUtils.getAllProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = project.findMarkers(null, true, 2);
                int n3 = markers.length;
                int n4 = 0;
                while (n4 < n3) {
                    String uriString;
                    IMarker marker = iMarkerArray[n4];
                    URI locationURI = marker.getResource().getLocationURI();
                    if (locationURI != null && !new File(locationURI).isDirectory() && BaseDiagnosticsHandler.matchesDiagnosticFilter(uriString = locationURI.toString(), diagnosticFilter)) {
                        uris.add(uriString);
                    }
                    ++n4;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return uris;
    }

    private void collectNonJavaProblems(List<Diagnostic> diagnostics, boolean isDiagnosticTagSupported) {
        if (this.cu != null) {
            IMarker[] markers;
            try {
                IResource resource = this.cu.getUnderlyingResource();
                if (resource == null) {
                    return;
                }
                markers = resource.findMarkers(null, true, 1);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
                return;
            }
            List<IMarker> list = Arrays.stream(markers).filter(marker -> {
                try {
                    return !marker.isSubtypeOf("org.eclipse.jdt.core.problem") && !marker.isSubtypeOf("org.eclipse.jdt.core.task") && JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().excludedMarkerTypes().stream().noneMatch(excluded -> {
                        try {
                            return marker.isSubtypeOf(excluded);
                        }
                        catch (CoreException e) {
                            JavaLanguageServerPlugin.log(e);
                            return false;
                        }
                    });
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.log(e);
                    return false;
                }
            }).toList();
            if (!list.isEmpty()) {
                IDocument document;
                try {
                    document = JsonRpcHelpers.toDocument(this.cu.getBuffer());
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    return;
                }
                List<Diagnostic> diags = WorkspaceDiagnosticsHandler.toDiagnosticsArray(document, list.toArray(new IMarker[0]), isDiagnosticTagSupported);
                diagnostics.addAll(diags);
            }
        }
    }

    public boolean isActive() {
        return true;
    }

    @Deprecated
    public static List<Diagnostic> toDiagnosticsArray(IOpenable openable, List<IProblem> problems) {
        return BaseDiagnosticsHandler.toDiagnosticsArray(openable, problems, false);
    }

    public static List<Diagnostic> toDiagnosticsArray(IOpenable openable, List<IProblem> problems, boolean isDiagnosticTagSupported) {
        ArrayList<Diagnostic> array = new ArrayList<Diagnostic>(problems.size());
        for (IProblem problem : problems) {
            Diagnostic diag = new Diagnostic();
            diag.setSource("Java");
            diag.setMessage(problem.getMessage());
            diag.setCode(Integer.toString(problem.getID()));
            diag.setSeverity(BaseDiagnosticsHandler.convertSeverity(problem));
            diag.setRange(BaseDiagnosticsHandler.convertRange(openable, problem));
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (problem.getID() == 0x22000032 || problem.getID() == 0x1000002 || problem.getID() == 33554513 || problem.getID() == 67109917 || problem.getID() == 67109916) {
                data.put(DIAG_ARGUMENTS, problem.getArguments());
            }
            if (isDiagnosticTagSupported) {
                diag.setTags(BaseDiagnosticsHandler.getDiagnosticTag(problem.getID()));
            }
            if (problem instanceof CategorizedProblem) {
                CategorizedProblem javaProblem = (CategorizedProblem)problem;
                String[] extraAttributeNames = javaProblem.getExtraMarkerAttributeNames();
                Object[] extraAttributeValues = javaProblem.getExtraMarkerAttributeValues();
                if (extraAttributeNames != null && extraAttributeValues != null && extraAttributeNames.length == extraAttributeValues.length) {
                    int i = 0;
                    while (i < extraAttributeNames.length) {
                        if (DIAG_JAVAC_CODE.equals(extraAttributeNames[i])) {
                            diag.setCode(String.valueOf(extraAttributeValues[i]));
                            data.put(DIAG_ECJ_PROBLEM_ID, Integer.toString(problem.getID()));
                            break;
                        }
                        ++i;
                    }
                }
            }
            if (!data.isEmpty()) {
                diag.setData(data);
            }
            array.add(diag);
        }
        return array;
    }

    public static List<DiagnosticTag> getDiagnosticTag(int id) {
        switch (id) {
            case -1610612245: 
            case -1610612241: 
            case -1610612237: 
            case -1610612230: 
            case 8390033: 
            case 8390034: 
            case 8390035: 
            case 8390036: 
            case 8390037: 
            case 8390038: 
            case 8390039: 
            case 8390040: 
            case 0x1000005: 
            case 16778616: 
            case 16778621: 
            case 16778626: 
            case 33554505: 
            case 33555835: 
            case 33555840: 
            case 33555845: 
            case 67108967: 
            case 67109276: 
            case 67110265: 
            case 67110266: 
            case 67110268: 
            case 67110270: 
            case 67110271: 
            case 67110273: 
            case 67110275: 
            case 67110276: 
            case 67110278: 
            case 0x8000085: {
                return Arrays.asList(DiagnosticTag.Deprecated);
            }
            case 16777877: 
            case 67109443: 
            case 67109524: 
            case 268435844: 
            case 536870973: 
            case 536870974: 
            case 0x20000055: 
            case 536871060: 
            case 536871097: 
            case 536871098: 
            case 536871101: 
            case 536871111: 
            case 536871177: 
            case 536871547: 
            case 553648135: 
            case 553648309: 
            case 553648311: 
            case 570425421: 
            case 603979894: 
            case 603979910: {
                return Arrays.asList(DiagnosticTag.Unnecessary);
            }
        }
        return null;
    }

    private static DiagnosticSeverity convertSeverity(IProblem problem) {
        if (problem.isError()) {
            return DiagnosticSeverity.Error;
        }
        if (problem.isWarning() && problem.getID() != 536871362) {
            return DiagnosticSeverity.Warning;
        }
        return DiagnosticSeverity.Information;
    }

    private static Range convertRange(IOpenable openable, IProblem problem) {
        try {
            ICompilationUnit cu;
            int start;
            if (problem.getID() == 0x1000002 && openable instanceof ICompilationUnit && (start = BaseDiagnosticsHandler.getSourceStart(cu = (ICompilationUnit)openable, problem)) > -1) {
                return JDTUtils.toRange(openable, start, problem.getSourceEnd() - start + 1);
            }
            return JDTUtils.toRange(openable, problem.getSourceStart(), problem.getSourceEnd() - problem.getSourceStart() + 1);
        }
        catch (CoreException e) {
            Position start = new Position();
            Position end = new Position();
            start.setLine(problem.getSourceLineNumber() - 1);
            end.setLine(problem.getSourceLineNumber() - 1);
            if (problem instanceof DefaultProblem) {
                DefaultProblem dProblem = (DefaultProblem)problem;
                start.setCharacter(dProblem.getSourceColumnNumber() - 1);
                int offset = 0;
                if (dProblem.getSourceStart() != -1 && dProblem.getSourceEnd() != -1) {
                    offset = dProblem.getSourceEnd() - dProblem.getSourceStart() + 1;
                }
                end.setCharacter(dProblem.getSourceColumnNumber() - 1 + offset);
            }
            return new Range(start, end);
        }
    }

    protected static int getSourceStart(ICompilationUnit cu, IProblem problem) {
        int start;
        IBuffer buffer;
        try {
            buffer = cu.getBuffer();
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return -1;
        }
        if (buffer != null && (start = problem.getSourceStart()) > 0) {
            char ch = buffer.getChar(--start);
            while (Character.isWhitespace(ch)) {
                ch = buffer.getChar(--start);
            }
            if (ch == '@') {
                return start;
            }
        }
        return -1;
    }

    public void clearDiagnostics() {
        JavaLanguageServerPlugin.logInfo("Clearing problems for " + this.uri.substring(this.uri.lastIndexOf(47)));
        this.problems.clear();
        PublishDiagnosticsParams $ = new PublishDiagnosticsParams(ResourceUtils.toClientUri(this.uri), Collections.emptyList());
        this.connection.publishDiagnostics($);
    }
}

