/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.corba;

import com.sun.jndi.cosnaming.CNCtx;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.ConfigurationException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class CorbaUtils {
    private static Method toStubMethod = null;
    private static Method connectMethod = null;
    private static Class<?> corbaStubClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object remoteToCorba(Remote remote, ORB oRB) throws ClassNotFoundException, ConfigurationException {
        java.lang.Object object = CorbaUtils.class;
        synchronized (CorbaUtils.class) {
            if (toStubMethod == null) {
                CorbaUtils.initMethodHandles();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                object = toStubMethod.invoke(null, remote);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                ConfigurationException configurationException = new ConfigurationException("Problem with PortableRemoteObject.toStub(); object not exported or stub not found");
                configurationException.setRootCause(throwable);
                throw configurationException;
            }
            catch (IllegalAccessException illegalAccessException) {
                ConfigurationException configurationException = new ConfigurationException("Cannot invoke javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
                configurationException.setRootCause(illegalAccessException);
                throw configurationException;
            }
            if (!corbaStubClass.isInstance(object)) {
                return null;
            }
            try {
                connectMethod.invoke(object, oRB);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (!(throwable instanceof RemoteException)) {
                    ConfigurationException configurationException = new ConfigurationException("Problem invoking javax.rmi.CORBA.Stub.connect()");
                    configurationException.setRootCause(throwable);
                    throw configurationException;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                ConfigurationException configurationException = new ConfigurationException("Cannot invoke javax.rmi.CORBA.Stub.connect()");
                configurationException.setRootCause(illegalAccessException);
                throw configurationException;
            }
            return (Object)object;
        }
    }

    public static ORB getOrb(String string, int n, Hashtable<?, ?> hashtable) {
        Enumeration<?> enumeration;
        Properties properties;
        if (hashtable != null) {
            if (hashtable instanceof Properties) {
                properties = (Properties)hashtable.clone();
            } else {
                properties = new Properties();
                enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    java.lang.Object obj = hashtable.get(string2);
                    if (!(obj instanceof String)) continue;
                    properties.put(string2, obj);
                }
            }
        } else {
            properties = new Properties();
        }
        if (string != null) {
            properties.put("org.omg.CORBA.ORBInitialHost", string);
        }
        if (n >= 0) {
            properties.put("org.omg.CORBA.ORBInitialPort", "" + n);
        }
        if (hashtable != null && (enumeration = hashtable.get("java.naming.applet")) != null) {
            return CorbaUtils.initAppletORB(enumeration, properties);
        }
        return ORB.init(new String[0], properties);
    }

    public static boolean isObjectFactoryTrusted(java.lang.Object object) throws NamingException {
        Reference reference = null;
        if (object instanceof Reference) {
            reference = (Reference)object;
        } else if (object instanceof Referenceable) {
            reference = ((Referenceable)object).getReference();
        }
        if (reference != null && reference.getFactoryClassLocation() != null && !CNCtx.trustURLCodebase) {
            throw new ConfigurationException("The object factory is untrusted. Set the system property 'com.sun.jndi.cosnaming.object.trustURLCodebase' to 'true'.");
        }
        return true;
    }

    private static ORB initAppletORB(java.lang.Object object, Properties properties) {
        try {
            Class<?> clazz = Class.forName("java.applet.Applet", true, null);
            if (!clazz.isInstance(object)) {
                throw new ClassCastException(object.getClass().getName());
            }
            Method method = ORB.class.getMethod("init", clazz, Properties.class);
            return (ORB)method.invoke(null, object, properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassCastException(object.getClass().getName());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((java.lang.Object)noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((java.lang.Object)invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((java.lang.Object)illegalAccessException);
        }
    }

    private static void initMethodHandles() throws ClassNotFoundException {
        corbaStubClass = Class.forName("javax.rmi.CORBA.Stub");
        try {
            connectMethod = corbaStubClass.getMethod("connect", ORB.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("No method definition for javax.rmi.CORBA.Stub.connect(org.omg.CORBA.ORB)");
        }
        Class<?> clazz = Class.forName("javax.rmi.PortableRemoteObject");
        try {
            toStubMethod = clazz.getMethod("toStub", Remote.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("No method definition for javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
        }
    }
}

