/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.util;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.search.util.CComboContentAdapter;
import org.eclipse.m2e.core.ui.internal.search.util.ControlDecoration;
import org.eclipse.m2e.core.ui.internal.search.util.Packaging;
import org.eclipse.m2e.core.ui.internal.search.util.SearchEngine;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposalUtil {
    private static final Logger log = LoggerFactory.getLogger(ProposalUtil.class);

    public static void addCompletionProposal(Control control, Searcher searcher) {
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        ControlDecoration decoration = new ControlDecoration(control, 16512);
        decoration.setShowOnlyOnFocus(true);
        decoration.setDescriptionText(fieldDecoration.getDescription());
        decoration.setImage(fieldDecoration.getImage());
        IContentProposalProvider proposalProvider = (contents, position) -> {
            String start = contents.length() > position ? contents.substring(0, position) : contents;
            ArrayList<TextProposal> proposals = new ArrayList<TextProposal>();
            try {
                for (String text : searcher.search()) {
                    if (!text.startsWith(start)) continue;
                    proposals.add(new TextProposal(text));
                }
            }
            catch (CoreException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return proposals.toArray(new IContentProposal[proposals.size()]);
        };
        Object contentAdapter = control instanceof Text ? new TextContentAdapter() : new CComboContentAdapter();
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter(control, (IControlContentAdapter)contentAdapter, proposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", null);
        adapter.setProposalAcceptanceStyle(2);
        adapter.setPopupSize(new Point(250, 120));
        adapter.setPopupSize(new Point(250, 120));
    }

    public static void addClassifierProposal(final IProject project, final Text groupIdText, final Text artifactIdText, final Text versionText, Text classifierText, final Packaging packaging) {
        ProposalUtil.addCompletionProposal((Control)classifierText, new Searcher(){

            @Override
            public Collection<String> search() {
                return ProposalUtil.getSearchEngine(project).findClassifiers(groupIdText.getText(), artifactIdText.getText(), versionText.getText(), "", packaging);
            }
        });
    }

    public static void addVersionProposal(final IProject project, final MavenProject mp, final Text groupIdText, final Text artifactIdText, Text versionText, final Packaging packaging) {
        ProposalUtil.addCompletionProposal((Control)versionText, new Searcher(){

            @Override
            public Collection<String> search() {
                ArrayList<String> toRet = new ArrayList<String>();
                toRet.addAll(ProposalUtil.getSearchEngine(project).findVersions(groupIdText.getText(), artifactIdText.getText(), "", packaging));
                if (mp != null) {
                    Properties props = mp.getProperties();
                    ArrayList<CallSite> list = new ArrayList<CallSite>();
                    if (props != null) {
                        for (Object prop : props.keySet()) {
                            String propString = prop.toString();
                            if (!propString.endsWith("Version") && !propString.endsWith(".version")) continue;
                            list.add((CallSite)((Object)("${" + propString + "}")));
                        }
                    }
                    Collections.sort(list);
                    toRet.addAll(list);
                }
                return toRet;
            }
        });
    }

    public static void addArtifactIdProposal(final IProject project, final Text groupIdText, Text artifactIdText, final Packaging packaging) {
        ProposalUtil.addCompletionProposal((Control)artifactIdText, new Searcher(){

            @Override
            public Collection<String> search() {
                return ProposalUtil.getSearchEngine(project).findArtifactIds(groupIdText.getText(), "", packaging, null);
            }
        });
    }

    public static void addGroupIdProposal(final IProject project, final Text groupIdText, final Packaging packaging) {
        ProposalUtil.addCompletionProposal((Control)groupIdText, new Searcher(){

            @Override
            public Collection<String> search() {
                return ProposalUtil.getSearchEngine(project).findGroupIds(groupIdText.getText(), packaging, null);
            }
        });
    }

    public static SearchEngine getSearchEngine(IProject project) {
        return M2EUIPluginActivator.getDefault().getSearchEngine(project);
    }

    public static abstract class Searcher {
        public abstract Collection<String> search() throws CoreException;
    }

    public static final class TextProposal
    implements IContentProposal {
        private final String text;

        public TextProposal(String text) {
            this.text = text;
        }

        public int getCursorPosition() {
            return this.text.length();
        }

        public String getContent() {
            return this.text;
        }

        public String getLabel() {
            return this.text;
        }

        public String getDescription() {
            return null;
        }
    }
}

