/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.identity.core.gravatar;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.identity.core.Account;
import org.eclipse.mylyn.commons.identity.core.IIdentity;
import org.eclipse.mylyn.commons.identity.core.spi.IdentityConnector;
import org.eclipse.mylyn.commons.identity.core.spi.Profile;
import org.eclipse.mylyn.commons.identity.core.spi.ProfileImage;
import org.eclipse.mylyn.internal.commons.identity.core.gravatar.Gravatar;
import org.eclipse.mylyn.internal.commons.identity.core.gravatar.GravatarStore;
import org.eclipse.mylyn.internal.commons.identity.core.gravatar.GravatarUtils;

public class GravatarConnector
extends IdentityConnector {
    public static final String KIND = "org.eclipse.mylyn.commons.identity.gravatar";
    private final GravatarStore store;
    private final int DEFAULT_SIZE = 80;
    private final Map<String, Long> noImageHashByTimeStamp = new ConcurrentHashMap<String, Long>();

    public GravatarConnector() {
        this.store = new GravatarStore();
    }

    @Override
    public ProfileImage getImage(IIdentity identity, int preferredWidth, int preferredHeight, IProgressMonitor monitor) throws CoreException {
        Gravatar gravatar;
        String id = this.getHash(identity);
        if (id == null || this.noImageHashByTimeStamp.containsKey(id)) {
            return null;
        }
        identity.addAccount(Account.id(id).kind(KIND));
        int size = this.getSize(preferredWidth);
        try {
            gravatar = this.store.loadGravatarByHash(id, size, null);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, KIND, e.getMessage(), (Throwable)e));
        }
        if (gravatar != null) {
            return new ProfileImage(gravatar.getBytes(), size, size, "jpg");
        }
        this.noImageHashByTimeStamp.put(id, System.currentTimeMillis());
        return null;
    }

    private int getSize(int preferredSize) {
        if (preferredSize < 1 && preferredSize > 512) {
            return 80;
        }
        return preferredSize;
    }

    @Override
    public boolean supportsImageSize(int preferredWidth, int preferredHeight) {
        return preferredWidth >= 1 && preferredWidth <= 512 && preferredHeight >= 1 && preferredHeight <= 512 && preferredWidth == preferredHeight;
    }

    @Override
    public void updateProfile(Profile profile, IProgressMonitor monitor) throws CoreException {
    }

    private String getHash(IIdentity identity) {
        Account account = identity.getAccountByKind(KIND);
        if (account != null && GravatarUtils.isValidHash(account.getId())) {
            return account.getId();
        }
        String[] stringArray = identity.getAliases();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            if (GravatarUtils.isValidEmail(alias)) {
                return GravatarUtils.getHash(alias);
            }
            ++n2;
        }
        return null;
    }
}

