/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.archive.IArchiveExportParticipant;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.osgi.framework.Bundle;

public final class ArchiveExportParticipantsExtensionPoint {
    public static final String EXTENSION_POINT_ID = "archiveExportParticipants";
    private static final String EL_PARTICIPANT = "participant";
    private static final String EL_RUNTIME_COMPONENT = "runtime-component";
    private static final String EL_FACTORY = "factory";
    private static final String EL_ENABLEMENT = "enablement";
    private static final String ATTR_ID = "id";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_CLASS = "class";
    private static List<ParticipantInfo> extensions = null;

    public static List<ParticipantInfo> getExtensions(IProject project, IRuntime runtime) {
        ArchiveExportParticipantsExtensionPoint.readExtensions();
        ArrayList<ParticipantInfo> result = new ArrayList<ParticipantInfo>();
        for (ParticipantInfo partInfo : extensions) {
            boolean match = false;
            for (IRuntimeComponent rc : runtime.getRuntimeComponents()) {
                IRuntimeComponentType rct = rc.getRuntimeComponentType();
                if (rct != partInfo.runtimeComponentType) continue;
                IRuntimeComponentVersion rcv = rc.getRuntimeComponentVersion();
                try {
                    if (!rct.getVersions(partInfo.runtimeComponentVersionExpr).contains(rcv)) continue;
                    match = true;
                    break;
                }
                catch (CoreException e) {
                    J2EEPlugin.logError(-1, e.getMessage(), e);
                }
            }
            if (match && partInfo.enablementCondition != null) {
                EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
                evalContext.setAllowPluginActivation(true);
                try {
                    EvaluationResult evalResult = partInfo.enablementCondition.evaluate((IEvaluationContext)evalContext);
                    if (evalResult != EvaluationResult.TRUE) {
                        match = false;
                    }
                }
                catch (CoreException e) {
                    J2EEPlugin.logError(-1, e.getMessage(), e);
                }
            }
            if (!match) continue;
            result.add(partInfo);
        }
        return Collections.unmodifiableList(result);
    }

    private static synchronized void readExtensions() {
        if (extensions != null) {
            return;
        }
        extensions = new ArrayList<ParticipantInfo>();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.jst.j2ee", EXTENSION_POINT_ID))) {
            if (!element.getName().equals(EL_PARTICIPANT)) continue;
            try {
                ArchiveExportParticipantsExtensionPoint.readExtension(element);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    private static void readExtension(IConfigurationElement config) throws PluginUtil.InvalidExtensionException {
        ParticipantInfo info = new ParticipantInfo();
        info.pluginId = config.getContributor().getName();
        info.id = String.valueOf(info.pluginId) + "." + PluginUtil.findRequiredAttribute(config, ATTR_ID);
        IConfigurationElement elFactory = PluginUtil.findRequiredElement(config, EL_FACTORY);
        info.className = PluginUtil.findRequiredAttribute(elFactory, ATTR_CLASS);
        IConfigurationElement elRuntimeComponent = PluginUtil.findRequiredElement(config, EL_RUNTIME_COMPONENT);
        String rcTypeString = PluginUtil.findRequiredAttribute(elRuntimeComponent, ATTR_TYPE);
        if (!RuntimeManager.isRuntimeComponentTypeDefined((String)rcTypeString)) {
            throw new PluginUtil.InvalidExtensionException();
        }
        info.runtimeComponentType = RuntimeManager.getRuntimeComponentType((String)rcTypeString);
        info.runtimeComponentVersionExpr = elRuntimeComponent.getAttribute(ATTR_VERSION);
        IConfigurationElement elEnablement = PluginUtil.findOptionalElement(config, EL_ENABLEMENT);
        try {
            info.enablementCondition = ExpressionConverter.getDefault().perform(elEnablement);
        }
        catch (CoreException e) {
            J2EEPlugin.logError(-1, e.getMessage(), e);
            throw new PluginUtil.InvalidExtensionException();
        }
        extensions.add(info);
    }

    public static class ParticipantInfo {
        private String id;
        private String pluginId = null;
        private String className = null;
        private IRuntimeComponentType runtimeComponentType = null;
        private String runtimeComponentVersionExpr = null;
        private Expression enablementCondition = null;

        public String getId() {
            return this.id;
        }

        public IArchiveExportParticipant loadParticipant() {
            try {
                return PluginUtil.instantiate(this.pluginId, this.className, IArchiveExportParticipant.class);
            }
            catch (CoreException e) {
                J2EEPlugin.log(e.getStatus());
                return null;
            }
        }
    }

    public static final class PluginUtil {
        private PluginUtil() {
        }

        public static Collection<IExtension> findExtensions(String pluginId, String extensionPointId) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPointId);
            if (point == null) {
                throw new RuntimeException();
            }
            ArrayList<IExtension> extensions = new ArrayList<IExtension>();
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                extensions.add(extension);
                ++n2;
            }
            return extensions;
        }

        public static Collection<IConfigurationElement> getTopLevelElements(Collection<IExtension> extensions) {
            ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
            for (IExtension extension : extensions) {
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    elements.add(element);
                    ++n2;
                }
            }
            return elements;
        }

        public static void reportMissingAttribute(IConfigurationElement el, String attribute) {
            String pluginId = el.getContributor().getName();
            String extPointId = el.getDeclaringExtension().getExtensionPointUniqueIdentifier();
            String msg = Resources.bind(Resources.missingAttribute, pluginId, extPointId, el.getName(), attribute);
            J2EEPlugin.log(J2EEPlugin.createErrorStatus(-1, msg, null));
        }

        public static void reportMissingElement(IConfigurationElement el, String element) {
            String pluginId = el.getContributor().getName();
            String extPointId = el.getDeclaringExtension().getExtensionPointUniqueIdentifier();
            String msg = Resources.bind(Resources.missingElement, pluginId, extPointId, el.getName(), element);
            J2EEPlugin.log(J2EEPlugin.createErrorStatus(-1, msg, null));
        }

        public static String findRequiredAttribute(IConfigurationElement el, String attribute) throws InvalidExtensionException {
            String val = el.getAttribute(attribute);
            if (val == null) {
                PluginUtil.reportMissingAttribute(el, attribute);
                throw new InvalidExtensionException();
            }
            return val;
        }

        public static IConfigurationElement findRequiredElement(IConfigurationElement el, String childElement) throws InvalidExtensionException {
            IConfigurationElement[] children = el.getChildren(childElement);
            if (children.length == 0) {
                PluginUtil.reportMissingElement(el, childElement);
                throw new InvalidExtensionException();
            }
            return children[0];
        }

        public static IConfigurationElement findOptionalElement(IConfigurationElement el, String childElement) {
            IConfigurationElement[] children = el.getChildren(childElement);
            if (children.length == 0) {
                return null;
            }
            return children[0];
        }

        public static String getElementValue(IConfigurationElement el, String defaultValue) {
            String text;
            if (el != null && (text = el.getValue()) != null && (text = text.trim()).length() > 0) {
                return text;
            }
            return defaultValue;
        }

        public static <T> T instantiate(String pluginId, String clname, Class<T> interfc) throws CoreException {
            Object obj;
            Bundle bundle = Platform.getBundle((String)pluginId);
            try {
                Class cl = bundle.loadClass(clname);
                obj = cl.newInstance();
            }
            catch (Exception e) {
                String msg = NLS.bind((String)Resources.failedToCreate, (Object)clname);
                throw new CoreException(J2EEPlugin.createErrorStatus(-1, msg, e));
            }
            if (!interfc.isAssignableFrom(obj.getClass())) {
                String msg = NLS.bind((String)Resources.doesNotImplement, (Object)clname, (Object)interfc.getClass().getName());
                throw new CoreException(J2EEPlugin.createErrorStatus(-1, msg, null));
            }
            return obj;
        }

        public static final class InvalidExtensionException
        extends Exception {
            private static final long serialVersionUID = 1L;
        }

        private static final class Resources
        extends NLS {
            public static String missingAttribute;
            public static String missingElement;
            public static String failedToCreate;
            public static String doesNotImplement;

            static {
                Resources.initializeMessages((String)PluginUtil.class.getName(), Resources.class);
            }

            private Resources() {
            }

            public static String bind(String message, String arg1, String arg2, String arg3, String arg4) {
                return Resources.bind((String)message, (Object[])new Object[]{arg1, arg2, arg3, arg4});
            }
        }
    }
}

