"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLine = getLine;
exports.getDocUri = getDocUri;
const lsp = require("vscode-languageserver-protocol");
const vscode_uri_1 = require("vscode-uri");
const number_1 = require("../util/number");
function getLine(doc, line) {
    return doc.getText(lsp.Range.create(line, 0, line, number_1.maxLspUInt)).replace(/\r?\n$/, '');
}
function getDocUri(doc) {
    return doc.$uri ?? vscode_uri_1.URI.parse(doc.uri);
}
//# sourceMappingURL=textDocument.js.map