/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.rename;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.internal.core.manipulation.ScriptManipulationPlugin;
import org.eclipse.dltk.internal.core.refactoring.descriptors.RenameModelElementDescriptor;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringArguments;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptor;
import org.eclipse.dltk.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.dltk.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.dltk.internal.corext.refactoring.participants.ScriptProcessors;
import org.eclipse.dltk.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.dltk.internal.corext.refactoring.rename.ScriptRenameProcessor;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.dltk.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public abstract class RenameModelElementProcessor
extends ScriptRenameProcessor
implements IReferenceUpdating {
    protected IModelElement fModelElement;
    protected ISourceModule fCu;
    protected boolean fUpdateReferences;
    protected String fCurrentName;
    private TextChangeManager fChangeManager;
    private final IDLTKLanguageToolkit fToolkit;

    public RenameModelElementProcessor(IModelElement localVariable, IDLTKLanguageToolkit toolkit) {
        this.fToolkit = toolkit;
        this.fModelElement = localVariable;
        this.fCu = (ISourceModule)this.fModelElement.getAncestor(5);
        this.fChangeManager = new TextChangeManager(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String references;
        if (!(arguments instanceof ScriptRefactoringArguments)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        ScriptRefactoringArguments extended = (ScriptRefactoringArguments)arguments;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IModelElement element = ScriptRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
        if (element == null || !element.exists()) return ScriptableRefactoring.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.dltk.core.manipulation.rename.local.variable");
        if (element.getElementType() == 5) {
            this.fCu = (ISourceModule)element;
        } else {
            if (element.getElementType() != 13) return ScriptableRefactoring.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.dltk.core.manipulation.rename.local.variable");
            this.fModelElement = element;
            this.fCu = (ISourceModule)this.fModelElement.getAncestor(5);
            if (this.fCu == null) {
                return ScriptableRefactoring.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.dltk.core.manipulation.rename.local.variable");
            }
        }
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        if (this.fCu != null && this.fModelElement == null) {
            String selection = extended.getAttribute("selection");
            if (selection == null) return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            int offset = -1;
            int length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, selection, "selection"));
            try {
                IModelElement[] elements = this.fCu.codeSelect(offset, length);
                if (elements != null) {
                    int index = 0;
                    while (index < elements.length) {
                        IModelElement element2 = elements[index];
                        if (element2 instanceof ILocalVariable) {
                            this.fModelElement = element2;
                        }
                        ++index;
                    }
                }
                if (this.fModelElement == null) {
                    return ScriptableRefactoring.createInputFatalStatus(null, this.getProcessorName(), "org.eclipse.dltk.core.manipulation.rename.local.variable");
                }
            }
            catch (ModelException exception) {
                ScriptManipulationPlugin.log(exception);
            }
        }
        if ((references = extended.getAttribute("references")) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        return new RefactoringStatus();
    }

    @Override
    public String getCurrentElementName() {
        return this.fCurrentName;
    }

    @Override
    public boolean canEnableUpdateReferences() {
        return true;
    }

    @Override
    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    @Override
    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    @Override
    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        if (this.fModelElement instanceof ILocalVariable) {
            result.rename((ILocalVariable)this.fModelElement, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        } else if (this.fModelElement instanceof IField) {
            result.rename((IField)this.fModelElement, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        }
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllSourceModules());
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus result = this.checkNewElementName(this.getNewElementName());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.createEdits(pm);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private void createEdits(IProgressMonitor pm) throws CoreException {
        this.fChangeManager.clear();
        IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)this.fToolkit);
        SearchEngine engine = new SearchEngine();
        if (this.fUpdateReferences) {
            SearchPattern pattern = SearchPattern.createPattern((IModelElement)this.fModelElement, (int)1, (int)24, (IDLTKLanguageToolkit)this.fToolkit);
            SubProgressMonitor monitor = new SubProgressMonitor(pm, 1000);
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (!(match.getElement() instanceof IModelElement)) {
                        return;
                    }
                    IModelElement elem = (IModelElement)match.getElement();
                    ISourceModule cu = (ISourceModule)elem.getAncestor(5);
                    if (cu != null) {
                        ReplaceEdit edit = RenameModelElementProcessor.this.createReplaceEdit(match);
                        RenameModelElementProcessor.addTextEdit(RenameModelElementProcessor.this.fChangeManager.get(cu), RenameModelElementProcessor.this.getProcessorName(), (TextEdit)edit);
                    }
                }
            }, (IProgressMonitor)monitor);
        }
        ISourceRange decl = null;
        if (this.fModelElement instanceof ILocalVariable) {
            decl = ((ILocalVariable)this.fModelElement).getNameRange();
        } else if (this.fModelElement instanceof IMember) {
            decl = ((IMember)this.fModelElement).getNameRange();
        }
        if (decl != null) {
            ReplaceEdit edit = new ReplaceEdit(decl.getOffset(), this.fCurrentName.length(), this.getNewElementName());
            RenameModelElementProcessor.addTextEdit(this.fChangeManager.get(this.fCu), this.getProcessorName(), (TextEdit)edit);
        }
    }

    protected ReplaceEdit createReplaceEdit(SearchMatch match) {
        return new ReplaceEdit(match.getOffset(), this.fCurrentName.length(), this.getNewElementName());
    }

    private static void addTextEdit(TextChange change, String name, TextEdit edit) throws MalformedTreeException {
        TextEdit root = change.getEdit();
        if (root == null) {
            root = new MultiTextEdit();
            change.setEdit(root);
        }
        root.addChild(edit);
        change.addTextEditGroup(new TextEditGroup(name, edit));
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return ScriptProcessors.computeAffectedNatures((IModelElement)this.fCu);
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fModelElement};
    }

    @Override
    public String getNewElement() {
        return this.getNewElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.fCurrentName = this.fModelElement.getElementName();
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.RenameFieldRefactoring_checking, 1);
            TextChange[] changes = this.fChangeManager.getAllChanges();
            RenameModelElementDescriptor descriptor = this.createRefactoringDescriptor();
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, this.getProcessorName(), (Change[])changes);
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    private RenameModelElementDescriptor createRefactoringDescriptor() {
        String project = null;
        IScriptProject scriptProject = this.fCu.getScriptProject();
        if (scriptProject != null) {
            project = scriptProject.getElementName();
        }
        RenameModelElementDescriptor descriptor = new RenameModelElementDescriptor("org.eclipse.dltk.core.manipulation.rename.local.variable");
        descriptor.setProject(project);
        descriptor.setFlags(0);
        descriptor.setModelElement(this.fModelElement);
        descriptor.setNewName(this.getNewElementName());
        descriptor.setUpdateReferences(this.fUpdateReferences);
        return descriptor;
    }

    @Override
    public boolean needsSavedEditors() {
        return false;
    }
}

