/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionScope;
import org.eclipse.php.internal.core.codeassist.contexts.DeclarationContext;
import org.eclipse.php.internal.core.util.text.TextSequence;

public abstract class FunctionDeclarationContext
extends DeclarationContext {
    private int functionEnd = -1;

    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        ICompletionScope currentScope = this.getCompanion().getScope();
        if (currentScope.getType() != ICompletionScope.Type.FUNCTION && (currentScope.getType() != ICompletionScope.Type.HEAD || currentScope.getParent().getType() != ICompletionScope.Type.FUNCTION)) {
            return false;
        }
        TextSequence statementText = this.getStatementText();
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (statementText.length() > pos) {
            char ch = statementText.charAt(pos);
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
            } else if (ch == '(' || Character.isWhitespace(ch)) {
                if (sb.toString().equalsIgnoreCase("function")) {
                    this.functionEnd = pos;
                    return true;
                }
                if (PHPVersion.PHP7_3.isLessThan(this.getCompanion().getPHPVersion()) && sb.toString().equals("fn")) {
                    this.functionEnd = pos;
                    return true;
                }
                if (ch == '(') {
                    return false;
                }
                sb.setLength(0);
            }
            ++pos;
        }
        return false;
    }

    public int getFunctionEnd() {
        return this.functionEnd;
    }
}

