/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentassist;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.css.core.internal.Logger;
import org.eclipse.wst.css.core.internal.provisional.adapters.ICSSModelAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalArranger;
import org.eclipse.wst.html.core.internal.htmlcss.StyleAdapterFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistUtilities;

public class CSSCompletionProposalComputer
implements ICompletionProposalComputer {
    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        IStructuredModel cssModel;
        ITextViewer viewer = context.getViewer();
        int documentPosition = context.getInvocationOffset();
        IndexedRegion indexedNode = ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)documentPosition);
        IDOMNode xNode = null;
        IDOMNode parent = null;
        CSSProposalArranger arranger = null;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (indexedNode instanceof IDOMNode) {
            xNode = (IDOMNode)indexedNode;
            parent = (IDOMNode)xNode.getParentNode();
        }
        if (xNode != null && xNode.getNodeName().equalsIgnoreCase("STYLE")) {
            cssModel = CSSCompletionProposalComputer.getCSSModel(xNode);
            if (cssModel != null) {
                int offset = documentPosition;
                int pos = 0;
                IndexedRegion keyIndexedNode = cssModel.getIndexedRegion(pos);
                if (keyIndexedNode == null) {
                    keyIndexedNode = (IndexedRegion)((ICSSModel)cssModel).getDocument();
                }
                arranger = new CSSProposalArranger(pos, (ICSSNode)keyIndexedNode, offset, selection.getLength(), '\u0000');
            }
        } else if (parent != null && parent.getNodeName().equalsIgnoreCase("STYLE")) {
            cssModel = CSSCompletionProposalComputer.getCSSModel(parent);
            if (cssModel != null) {
                int offset = indexedNode.getStartOffset();
                int pos = documentPosition - offset;
                IndexedRegion keyIndexedNode = cssModel.getIndexedRegion(pos);
                if (keyIndexedNode == null) {
                    keyIndexedNode = (IndexedRegion)((ICSSModel)cssModel).getDocument();
                }
                arranger = new CSSProposalArranger(pos, (ICSSNode)keyIndexedNode, offset, selection.getLength(), '\u0000');
            }
        } else if (indexedNode instanceof IDOMNode) {
            IDOMNode domNode = (IDOMNode)indexedNode;
            IStructuredModel cssModel2 = CSSCompletionProposalComputer.getCSSModel(domNode);
            if (cssModel2 != null) {
                int textRegionStartOffset = CSSCompletionProposalComputer.getTextRegionStartOffset(domNode, documentPosition);
                int pos = documentPosition - textRegionStartOffset;
                char quote = '\u0000';
                try {
                    quote = context.getDocument().get(textRegionStartOffset, 1).charAt(0);
                }
                catch (BadLocationException e) {
                    Logger.logException((String)"error getting quote character", (Throwable)e);
                }
                IndexedRegion cssIndexedNode = cssModel2.getIndexedRegion(pos);
                if (cssIndexedNode == null) {
                    cssIndexedNode = (IndexedRegion)((ICSSModel)cssModel2).getDocument();
                }
                if (cssIndexedNode instanceof ICSSNode) {
                    arranger = new CSSProposalArranger(pos, (ICSSNode)cssIndexedNode, textRegionStartOffset, selection.getLength(), quote);
                }
            }
        } else if (indexedNode instanceof ICSSNode) {
            ICSSModel cssModel3;
            ICSSDocument cssdoc = ((ICSSNode)indexedNode).getOwnerDocument();
            if (cssdoc != null && (cssModel3 = cssdoc.getModel()) != null) {
                IndexedRegion keyIndexedNode = cssModel3.getIndexedRegion(documentPosition);
                if (keyIndexedNode == null) {
                    keyIndexedNode = (IndexedRegion)cssModel3.getDocument();
                }
                if (keyIndexedNode instanceof ICSSNode) {
                    arranger = new CSSProposalArranger(documentPosition, (ICSSNode)keyIndexedNode, 0, selection.getLength(), '\u0000');
                }
            }
        } else if (indexedNode == null && ContentAssistUtils.isViewerEmpty((ITextViewer)viewer)) {
            cssModel = null;
            try {
                cssModel = StructuredModelManager.getModelManager().getExistingModelForRead(viewer.getDocument());
                if (cssModel instanceof ICSSModel) {
                    IndexedRegion keyIndexedNode = cssModel.getIndexedRegion(documentPosition);
                    if (keyIndexedNode == null) {
                        keyIndexedNode = (IndexedRegion)((ICSSModel)cssModel).getDocument();
                    }
                    if (keyIndexedNode instanceof ICSSNode) {
                        arranger = new CSSProposalArranger(documentPosition, (ICSSNode)keyIndexedNode, 0, '\u0000');
                    }
                }
            }
            finally {
                if (cssModel != null) {
                    cssModel.releaseFromRead();
                }
            }
        }
        ICompletionProposal[] proposals = new ICompletionProposal[]{};
        if (arranger != null) {
            proposals = arranger.getProposals();
            ICompletionProposal[] newfileproposals = new ICompletionProposal[]{};
            ICompletionProposal[] anyproposals = new ICompletionProposal[]{};
            ICompletionProposal endTag = XMLContentAssistUtilities.computeXMLEndTagProposal((ITextViewer)viewer, (int)documentPosition, (IndexedRegion)indexedNode, (String)"STYLE", (String)"icons/full/obj16/tag-generic.gif");
            int additionalLength = newfileproposals.length + anyproposals.length;
            int n = additionalLength = endTag != null ? ++additionalLength : additionalLength;
            if (additionalLength > 0) {
                ICompletionProposal[] plusOnes = new ICompletionProposal[proposals.length + additionalLength];
                int appendPos = proposals.length;
                if (endTag != null) {
                    System.arraycopy(proposals, 0, plusOnes, 1, proposals.length);
                    plusOnes[0] = endTag;
                    ++appendPos;
                } else {
                    System.arraycopy(proposals, 0, plusOnes, 0, proposals.length);
                }
                int i = 0;
                while (i < newfileproposals.length) {
                    plusOnes[appendPos + i] = newfileproposals[i];
                    ++i;
                }
                appendPos += newfileproposals.length;
                i = 0;
                while (i < anyproposals.length) {
                    plusOnes[appendPos + i] = anyproposals[i];
                    ++i;
                }
                proposals = plusOnes;
            }
        }
        return Arrays.asList(proposals);
    }

    public List computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    private static IStructuredModel getCSSModel(IDOMNode element) {
        if (element == null) {
            return null;
        }
        INodeAdapter adapter = StyleAdapterFactory.getInstance().adapt((INodeNotifier)element);
        if (adapter == null || !(adapter instanceof ICSSModelAdapter)) {
            return null;
        }
        ICSSModelAdapter modelAdapter = (ICSSModelAdapter)adapter;
        return modelAdapter.getModel();
    }

    private static int getTextRegionStartOffset(IDOMNode domNode, int documentPosition) {
        IStructuredDocumentRegion structRegion = domNode.getFirstStructuredDocumentRegion();
        return structRegion.getStartOffset(structRegion.getRegionAtCharacterOffset(documentPosition));
    }
}

