/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.views;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.parsley.edit.ui.dnd.ViewerDragAndDropHelper;
import org.eclipse.emf.parsley.menus.ViewerContextMenuHelper;
import org.eclipse.emf.parsley.viewers.IStructuredViewerProvider;
import org.eclipse.emf.parsley.viewers.ViewerFactory;
import org.eclipse.emf.parsley.views.AbstractOnSelectionView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractOnSelectionViewerView
extends AbstractOnSelectionView
implements IStructuredViewerProvider {
    @Inject
    private ViewerFactory viewerFactory;
    @Inject
    private ViewerContextMenuHelper contextMenuHelper;
    @Inject
    private ViewerDragAndDropHelper dragAndDropHelper;

    protected AbstractOnSelectionViewerView() {
    }

    @Override
    protected void updateOnSelection(IWorkbenchPart sourcepart, ISelection selection) {
        Object element = this.getFirstSelectedElement(selection);
        this.viewerFactory.initialize(this.getViewer(), element);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createViewer(parent);
        this.afterCreateViewer();
    }

    protected void afterCreateViewer() {
        this.setViewerAsSelectionProvider();
        this.addContextMenuToViewer();
        this.addDragAndDropToViewer();
    }

    protected void setViewerAsSelectionProvider() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }

    protected abstract void createViewer(Composite var1);

    public void setFocus() {
        this.getViewer().getControl().setFocus();
    }

    public void init(URI resourceURI) {
        this.viewerFactory.initialize(this.getViewer(), resourceURI);
    }

    protected void addContextMenuToViewer() {
        this.contextMenuHelper.addViewerContextMenu(this.getViewer());
    }

    protected void addDragAndDropToViewer() {
        this.dragAndDropHelper.addDragAndDrop(this.getViewer());
    }
}

