/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal.expressions;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.properties.CustomExpression;
import org.eclipse.sirius.properties.CustomOperation;
import org.eclipse.sirius.properties.DynamicMappingForDescription;
import org.eclipse.sirius.properties.DynamicMappingIfDescription;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.GroupStyle;
import org.eclipse.sirius.properties.OperationDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.ToolbarAction;
import org.eclipse.sirius.properties.WidgetAction;
import org.eclipse.sirius.properties.WidgetConditionalStyle;
import org.eclipse.sirius.properties.WidgetDescription;
import org.eclipse.sirius.properties.WidgetStyle;
import org.eclipse.sirius.properties.core.internal.expressions.VSMNavigation;
import org.eclipse.sirius.properties.util.PropertiesSwitch;

public class DomainClassSwitch
extends PropertiesSwitch<Option<Collection<String>>> {
    private static final int DO_NOT_CONSIDER_FEATURE = -1;
    protected EStructuralFeature feature;
    protected boolean considerFeature;

    public DomainClassSwitch(EStructuralFeature feature) {
        this.feature = feature;
    }

    public Option<Collection<String>> doSwitch(EObject theEObject) {
        Option doSwitch = (Option)super.doSwitch(theEObject);
        if (doSwitch != null && doSwitch.some() && ((Collection)doSwitch.get()).size() > 0) {
            return doSwitch;
        }
        LinkedHashSet<String> defaultResult = new LinkedHashSet<String>();
        defaultResult.add(TypeName.EOBJECT_TYPENAME.getCompleteName());
        return Options.newSome(defaultResult);
    }

    public void setConsiderFeature(boolean considerFeature) {
        this.considerFeature = considerFeature;
    }

    public Option<Collection<String>> casePageDescription(PageDescription page) {
        Option result = null;
        switch (this.getFeatureId(page.eClass())) {
            case 5: {
                LinkedHashSet<String> target = new LinkedHashSet<String>();
                target.add(TypeName.EOBJECT_TYPENAME.getCompleteName());
                result = Options.newSome(target);
                break;
            }
            case -1: 
            case 3: 
            case 6: {
                result = Options.newSome(VSMNavigation.getPageDomainClass(page));
                break;
            }
        }
        return result;
    }

    public Option<Collection<String>> caseGroupDescription(GroupDescription group) {
        Option result = null;
        switch (this.getFeatureId(group.eClass())) {
            case 5: {
                LinkedHashSet<String> target = new LinkedHashSet<String>();
                for (PageDescription page : VSMNavigation.findReferencingPages(group)) {
                    target.addAll(VSMNavigation.getPageDomainClass(page));
                }
                result = Options.newSome(target);
                break;
            }
            case -1: 
            case 3: 
            case 6: {
                result = Options.newSome(VSMNavigation.getGroupDomainClass(group));
                break;
            }
        }
        return result;
    }

    public Option<Collection<String>> caseToolbarAction(ToolbarAction object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseWidgetDescription(WidgetDescription object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseWidgetStyle(WidgetStyle object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseWidgetConditionalStyle(WidgetConditionalStyle object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseWidgetAction(WidgetAction object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseGroupStyle(GroupStyle object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseCustomExpression(CustomExpression object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseCustomOperation(CustomOperation object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseOperationDescription(OperationDescription object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseDynamicMappingForDescription(DynamicMappingForDescription object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    public Option<Collection<String>> caseDynamicMappingIfDescription(DynamicMappingIfDescription object) {
        return VSMNavigation.getDomainClassFromContainingGroup((EObject)object);
    }

    private int getFeatureId(EClass eClass) {
        if (this.considerFeature && this.feature != null) {
            return eClass.getFeatureID(this.feature);
        }
        return -1;
    }
}

