/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.internal.util;

import java.io.IOException;
import java.io.Reader;

public class ConcatenatingReader
extends Reader {
    private final Reader[] readers;
    private int index = 0;

    public ConcatenatingReader(Reader ... readers) {
        this.readers = readers;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.index < this.readers.length) {
            int i;
            do {
                if ((i = this.readers[this.index].read(cbuf, off, len)) != -1) continue;
                ++this.index;
            } while (i == -1 && this.index < this.readers.length);
            return i;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        Reader[] readerArray = this.readers;
        int n = this.readers.length;
        int n2 = 0;
        while (n2 < n) {
            Reader reader = readerArray[n2];
            reader.close();
            ++n2;
        }
    }
}

