/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceRelationshipMappingAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.ManyToManyAnnotation2_0;

public final class SourceManyToManyAnnotation
extends SourceRelationshipMappingAnnotation
implements ManyToManyAnnotation2_0 {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter(ANNOTATION_NAME);
    private static final DeclarationAnnotationElementAdapter<String> TARGET_ENTITY_ADAPTER = SourceManyToManyAnnotation.buildTargetEntityAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceManyToManyAnnotation.buildFetchAdapter();
    private static final DeclarationAnnotationElementAdapter<String[]> CASCADE_ADAPTER = SourceManyToManyAnnotation.buildCascadeAdapter();
    private static final DeclarationAnnotationElementAdapter<String> MAPPED_BY_ADAPTER = SourceManyToManyAnnotation.buildMappedByAdapter();
    private final AnnotationElementAdapter<String> mappedByAdapter = this.buildAnnotationElementAdapter(MAPPED_BY_ADAPTER);
    private String mappedBy;
    private TextRange mappedByTextRange;

    public SourceManyToManyAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super(parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    public String getAnnotationName() {
        return ANNOTATION_NAME;
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.mappedBy = this.buildMappedBy(astAnnotation);
        this.mappedByTextRange = this.buildMappedByTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncMappedBy(this.buildMappedBy(astAnnotation));
        this.mappedByTextRange = this.buildMappedByTextRange(astAnnotation);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.mappedBy == null;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getTargetEntityAdapter() {
        return TARGET_ENTITY_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getFetchAdapter() {
        return FETCH_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String[]> getCascadeAdapter() {
        return CASCADE_ADAPTER;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String mappedBy) {
        if (ObjectTools.notEquals((Object)this.mappedBy, (Object)mappedBy)) {
            this.mappedBy = mappedBy;
            this.mappedByAdapter.setValue((Object)mappedBy);
        }
    }

    private void syncMappedBy(String astMappedBy) {
        String old = this.mappedBy;
        this.mappedBy = astMappedBy;
        this.firePropertyChanged("mappedBy", old, astMappedBy);
    }

    private String buildMappedBy(Annotation astAnnotation) {
        return (String)this.mappedByAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getMappedByTextRange() {
        return this.mappedByTextRange;
    }

    private TextRange buildMappedByTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(MAPPED_BY_ADAPTER, astAnnotation);
    }

    @Override
    public boolean mappedByTouches(int pos) {
        return this.textRangeTouches(this.mappedByTextRange, pos);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter() {
        return SourceManyToManyAnnotation.buildTargetEntityAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetEntity");
    }

    private static DeclarationAnnotationElementAdapter<String> buildMappedByAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"mappedBy");
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return SourceManyToManyAnnotation.buildFetchAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildCascadeAdapter() {
        return SourceManyToManyAnnotation.buildEnumArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "cascade");
    }
}

