/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.storage.bundlefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.CloseableBundleFile;
import org.eclipse.osgi.storage.bundlefile.DirZipBundleEntry;
import org.eclipse.osgi.storage.bundlefile.MRUBundleFileList;
import org.eclipse.osgi.storage.bundlefile.ZipBundleEntry;
import org.eclipse.osgi.util.NLS;

public class ZipBundleFile
extends CloseableBundleFile<ZipEntry> {
    final boolean verify;
    volatile ZipFile zipFile;

    public ZipBundleFile(File basefile, BundleInfo.Generation generation, MRUBundleFileList mruList, Debug debug, boolean verify) throws IOException {
        super(basefile, generation, mruList, debug);
        this.verify = verify;
        if (!BundleFile.secureAction.exists(basefile)) {
            throw new IOException(NLS.bind(Msg.ADAPTER_FILEEXIST_EXCEPTION, basefile));
        }
    }

    @Override
    protected void doOpen() throws IOException {
        this.zipFile = BundleFile.secureAction.getZipFile(this.basefile, this.verify);
    }

    private ZipEntry getZipEntry(String path) {
        ZipEntry dirEntry;
        ZipEntry entry;
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if ((entry = this.zipFile.getEntry(path)) != null && entry.getSize() == 0L && !entry.isDirectory() && (dirEntry = this.zipFile.getEntry(String.valueOf(path) + '/')) != null) {
            entry = dirEntry;
        }
        return entry;
    }

    @Override
    protected BundleEntry findEntry(String path) {
        ZipEntry zipEntry = this.getZipEntry(path);
        if (zipEntry == null) {
            if ((path.length() == 0 || path.charAt(path.length() - 1) == '/') && this.containsDir(path)) {
                return new DirZipBundleEntry(this, path);
            }
            return null;
        }
        return new ZipBundleEntry(zipEntry, this);
    }

    @Override
    protected void doClose() throws IOException {
        this.zipFile.close();
    }

    @Override
    protected void postClose() {
        this.zipFile = null;
    }

    @Override
    protected InputStream doGetInputStream(ZipEntry entry) throws IOException {
        return this.zipFile.getInputStream(entry);
    }

    @Override
    protected Iterable<String> getPaths() {
        return () -> {
            final Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return entries.hasMoreElements();
                }

                @Override
                public String next() {
                    ZipEntry entry = (ZipEntry)entries.nextElement();
                    return entry.getName();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        };
    }
}

