/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project.configurator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.builder.InternalBuildParticipant;
import org.eclipse.m2e.core.internal.builder.MavenBuilderImpl;
import org.eclipse.m2e.core.internal.embedder.MavenProjectMutableState;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant2;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLifecycleMapping
implements ILifecycleMapping {
    private static final Logger log = LoggerFactory.getLogger(AbstractLifecycleMapping.class);
    private String name;
    protected String id;
    private static final MavenBuilderImpl builder = new MavenBuilderImpl(){

        @Override
        protected boolean isApplicable(InternalBuildParticipant participant, int kind, IResourceDelta delta) {
            return true;
        }
    };

    @Override
    public void configure(ProjectConfigurationRequest request, IProgressMonitor mon) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)mon, (int)5);
        try {
            IFolder container;
            IPath targetPath;
            String directory;
            MavenPlugin.getProjectConfigurationManager().addMavenBuilder(request.mavenProjectFacade().getProject(), null, (IProgressMonitor)monitor.newChild(1));
            IMavenProjectFacade projectFacade = request.mavenProjectFacade();
            MavenProject mavenProject = request.mavenProject();
            Build build = mavenProject.getBuild();
            if (build != null && (directory = build.getDirectory()) != null && (targetPath = projectFacade.getProjectRelativePath(directory)) != null && (container = projectFacade.getProject().getFolder(targetPath)) != null) {
                if (!container.exists() && container instanceof IFolder) {
                    IFolder folder = container;
                    M2EUtils.createFolder((IContainer)folder, true, (IProgressMonitor)monitor.newChild(1));
                } else {
                    container.setDerived(true, (IProgressMonitor)monitor.newChild(1));
                }
            }
            MavenProjectMutableState snapshot = MavenProjectMutableState.takeSnapshot(mavenProject);
            try {
                LinkedHashMap participants = new LinkedHashMap();
                for (Map.Entry<MojoExecutionKey, List<AbstractBuildParticipant>> entry : this.getBuildParticipants(projectFacade, (IProgressMonitor)monitor).entrySet()) {
                    ArrayList<AbstractBuildParticipant> participants2 = new ArrayList<AbstractBuildParticipant>();
                    for (AbstractBuildParticipant participant : entry.getValue()) {
                        if (!(participant instanceof AbstractBuildParticipant2)) continue;
                        participants2.add(participant);
                    }
                    if (participants2.isEmpty()) continue;
                    participants.put(entry.getKey(), participants2);
                }
                projectFacade.createExecutionContext().execute((c, m) -> builder.build(c.getSession(), projectFacade, 65536, Collections.emptyMap(), participants, m), (IProgressMonitor)monitor);
                for (AbstractProjectConfigurator configurator : this.getProjectConfigurators(projectFacade, (IProgressMonitor)monitor.newChild(1))) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    try {
                        configurator.configure(request, (IProgressMonitor)monitor.newChild(1));
                    }
                    catch (RuntimeException e) {
                        String message = NLS.bind((String)Messages.AbstractLifecycleMapping_could_not_update_project_configuration, (Object)projectFacade.getProject().getName());
                        log.warn(message, (Throwable)e);
                        throw new CoreException(Status.error((String)message, (Throwable)e));
                    }
                }
            }
            finally {
                snapshot.restore(mavenProject);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void unconfigure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade projectFacade = request.mavenProjectFacade();
        for (AbstractProjectConfigurator configurator : this.getProjectConfigurators(projectFacade, monitor)) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            configurator.unconfigure(request, monitor);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public abstract boolean hasLifecycleMappingChanged(IMavenProjectFacade var1, ILifecycleMappingConfiguration var2, IProgressMonitor var3);
}

