/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LabelParser {
    static final Pattern LABEL_PATTERN = Pattern.compile("(-)?(!)?([^{}]+)(?:\\{([^}]+)\\})?");
    String label;
    boolean enabled = true;
    boolean checked = false;
    String description = null;

    public LabelParser(String labelExpression) {
        Matcher m = LABEL_PATTERN.matcher(labelExpression);
        if (m.matches()) {
            if (m.group(1) != null) {
                this.enabled = false;
            }
            if (m.group(2) != null) {
                this.checked = true;
            }
            this.label = m.group(3);
            this.description = m.group(4);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isChecked() {
        return this.checked;
    }
}

