/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd.participants.diagnostics;

import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.dtd.participants.diagnostics.DTDValidator;
import org.eclipse.lemminx.extensions.xerces.LSPXMLEntityResolver;
import org.eclipse.lemminx.services.extensions.diagnostics.DiagnosticsResult;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class DTDDiagnosticsParticipant
implements IDiagnosticsParticipant {
    private final ContentModelManager contentModelManager;

    public DTDDiagnosticsParticipant(ContentModelManager modelManager) {
        this.contentModelManager = modelManager;
    }

    @Override
    public void doDiagnostics(DOMDocument xmlDocument, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, CancelChecker cancelChecker) {
        if (!xmlDocument.isDTD()) {
            return;
        }
        URIResolverExtensionManager entityResolver = xmlDocument.getResolverExtensionManager();
        LSPXMLEntityResolver entityResolverWrapper = new LSPXMLEntityResolver(entityResolver, (DiagnosticsResult)diagnostics);
        DTDValidator.doDiagnostics(xmlDocument, entityResolverWrapper, diagnostics, validationSettings, this.contentModelManager, cancelChecker);
    }
}

