/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ui.ide.undo.ResourceDescription;

public class UndoDeleteResourceChange
extends Change {
    private final ResourceDescription fResourceDescription;

    public UndoDeleteResourceChange(ResourceDescription resourceDescription) {
        this.fResourceDescription = resourceDescription;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return MessageFormat.format(RefactoringCoreMessages.UndoDeleteResourceChange_change_name, BasicElementLabels.getResourceName(this.fResourceDescription.getName()));
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.fResourceDescription.isValid()) {
            return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(RefactoringCoreMessages.UndoDeleteResourceChange_cannot_restore, BasicElementLabels.getResourceName(this.fResourceDescription.getName())));
        }
        if (this.fResourceDescription.verifyExistence(true)) {
            return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format(RefactoringCoreMessages.UndoDeleteResourceChange_already_exists, BasicElementLabels.getResourceName(this.fResourceDescription.getName())));
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IResource created = this.fResourceDescription.createResource(pm);
        created.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        return new DeleteResourceChange(created.getFullPath(), true);
    }

    public String toString() {
        return "Remove " + this.fResourceDescription.getName();
    }
}

