/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.compare;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextViewerConfiguration;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.internal.genericeditor.Messages;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

public class GenericEditorMergeViewer
extends TextMergeViewer {
    private final Set<IContentType> fallbackContentTypes = new LinkedHashSet<IContentType>();
    private String title;

    public GenericEditorMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        Object id;
        if (configuration != null && (id = configuration.getProperty("CONTENT_TYPE")) instanceof String) {
            String contentTypeId = (String)id;
            IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
            while (contentType != null) {
                this.fallbackContentTypes.add(contentType);
                contentType = contentType.getBaseType();
            }
        }
    }

    protected SourceViewer createSourceViewer(Composite parent, int textOrientation) {
        final SourceViewer res = super.createSourceViewer(parent, textOrientation);
        res.addTextInputListener(new ITextInputListener(){

            public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                if (GenericEditorMergeViewer.this.fallbackContentTypes.isEmpty()) {
                    GenericEditorMergeViewer.this.fallbackContentTypes.addAll(new ExtensionBasedTextViewerConfiguration(null, null).getContentTypes(newInput));
                }
                GenericEditorMergeViewer.this.configureTextViewer((TextViewer)res);
            }

            public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                res.unconfigure();
            }
        });
        return res;
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer.getDocument() != null && textViewer instanceof ISourceViewer) {
            ISourceViewer sourceViewer = (ISourceViewer)textViewer;
            ExtensionBasedTextViewerConfiguration configuration = new ExtensionBasedTextViewerConfiguration(null, (IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{EditorsUI.getPreferenceStore(), GenericEditorPlugin.getDefault().getPreferenceStore()}));
            configuration.setFallbackContentTypes(this.fallbackContentTypes);
            sourceViewer.configure((SourceViewerConfiguration)configuration);
            Set<IContentType> contentTypes = configuration.getContentTypes(sourceViewer.getDocument());
            if (!contentTypes.isEmpty()) {
                IContentType contentType = contentTypes.iterator().next();
                this.title = NLS.bind((String)Messages.GenericEditorMergeViewer_title, (Object)contentType.getName());
            }
        }
    }

    public String getTitle() {
        return this.title != null ? this.title : super.getTitle();
    }
}

